/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.utils.DomHelper;
import io.fabric8.utils.Strings;
import io.fabric8.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Mojo(name="setup", requiresProject=true)
public class SetupMojo
extends AbstractFabric8Mojo {
    public static final String PLUGIN_GROUPID = "io.fabric8";
    public static final String PLUGIN_ARTIFACTID = "fabric8-maven-plugin";
    public static final String FABRIC8_MAVEN_PLUGIN_VERSION_PROPERTY = "fabric8.maven.plugin.version";
    @Parameter(property="updateVersion", defaultValue="true")
    private boolean updateVersion;
    @Parameter(property="useVersionProperty")
    private boolean useVersionProperty;
    @Parameter(property="generateBackupPoms")
    private boolean generateBackupPoms;
    @Parameter(name="backupPomFileName", defaultValue="${basedir}/pom.xml-backup")
    private File backupPomFileName;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        Document doc;
        File pom = this.project.getFile();
        try {
            doc = XmlUtils.parseDoc((File)pom);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to parse pom " + pom + ". " + e), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.createOrUpdateFabric8MavenPlugin(doc)) {
            if (this.generateBackupPoms) {
                try {
                    pom.renameTo(this.backupPomFileName);
                    this.getLog().info((CharSequence)("Created backup pom.xml file at: " + this.backupPomFileName));
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to create backup: " + this.backupPomFileName + ". " + e, e);
                }
            }
            this.getLog().info((CharSequence)("Updating the pom " + pom));
            try {
                DomHelper.save((Document)doc, (File)pom);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed to update pom " + pom + ". " + e), (Throwable)e);
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private boolean createOrUpdateFabric8MavenPlugin(Document doc) throws MojoExecutionException {
        String version;
        boolean pluginMissing;
        String latestVersion;
        boolean updated = false;
        try {
            latestVersion = MavenUtil.getVersion((String)PLUGIN_GROUPID, (String)PLUGIN_ARTIFACTID);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        String currentVersion = this.project.getProperties().getProperty(FABRIC8_MAVEN_PLUGIN_VERSION_PROPERTY);
        String versionExpression = "${fabric8.maven.plugin.version}";
        Element fmpPlugin = this.findPlugin(doc, PLUGIN_GROUPID, PLUGIN_ARTIFACTID);
        boolean bl = pluginMissing = fmpPlugin == null;
        if (this.updateVersion || pluginMissing) {
            if (this.useVersionProperty) {
                Element propertyElement;
                Element documentElement = doc.getDocumentElement();
                Element properties = DomHelper.firstChild((Element)documentElement, (String)"properties");
                if (properties == null) {
                    properties = this.addChildAfter(this.appendAfterLastElement(properties, doc.createTextNode("\n      ")), "properties");
                }
                if (Strings.isNullOrBlank((String)currentVersion)) {
                    this.addChildAfter(this.appendAfterLastElement(properties, doc.createTextNode("\n    ")), FABRIC8_MAVEN_PLUGIN_VERSION_PROPERTY, latestVersion);
                    updated = true;
                } else if (!Objects.equals(currentVersion, latestVersion) && (propertyElement = DomHelper.firstChild((Element)properties, (String)FABRIC8_MAVEN_PLUGIN_VERSION_PROPERTY)) != null) {
                    propertyElement.setTextContent(latestVersion);
                    updated = true;
                }
            } else {
                versionExpression = latestVersion;
            }
        }
        if (pluginMissing) {
            fmpPlugin = this.findOrAddPlugin(doc, PLUGIN_GROUPID, PLUGIN_ARTIFACTID, versionExpression);
            updated = true;
        }
        if (!(!this.updateVersion && !pluginMissing || (version = DomHelper.firstChildTextContent((Element)fmpPlugin, (String)"version")) != null && version.equals(versionExpression))) {
            Element versionElement = DomHelper.firstChild((Element)fmpPlugin, (String)"version");
            if (versionElement == null) {
                Element artifactId = DomHelper.firstChild((Element)fmpPlugin, (String)"artifactId");
                Text textNode = doc.createTextNode("\n        ");
                if (artifactId != null) {
                    this.addChildAfter((Node)artifactId, textNode);
                } else {
                    this.appendAfterLastElement(fmpPlugin, textNode);
                }
                this.addChildAfter(textNode, "version", versionExpression);
            } else {
                versionElement.setTextContent(versionExpression);
            }
            updated = true;
        }
        if (pluginMissing) {
            String[] goalNames;
            Element executions = DomHelper.firstChild((Element)fmpPlugin, (String)"executions");
            if (executions == null) {
                executions = this.addChildAfter(this.appendAfterLastElement(fmpPlugin, doc.createTextNode("\n        ")), "executions");
            } else {
                DomHelper.removeChildren((Element)executions);
            }
            executions.appendChild(doc.createTextNode("\n          "));
            Element execution = DomHelper.addChildElement((Node)executions, (String)"execution");
            execution.appendChild(doc.createTextNode("\n            "));
            DomHelper.addChildElement((Node)execution, (String)"id", (String)"fmp");
            execution.appendChild(doc.createTextNode("\n            "));
            Element goals = DomHelper.addChildElement((Node)execution, (String)"goals");
            execution.appendChild(doc.createTextNode("\n          "));
            for (String goalName : goalNames = new String[]{"resource", "helm", "build"}) {
                goals.appendChild(doc.createTextNode("\n              "));
                DomHelper.addChildElement((Node)goals, (String)"goal", (String)goalName);
            }
            goals.appendChild(doc.createTextNode("\n            "));
            executions.appendChild(doc.createTextNode("\n        "));
            updated = true;
        }
        return updated;
    }

    private Element addChildAfter(Node node, String elementName) {
        Document ownerDocument = node.getOwnerDocument();
        Element newChild = ownerDocument.createElement(elementName);
        return (Element)this.addChildAfter(node, newChild);
    }

    private Node addChildAfter(Node node, Node newChild) {
        Node element = node.getParentNode();
        Node nextSibling = node.getNextSibling();
        if (nextSibling != null) {
            element.insertBefore(newChild, nextSibling);
        } else {
            element.appendChild(newChild);
        }
        return newChild;
    }

    private Element addChildAfter(Node node, String elementName, String textContent) {
        Element newChild = this.addChildAfter(node, elementName);
        newChild.setTextContent(textContent);
        return newChild;
    }

    private Node appendAfterLastElement(Element element, Node newChild) {
        Node lastChild;
        for (lastChild = element.getLastChild(); lastChild != null && !(lastChild instanceof Element); lastChild = lastChild.getPreviousSibling()) {
        }
        Node nextSibling = null;
        if (lastChild != null) {
            nextSibling = lastChild.getNextSibling();
        }
        if (nextSibling != null) {
            element.insertBefore(newChild, nextSibling);
        } else {
            element.appendChild(newChild);
        }
        return newChild;
    }

    private Element findOrAddPlugin(Document doc, String groupId, String artifactId, String version) {
        Element plugins;
        Element plugin = this.findPlugin(doc, groupId, artifactId);
        if (plugin != null) {
            return plugin;
        }
        Element documentElement = doc.getDocumentElement();
        Element build = DomHelper.firstChild((Element)documentElement, (String)"build");
        if (build == null) {
            build = this.addChildAfter(this.appendAfterLastElement(documentElement, doc.createTextNode("\n  ")), "build");
        }
        if ((plugins = DomHelper.firstChild((Element)build, (String)"plugins")) == null) {
            plugins = this.addChildAfter(this.appendAfterLastElement(build, doc.createTextNode("\n    ")), "plugins");
        }
        plugin = this.addChildAfter(this.appendAfterLastElement(plugins, doc.createTextNode("\n      ")), "plugin");
        plugin.appendChild(doc.createTextNode("\n        "));
        DomHelper.addChildElement((Node)plugin, (String)"groupId", (String)groupId);
        plugin.appendChild(doc.createTextNode("\n        "));
        DomHelper.addChildElement((Node)plugin, (String)"artifactId", (String)artifactId);
        plugin.appendChild(doc.createTextNode("\n        "));
        DomHelper.addChildElement((Node)plugin, (String)"version", (String)version);
        plugin.appendChild(doc.createTextNode("\n      "));
        return plugin;
    }

    private Element findPlugin(Document doc, String groupId, String artifactId) {
        NodeList childNodes;
        Element plugins;
        Element build = DomHelper.firstChild((Element)doc.getDocumentElement(), (String)"build");
        if (build != null && (plugins = DomHelper.firstChild((Element)build, (String)"plugins")) != null && (childNodes = plugins.getChildNodes()) != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element plugin;
                Node item = childNodes.item(i);
                if (!(item instanceof Element) || !Objects.equals(DomHelper.firstChildTextContent((Element)(plugin = (Element)item), (String)"groupId"), groupId) || !Objects.equals(DomHelper.firstChildTextContent((Element)plugin, (String)"artifactId"), artifactId)) continue;
                return plugin;
            }
        }
        return null;
    }
}

