/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;

public abstract class AbstractResourceMojo
extends AbstractFabric8Mojo {
    @Parameter(property="fabric8.targetDir", defaultValue="${project.build.outputDirectory}/META-INF/fabric8")
    protected File targetDir;
    @Parameter(property="fabric8.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @Component
    private MavenProjectHelper projectHelper;

    protected Template getSingletonTemplate(KubernetesList resources) {
        HasMetadata singleEntity;
        List items;
        if (resources != null && (items = resources.getItems()) != null && items.size() == 1 && (singleEntity = (HasMetadata)items.get(0)) instanceof Template) {
            return (Template)singleEntity;
        }
        return null;
    }

    protected void writeResources(KubernetesList resources, ResourceClassifier classifier) throws MojoExecutionException {
        File resourceFileBase = new File(this.targetDir, classifier.getValue());
        KubernetesList entity = resources;
        Template template = this.getSingletonTemplate(resources);
        if (template != null) {
            entity = template;
        }
        File file = AbstractResourceMojo.writeResource(resourceFileBase, entity, this.resourceFileType);
        this.projectHelper.attachArtifact(this.project, this.resourceFileType.getArtifactType(), classifier.getValue(), file);
        if (this.resourceFileType.equals((Object)ResourceFileType.yaml)) {
            file = AbstractResourceMojo.writeResource(resourceFileBase, resources, ResourceFileType.json);
            this.projectHelper.attachArtifact(this.project, ResourceFileType.json.getArtifactType(), classifier.getValue(), file);
        }
        this.writeIndividualResources(resources, resourceFileBase);
    }

    private void writeIndividualResources(KubernetesList resources, File targetDir) throws MojoExecutionException {
        for (HasMetadata item : resources.getItems()) {
            String name = KubernetesHelper.getName((HasMetadata)item);
            if (Strings.isNullOrBlank((String)name)) {
                this.log.error("No name for generated item " + item, new Object[0]);
                continue;
            }
            String itemFile = KubernetesResourceUtil.getNameWithSuffix((String)name, (String)item.getKind());
            File itemTarget = new File(targetDir, itemFile);
            AbstractResourceMojo.writeResource(itemTarget, item, this.resourceFileType);
        }
    }

    private static File writeResource(File resourceFileBase, Object entity, ResourceFileType resourceFileType) throws MojoExecutionException {
        try {
            return KubernetesResourceUtil.writeResource((Object)entity, (File)resourceFileBase, (ResourceFileType)resourceFileType);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write resource to " + resourceFileBase + ". " + e, (Exception)e);
        }
    }
}

