/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatusType;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.AbstractDeployMojo;
import io.fabric8.utils.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.fusesource.jansi.Ansi;

public class AbstractTailLogMojo
extends AbstractDeployMojo {
    public static final String OPERATION_UNDEPLOY = "undeploy";
    public static final String OPERATION_STOP = "stop";
    private Watch podWatcher;
    private LogWatch logWatcher;
    private Map<String, Pod> addedPods = new ConcurrentHashMap<String, Pod>();
    private CountDownLatch terminateLatch = new CountDownLatch(1);
    private String watchingPodName;
    private String newestPodName;
    private CountDownLatch logWatchTerminateLatch;
    private Logger newPodLog;
    private Logger oldPodLog;

    protected void tailAppPodsLogs(final KubernetesClient kubernetes, final String namespace, final Set<HasMetadata> entities, boolean watchAddedPodsOnly, String onExitOperation, boolean followLog, Date ignorePodsOlderThan) {
        HasMetadata entity;
        LabelSelector selector = null;
        Iterator<HasMetadata> iterator = entities.iterator();
        while (iterator.hasNext() && (selector = this.getPodLabelSelector(entity = iterator.next())) == null) {
        }
        this.newPodLog = this.createLogger("New Pod> ", Ansi.Color.CYAN);
        this.oldPodLog = this.createLogger("Old Pod> ", Ansi.Color.DEFAULT);
        if (selector != null) {
            String ctrlCMessage = "stop tailing the log";
            if (Strings.isNotBlank((String)onExitOperation)) {
                final String onExitOperationLower = onExitOperation.toLowerCase().trim();
                if (onExitOperationLower.equals(OPERATION_UNDEPLOY)) {
                    ctrlCMessage = "undeploy the app";
                } else if (onExitOperationLower.equals(OPERATION_STOP)) {
                    ctrlCMessage = "scale down the app and stop tailing the log";
                } else {
                    this.log.warn("Unknown on-exit command: `" + onExitOperationLower + "`", new Object[0]);
                }
                Runtime.getRuntime().addShutdownHook(new Thread("mvn fabric8:run-interactive shutdown hook"){

                    @Override
                    public void run() {
                        if (onExitOperationLower.equals(AbstractTailLogMojo.OPERATION_UNDEPLOY)) {
                            AbstractTailLogMojo.this.log.info("Undeploying the app:", new Object[0]);
                            AbstractTailLogMojo.this.deleteEntities(kubernetes, namespace, entities);
                        } else if (onExitOperationLower.equals(AbstractTailLogMojo.OPERATION_STOP)) {
                            AbstractTailLogMojo.this.log.info("Stopping the app:", new Object[0]);
                            AbstractTailLogMojo.this.resizeApp(kubernetes, namespace, entities, 0);
                        }
                        if (AbstractTailLogMojo.this.podWatcher != null) {
                            AbstractTailLogMojo.this.podWatcher.close();
                        }
                        AbstractTailLogMojo.this.closeLogWatcher();
                    }
                });
            }
            this.waitAndLogPods(kubernetes, namespace, selector, watchAddedPodsOnly, ctrlCMessage, followLog, ignorePodsOlderThan);
        } else {
            this.log.warn("No selector in deployment so cannot watch pods!", new Object[0]);
        }
    }

    private void waitAndLogPods(final KubernetesClient kubernetes, final String namespace, LabelSelector selector, boolean watchAddedPodsOnly, final String ctrlCMessage, final boolean followLog, Date ignorePodsOlderThan) {
        List items;
        FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> pods = this.withSelector((ClientNonNamespaceOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>>)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(namespace)), selector);
        this.log.info("Watching pods with selector " + selector + " waiting for a running pod...", new Object[0]);
        Pod latestPod = null;
        boolean runningPod = false;
        PodList list = (PodList)pods.list();
        if (list != null && (items = list.getItems()) != null) {
            block5: for (Pod pod : items) {
                PodStatusType status = KubernetesHelper.getPodStatus((Pod)pod);
                switch (status) {
                    case WAIT: 
                    case OK: {
                        if (latestPod == null || this.isNewerPod((HasMetadata)pod, (HasMetadata)latestPod)) {
                            if (ignorePodsOlderThan != null) {
                                Date podCreateTime = this.getCreationTimestamp((HasMetadata)pod);
                                if (podCreateTime != null && podCreateTime.compareTo(ignorePodsOlderThan) > 0) {
                                    latestPod = pod;
                                }
                            } else {
                                latestPod = pod;
                            }
                        }
                        runningPod = true;
                        continue block5;
                    }
                }
            }
        }
        if (latestPod != null) {
            this.onPod(Watcher.Action.ADDED, latestPod, kubernetes, namespace, ctrlCMessage, followLog);
        }
        if (!watchAddedPodsOnly && !runningPod) {
            this.log.warn("No pod is running yet. Are you sure you deployed your app via `fabric8:deploy`?", new Object[0]);
            this.log.warn("Or did you stop it via `fabric8:stop`? If so try running the `fabric8:start` goal", new Object[0]);
        }
        this.podWatcher = (Watch)pods.watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                AbstractTailLogMojo.this.onPod(action, pod, kubernetes, namespace, ctrlCMessage, followLog);
            }

            public void onClose(KubernetesClientException e) {
            }
        });
        while (this.terminateLatch.getCount() > 0L) {
            try {
                this.terminateLatch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void onPod(Watcher.Action action, Pod pod, KubernetesClient kubernetes, String namespace, String ctrlCMessage, boolean followLog) {
        String name = KubernetesHelper.getName((HasMetadata)pod);
        if (action.equals((Object)Watcher.Action.DELETED)) {
            this.addedPods.remove(name);
            if (Objects.equals(this.watchingPodName, name)) {
                this.watchingPodName = null;
                this.addedPods.remove(name);
            }
        } else if (action.equals((Object)Watcher.Action.ADDED) || action.equals((Object)Watcher.Action.MODIFIED)) {
            this.addedPods.put(name, pod);
        }
        Pod watchPod = this.getNewestPod(this.addedPods.values());
        this.newestPodName = KubernetesHelper.getName((HasMetadata)watchPod);
        Logger statusLog = Objects.equals(name, this.newestPodName) ? this.newPodLog : this.oldPodLog;
        String message = "";
        switch (action) {
            case DELETED: {
                message = ": Pod Deleted";
                break;
            }
            case ERROR: {
                message = ": Error";
            }
        }
        if (!action.equals((Object)Watcher.Action.MODIFIED) || this.watchingPodName == null || !this.watchingPodName.equals(name)) {
            statusLog.info(name + " status: " + this.getPodStatusDescription(pod) + message, new Object[0]);
        }
        if (watchPod != null && KubernetesHelper.isPodRunning((Pod)watchPod)) {
            this.watchLogOfPodName(kubernetes, namespace, ctrlCMessage, followLog, KubernetesHelper.getName((HasMetadata)watchPod));
        }
    }

    private void watchLogOfPodName(KubernetesClient kubernetes, String namespace, String ctrlCMessage, boolean followLog, String name) {
        if (this.watchingPodName == null || !this.watchingPodName.equals(name)) {
            if (this.logWatcher != null) {
                this.log.info("Closing log watcher for " + this.watchingPodName + " as now watching " + name, new Object[0]);
                this.closeLogWatcher();
            }
            ClientPodResource podResource = (ClientPodResource)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(namespace)).withName(name);
            if (followLog) {
                this.watchingPodName = name;
                this.logWatchTerminateLatch = new CountDownLatch(1);
                this.logWatcher = (LogWatch)podResource.watchLog();
                this.watchLog(this.logWatcher, name, "Failed to read log of pod " + name + ".", ctrlCMessage);
            } else {
                String logText = (String)podResource.getLog();
                if (logText != null) {
                    String[] lines = logText.split("\n");
                    Logger log = this.createPodLogger();
                    log.info("Log of pod: " + name, new Object[0]);
                    log.info("", new Object[0]);
                    for (String line : lines) {
                        log.info(line, new Object[0]);
                    }
                }
                this.terminateLatch.countDown();
            }
        }
    }

    private void closeLogWatcher() {
        if (this.logWatcher != null) {
            this.logWatcher.close();
            this.logWatcher = null;
        }
        if (this.logWatchTerminateLatch != null) {
            this.logWatchTerminateLatch.countDown();
        }
    }

    private void watchLog(LogWatch logWatcher, String podName, final String failureMessage, String ctrlCMessage) {
        final InputStream in = logWatcher.getOutput();
        final Logger log = this.createPodLogger();
        this.newPodLog.info("Tailing log of pod: " + podName, new Object[0]);
        this.newPodLog.info("Press Ctrl-C to " + ctrlCMessage, new Object[0]);
        this.newPodLog.info("", new Object[0]);
        Thread thread = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            log.info("Log closed", new Object[0]);
                            return;
                        }
                        if (AbstractTailLogMojo.this.logWatchTerminateLatch.getCount() <= 0L) {
                            return;
                        }
                        log.info("%s", new Object[]{line});
                        continue;
                        break;
                    }
                }
                catch (IOException e) {
                    log.error("%s : %s", new Object[]{failureMessage, e});
                    return;
                }
            }
        };
        thread.start();
    }

    private Logger createPodLogger() {
        return this.createExternalProcessLogger("Pod> ");
    }

    private boolean isNewerPod(HasMetadata newer, HasMetadata older) {
        Date t1 = this.getCreationTimestamp(newer);
        Date t2 = this.getCreationTimestamp(older);
        if (t1 != null) {
            return t2 == null || t1.compareTo(t2) > 0;
        }
        return false;
    }
}

