/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builds.Builds;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.BuildRecreateMode;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.util.Gofabric8Util;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.DockerConnectionDetector;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.plugin.AbstractDeployMojo;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.maven.plugin.AbstractResourceMojo;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.fusesource.jansi.Ansi;

@Mojo(name="build", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildMojo
extends io.fabric8.maven.docker.BuildMojo {
    @Parameter
    private ProcessorConfig generator;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ResourceConfig resources;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.skip.build.pom", defaultValue="true")
    private boolean skipBuildPom;
    @Parameter(property="fabric8.mode")
    private PlatformMode mode = PlatformMode.DEFAULT;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.s2i.buildNameSuffix", defaultValue="-s2i")
    private String s2iBuildNameSuffix;
    @Parameter(property="fabric8.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="fabric8.build.recreate", defaultValue="none")
    private String buildRecreate;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter(property="fabric8.targetDir", defaultValue="${project.build.outputDirectory}/META-INF/fabric8")
    protected File targetDir;
    private ClusterAccess clusterAccess;
    private PlatformMode platformMode;
    private String lastBuildStatus;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.clusterAccess = new ClusterAccess(this.namespace);
        super.execute();
    }

    protected boolean isDockerAccessRequired() {
        return this.platformMode == PlatformMode.kubernetes;
    }

    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.project != null && this.skipBuildPom && Objects.equals("pom", this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"Disabling docker build for pom packaging");
            return;
        }
        super.executeInternal(hub);
    }

    protected List<DockerConnectionDetector.DockerHostProvider> getDockerHostProviders() {
        return Gofabric8Util.extractDockerHostProvider((Logger)this.log);
    }

    protected void buildAndTag(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, DockerAccessException {
        block4: {
            try {
                if (this.platformMode == PlatformMode.kubernetes) {
                    super.buildAndTag(hub, imageConfig);
                    break block4;
                }
                if (this.platformMode == PlatformMode.openshift) {
                    this.executeOpenShiftBuild(hub, imageConfig);
                    break block4;
                }
                throw new MojoExecutionException("Unknown platform mode " + this.mode + " for image " + imageConfig.getDescription());
            }
            catch (IOException e) {
                throw new MojoExecutionException("I/O Error executing build for image " + imageConfig.getDescription() + ":" + e, (Exception)e);
            }
        }
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        this.platformMode = this.clusterAccess.resolvePlatformMode(this.mode, this.log);
        return GeneratorManager.generate(configs, this.extractGeneratorConfig(), this.project, this.log, this.platformMode, this.buildStrategy, this.useProjectClasspath);
    }

    protected String getLogPrefix() {
        return "F8> ";
    }

    private ProcessorConfig extractGeneratorConfig() {
        try {
            return this.generator != null ? this.generator : ProfileUtil.extractProcesssorConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.resourceDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + e, e);
        }
    }

    private void executeOpenShiftBuild(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, IOException {
        MojoParameters params = this.createMojoParameters();
        ImageName imageName = new ImageName(imageConfig.getName());
        File dockerTar = hub.getArchiveService().createDockerBuildArchive(imageConfig, params);
        OpenShiftClient client = this.getOpenShiftClient();
        KubernetesListBuilder builder = new KubernetesListBuilder();
        String buildName = this.checkOrCreateBuildConfig(client, builder, imageConfig);
        this.checkOrCreateImageStream(client, builder, this.getImageStreamName(imageName));
        this.applyResourceObjects(client, builder);
        Build build = this.startBuild(dockerTar, client, buildName);
        this.waitForOpenShiftBuildToComplete(client, build);
        this.generateImageStreamTags(client, imageConfig, this.getImageStreamName(imageName), build);
    }

    private void waitForOpenShiftBuildToComplete(OpenShiftClient client, Build build) throws MojoExecutionException {
        final CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch logTerminateLatch = new CountDownLatch(1);
        final AtomicReference buildHolder = new AtomicReference();
        String buildName = KubernetesHelper.getName((HasMetadata)build);
        Watcher<Build> buildWatcher = new Watcher<Build>(){

            public void eventReceived(Watcher.Action action, Build resource) {
                buildHolder.set(resource);
                if (BuildMojo.this.isBuildCompleted(action, resource)) {
                    latch.countDown();
                }
            }

            public void onClose(KubernetesClientException cause) {
            }
        };
        this.log.info("Waiting for build " + buildName + " to complete...", new Object[0]);
        try (LogWatch logWatch = (LogWatch)((ClientPodResource)client.pods().withName(buildName + "-build")).watchLog();){
            KubernetesResourceUtil.watchLogInThread((LogWatch)logWatch, (String)"Failed to tail build log", (CountDownLatch)logTerminateLatch, (Logger)this.createExternalProcessLogger("Build> "));
            try (Watch watcher = (Watch)((ClientResource)client.builds().withName(buildName)).watch((Object)buildWatcher);){
                while (latch.getCount() > 0L) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                build = (Build)buildHolder.get();
                String status = KubernetesResourceUtil.getBuildStatusPhase((Build)build);
                if (Builds.isFailed((String)status) || Builds.isCancelled((String)status)) {
                    throw new MojoExecutionException("OpenShift Build " + buildName + " " + KubernetesResourceUtil.getBuildStatusReason((Build)build));
                }
                this.log.info("Build " + buildName + " " + status, new Object[0]);
            }
        }
    }

    protected Logger createExternalProcessLogger(String prefix) {
        return this.createLogger(prefix, AbstractFabric8Mojo.COLOR_POD_LOG);
    }

    protected Logger createLogger(String prefix, Ansi.Color color) {
        if (this.useColor) {
            prefix = prefix + Ansi.ansi().fg(color);
        }
        return new AnsiLogger(this.getLog(), this.useColor, this.verbose, prefix);
    }

    private void generateImageStreamTags(OpenShiftClient client, ImageConfiguration imageConfig, String imageStreamName, Build build) throws MojoExecutionException {
        ImageName imageName = new ImageName(imageConfig.getName());
        String label = imageName.getTag();
        if (Strings.isNullOrBlank((String)label)) {
            throw new MojoExecutionException("No ':' in image name so cannot extract the tag: " + imageName);
        }
        try {
            File manifest = this.openshiftManifest;
            if (!Files.isFile((File)manifest)) {
                throw new MojoFailureException("No such generated manifest file: " + manifest);
            }
            String namespace = this.clusterAccess.getNamespace();
            Controller controller = new Controller((KubernetesClient)client);
            Set<HasMetadata> entities = AbstractDeployMojo.loadResources((KubernetesClient)client, controller, namespace, manifest, this.project, this.log);
            boolean updated = false;
            ImageStream is = (ImageStream)KubernetesResourceUtil.findResourceByName(entities, ImageStream.class, (String)imageStreamName);
            if (is == null) {
                is = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.TagsNested)((TagReferenceFluent.FromNested)((ImageStreamSpecFluent.TagsNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(imageStreamName)).endMetadata()).withNewSpec().addNewTag().withName(label)).withNewFrom().withKind("ImageStreamImage")).endFrom()).endTag()).endSpec()).build();
                entities.add((HasMetadata)is);
                updated = true;
            }
            if (this.generateImageStreamTag(client, imageConfig, is, imageStreamName)) {
                updated = true;
            }
            if (updated) {
                KubernetesList entity = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(entities))).build();
                File resourceFileBase = new File(this.targetDir, ResourceClassifier.OPENSHIFT.getValue());
                AbstractResourceMojo.writeResourcesIndividualAndComposite(entity, resourceFileBase, ResourceFileType.yaml, this.log);
            }
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (Logger)this.log);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean generateImageStreamTag(OpenShiftClient client, ImageConfiguration imageConfig, ImageStream is, String imageStreamName) throws MojoExecutionException {
        ArrayList<TagReference> tags;
        String namespace = client.getNamespace();
        String imageName = imageConfig.getName();
        String label = BuildMojo.getImageLabel(imageName);
        ImageStream currentImageStream = (ImageStream)((ClientResource)client.imageStreams().withName(imageStreamName)).get();
        if (currentImageStream == null) {
            throw new MojoExecutionException("Could not find a current ImageStream with name " + imageStreamName + " in namespace " + namespace);
        }
        String tagSha = this.findTagSha(currentImageStream);
        String name = imageStreamName + "@" + tagSha;
        String kind = "ImageStreamImage";
        ImageStreamSpec spec = is.getSpec();
        if (spec != null) {
            spec = new ImageStreamSpec();
            is.setSpec(spec);
        }
        if ((tags = spec.getTags()) == null) {
            tags = new ArrayList<TagReference>();
            spec.setTags(tags);
        }
        TagReference tag = null;
        if (tags.isEmpty()) {
            tag = new TagReference();
            tags.add(tag);
        } else {
            tag = (TagReference)tags.get(tags.size() - 1);
        }
        ObjectReference from = tag.getFrom();
        if (from == null) {
            from = new ObjectReference();
            tag.setFrom(from);
        }
        boolean answer = false;
        if (!Objects.equals(label, tag.getName())) {
            tag.setName(label);
            answer = true;
        }
        if (!Objects.equals(kind, from.getKind())) {
            from.setKind(kind);
            answer = true;
        }
        if (!Objects.equals(namespace, from.getNamespace())) {
            from.setNamespace(namespace);
            answer = true;
        }
        if (!Objects.equals(name, from.getName())) {
            from.setName(name);
            answer = true;
        }
        if (answer) {
            this.log.info("Updated ImageStream " + imageStreamName + " to namespace: " + namespace + " name: " + name, new Object[0]);
        }
        return answer;
    }

    private static String getImageLabel(String imageName) throws MojoExecutionException {
        String label = new ImageName(imageName).getTag();
        if (Strings.isNullOrBlank((String)label)) {
            throw new MojoExecutionException("No ':' in the image name so cannot extract the tag: " + imageName);
        }
        return label;
    }

    private String findTagSha(ImageStream imageStream) throws MojoExecutionException {
        List tags;
        ImageStreamStatus status = imageStream.getStatus();
        if (status != null && (tags = status.getTags()) != null && !tags.isEmpty()) {
            for (NamedTagEventList list : tags) {
                List items = list.getItems();
                if (items == null) continue;
                for (TagEvent item : items) {
                    String image = item.getImage();
                    if (!Strings.isNotBlank((String)image)) continue;
                    return image;
                }
            }
        }
        throw new MojoExecutionException("Could not find a tag in the ImageStream " + KubernetesHelper.getName((HasMetadata)imageStream));
    }

    private boolean isBuildCompleted(Watcher.Action action, Build build) {
        String status = KubernetesResourceUtil.getBuildStatusPhase((Build)build);
        if (Strings.isNotBlank((String)status)) {
            if (!Objects.equals(status, this.lastBuildStatus)) {
                this.lastBuildStatus = status;
                this.log.verbose("Build %s status: %s", new Object[]{KubernetesHelper.getName((HasMetadata)build), status});
            }
            return Builds.isFinished((String)status);
        }
        return false;
    }

    private String getS2IBuildName(ImageName imageName) {
        return imageName.getSimpleName() + this.s2iBuildNameSuffix;
    }

    private String getImageStreamName(ImageName name) {
        return name.getSimpleName();
    }

    private OpenShiftClient getOpenShiftClient() throws MojoExecutionException {
        OpenShiftClient client = this.clusterAccess.createOpenShiftClient();
        if (!KubernetesHelper.isOpenShift((KubernetesClient)client)) {
            throw new MojoExecutionException("Cannot create OpenShift Docker build with a non-OpenShift cluster at " + client.getMasterUrl());
        }
        return client;
    }

    private Build startBuild(File dockerTar, OpenShiftClient client, String buildName) {
        this.log.info("Starting Build %s", new Object[]{buildName});
        return (Build)((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).instantiateBinary().fromFile(dockerTar);
    }

    private void applyResourceObjects(OpenShiftClient client, KubernetesListBuilder builder) throws IOException {
        if (builder.getItems().size() > 0) {
            this.enrich(builder);
            KubernetesList k8sList = builder.build();
            client.lists().create((Object[])new KubernetesList[]{k8sList});
        }
    }

    private void enrich(KubernetesListBuilder builder) throws IOException {
        ProcessorConfig resolvedEnricherConfig = this.enricher != null ? this.enricher : ProfileUtil.extractProcesssorConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.resourceDir);
        EnricherContext enricherContext = new EnricherContext(this.project, resolvedEnricherConfig, this.getResolvedImages(), this.resources, this.log, this.useProjectClasspath);
        EnricherManager enricherManager = new EnricherManager(enricherContext);
        enricherManager.enrich(builder);
    }

    private void checkOrCreateImageStream(OpenShiftClient client, KubernetesListBuilder builder, String imageStreamName) {
        boolean hasImageStream;
        boolean bl = hasImageStream = ((ClientResource)client.imageStreams().withName(imageStreamName)).get() != null;
        if (hasImageStream && this.getBuildRecreateMode().isImageStream()) {
            ((ClientResource)client.imageStreams().withName(imageStreamName)).delete();
            hasImageStream = false;
        }
        if (!hasImageStream) {
            this.log.info("Creating ImageStream %s", new Object[]{imageStreamName});
            ((BaseKubernetesListFluent.ImageStreamItemsNested)((ImageStreamFluent.MetadataNested)builder.addNewImageStreamItem().withNewMetadata().withName(imageStreamName)).endMetadata()).endImageStreamItem();
        } else {
            this.log.info("Using ImageStream %s", new Object[]{imageStreamName});
        }
    }

    private BuildRecreateMode getBuildRecreateMode() {
        return BuildRecreateMode.fromParameter((String)this.buildRecreate);
    }

    private String checkOrCreateBuildConfig(OpenShiftClient client, KubernetesListBuilder builder, ImageConfiguration imageConfig) {
        ImageName imageName = new ImageName(imageConfig.getName());
        String buildName = this.getS2IBuildName(imageName);
        String imageStreamName = this.getImageStreamName(imageName);
        BuildConfig buildConfig = (BuildConfig)((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).get();
        if (buildConfig != null) {
            String sourceType;
            BuildSource source;
            BuildConfigSpec spec = buildConfig.getSpec();
            if (spec != null && (source = spec.getSource()) != null && !Objects.equals("Binary", sourceType = source.getType())) {
                this.log.warn("BuildConfig " + buildName + " is not of type: Binary but is: " + sourceType + "!", new Object[0]);
            }
            if (!this.getBuildRecreateMode().isBuildConfig()) {
                String type = buildConfig.getSpec().getStrategy().getType();
                if (!this.buildStrategy.isSame(type)) {
                    ((DoneableBuildConfig)((BuildConfigFluent.SpecNested)((DoneableBuildConfig)((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).edit()).editSpec().withStrategy(this.createBuildStrategy(imageConfig))).endSpec()).done();
                    this.log.info("Editing BuildConfig %s for %s build", new Object[]{buildName, this.getStrategyLabel()});
                } else {
                    this.log.info("Using BuildConfig %s for %s build", new Object[]{buildName, this.getStrategyLabel()});
                }
                return buildName;
            }
            ((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).delete();
        }
        this.log.info("Creating BuildConfig %s for %s build", new Object[]{buildName, this.getStrategyLabel()});
        ((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.MetadataNested)builder.addNewBuildConfigItem().withNewMetadata().withName(buildName)).endMetadata()).withNewSpec().withStrategy(this.createBuildStrategy(imageConfig))).withNewSource().withType("Binary")).endSource()).withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(imageStreamName + ":" + imageName.getTag())).endTo()).endOutput()).endSpec()).endBuildConfigItem();
        return buildName;
    }

    private String getStrategyLabel() {
        return this.buildStrategy == OpenShiftBuildStrategy.s2i ? "S2I" : "Docker";
    }

    private BuildStrategy createBuildStrategy(ImageConfiguration imageConfig) {
        if (this.buildStrategy == OpenShiftBuildStrategy.docker) {
            return ((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Docker")).build();
        }
        if (this.buildStrategy == OpenShiftBuildStrategy.s2i) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            Map fromExt = buildConfig.getFromExt();
            String fromName = this.getMapValueWithDefault(fromExt, "name", buildConfig.getFrom());
            String fromNamespace = this.getMapValueWithDefault(fromExt, "namespace", "");
            String fromKind = this.getMapValueWithDefault(fromExt, "kind", "DockerImage");
            if ("ImageStreamTag".equals(fromKind) && fromNamespace == null) {
                fromNamespace = "openshift";
            }
            if (fromNamespace.isEmpty()) {
                fromNamespace = null;
            }
            return ((BuildStrategyBuilder)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Source")).withNewSourceStrategy().withNewFrom().withKind(fromKind)).withName(fromName)).withNamespace(fromNamespace)).endFrom()).endSourceStrategy()).build();
        }
        throw new IllegalArgumentException("Unsupported BuildStrategy " + this.buildStrategy);
    }

    private String getMapValueWithDefault(Map<String, String> map, String field, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        String value = map.get(field);
        return value != null ? value : defaultValue;
    }
}

