/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public abstract class AbstractInstallMojo
extends AbstractFabric8Mojo {
    private static final String gofabric8VersionURL = "https://raw.githubusercontent.com/fabric8io/gofabric8/master/version/VERSION";
    public static final String batchModeArgument = " --batch";
    public static final String GOFABRIC8 = "gofabric8";
    @Parameter(property="fabric8.cluster.kind")
    protected String clusterKind;
    @Parameter(property="fabric8.dir", defaultValue="${user.home}/.fabric8/bin")
    private File fabric8Dir;
    @Component
    private Prompter prompter;

    protected File installBinaries() throws MojoExecutionException {
        File file = ProcessUtil.findExecutable((Logger)this.log, (String)GOFABRIC8);
        if (file == null) {
            File binDir = this.getFabric8Dir();
            binDir.mkdirs();
            if (!binDir.isDirectory() || !binDir.exists()) {
                throw new MojoExecutionException("Failed to create directory: " + binDir + ". Do you have permission on this folder?");
            }
            file = new File(binDir, GOFABRIC8);
            if (!(file.exists() && file.isFile() && file.canExecute())) {
                this.downloadGoFabric8(file);
            }
            if (!ProcessUtil.folderIsOnPath((Logger)this.log, (File)binDir)) {
                String absolutePath = binDir.getAbsolutePath();
                String commandIndent = "  ";
                this.log.warn("Note that the fabric8 folder " + absolutePath + " is not on the PATH!", new Object[0]);
                if (this.getPlatform().equals("windows")) {
                    this.log.warn("Please add the following to PATH environment variable:", new Object[0]);
                    this.log.warn(commandIndent + "set PATH=%PATH%;" + absolutePath, new Object[0]);
                } else {
                    String[] rcFiles;
                    String bashrcLine = "export PATH=$PATH:" + absolutePath;
                    this.log.warn("Please add the following to your ~/.bashrc:", new Object[0]);
                    this.log.warn(commandIndent + bashrcLine, new Object[0]);
                    File homeDir = this.getUserHome();
                    File rcFile = null;
                    for (String fileName : rcFiles = new String[]{".bashrc", ".zshrc", ".profile", ".bash_profile"}) {
                        File testFile = new File(homeDir, fileName);
                        if (!AbstractInstallMojo.fileExists(testFile)) continue;
                        rcFile = testFile;
                        break;
                    }
                    if (rcFile == null) {
                        rcFile = new File(".bashrc");
                    }
                    if (this.prompter != null && rcFile.getParentFile().isDirectory()) {
                        String answer = null;
                        try {
                            answer = this.prompter.prompt("Would you like to add this line to your ~/" + rcFile.getName() + " now? (Y/n)");
                        }
                        catch (PrompterException e) {
                            this.log.warn("Failed to ask user prompt: " + (Object)((Object)e), new Object[]{e});
                        }
                        if (answer != null && answer.startsWith("Y")) {
                            this.addToBashRC(rcFile, bashrcLine);
                            this.log.info("Updated " + rcFile + ". Please type the following command to update your current shell:", new Object[0]);
                            this.log.info(commandIndent + "source ~/" + rcFile.getName(), new Object[0]);
                        }
                    }
                }
            }
        } else {
            this.getLog().info((CharSequence)("Found gofabric8 at: " + file));
            this.runCommand(file.getAbsolutePath() + " version" + batchModeArgument, "gofabric8 version --batch", GOFABRIC8);
        }
        return file;
    }

    protected static boolean fileExists(File testFile) {
        return testFile.exists() && testFile.isFile();
    }

    protected void addToBashRC(File bashrcFile, String text) throws MojoExecutionException {
        try (FileWriter writer = new FileWriter(bashrcFile, true);){
            writer.append("\n# added by fabric8-maven-plugin at " + new Date() + "\n" + text + "\n");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to append to " + bashrcFile + ". " + e, (Exception)e);
        }
    }

    protected File getUserHome() {
        return new File(System.getProperty("user.home", "."));
    }

    protected void downloadGoFabric8(File destFile) throws MojoExecutionException {
        InputStream inputStream;
        URL downloadUrl;
        String version;
        File file = null;
        try {
            file = File.createTempFile("fabric8", ".bin");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create a temporary file for the download");
        }
        this.log.debug("Downloading gofabric8 to temporary file: " + file.getAbsolutePath(), new Object[0]);
        try {
            version = IOHelpers.readFully((URL)new URL(gofabric8VersionURL));
            this.log.info("Downloading version " + version + " of gofabric8 to " + destFile + " ...", new Object[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load gofabric8 version from: https://raw.githubusercontent.com/fabric8io/gofabric8/master/version/VERSION. " + e, (Exception)e);
        }
        String platform = this.getPlatform();
        String osArch = System.getProperty("os.arch");
        String arch = "amd64";
        if (osArch.toLowerCase().contains("arm")) {
            arch = "arm";
        }
        String releaseUrl = "https://github.com/fabric8io/gofabric8/releases/download/v" + version + "/gofabric8-" + platform + "-" + arch;
        if (platform.equals("windows")) {
            releaseUrl = releaseUrl + ".exe";
        }
        try {
            downloadUrl = new URL(releaseUrl);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to create URL: " + releaseUrl + ". " + e, (Exception)e);
        }
        try {
            inputStream = downloadUrl.openStream();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to open URL: " + releaseUrl + ". " + e, (Exception)e);
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            IOHelpers.copy((InputStream)inputStream, (OutputStream)out);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to download URL: " + releaseUrl + " to file: " + file + ". " + e, (Exception)e);
        }
        file.setExecutable(true);
        this.runCommand(file.getAbsolutePath() + " version" + batchModeArgument, "gofabric8 version --batch", GOFABRIC8);
        boolean result = file.renameTo(destFile);
        if (!result) {
            try {
                IOHelpers.copy((InputStream)new FileInputStream(file), (OutputStream)new FileOutputStream(destFile));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy temporary file " + file + " to " + destFile + ": " + e, (Exception)e);
            }
        }
        this.log.info("Downloaded gofabric8 version " + version + " platform: " + platform + " arch:" + arch + " on: " + System.getProperty("os.name") + " " + arch + " to: " + destFile, new Object[0]);
    }

    protected String getPlatform() {
        String osName = System.getProperty("os.name");
        String platform = "linux";
        if (osName.contains("OS X") || osName.contains("Mac ")) {
            platform = "darwin";
        } else if (osName.contains("Windows")) {
            platform = "windows";
        }
        return platform;
    }

    protected void runCommand(String commandLine, String message, String executableName) throws MojoExecutionException {
        this.log.info("Running command " + executableName + " " + commandLine, new Object[0]);
        int result = -1;
        try {
            result = ProcessUtil.runCommand((Logger)this.createExternalProcessLogger("[[B]]" + executableName + "[[B]] "), (String)commandLine, (String)message);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute " + message + ". " + e, (Exception)e);
        }
        if (result != 0) {
            throw new MojoExecutionException("Failed to execute " + message + " result was: " + result);
        }
    }

    protected File getFabric8Dir() {
        if (this.fabric8Dir == null) {
            this.fabric8Dir = new File(".");
        }
        this.fabric8Dir.mkdirs();
        return this.fabric8Dir;
    }

    protected boolean isMinishift() {
        if (Strings.isNotBlank((String)this.clusterKind)) {
            String text = this.clusterKind.toLowerCase().trim();
            return text.equals("minishift") || text.equals("openshift");
        }
        return false;
    }

    public static class Architectures {
        public static final String AMD64 = "amd64";
        public static final String ARM = "arm";
    }

    public static class Platforms {
        public static final String LINUX = "linux";
        public static final String DARWIN = "darwin";
        public static final String WINDOWS = "windows";
    }
}

