/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.maven.core.util.VersionUtil;
import io.fabric8.maven.plugin.AbstractArtifactSearchMojo;
import io.fabric8.maven.plugin.HelmMojo;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.tar.TarUnArchiver;

@Mojo(name="helm-index")
public class HelmIndexMojo
extends AbstractArtifactSearchMojo {
    @Parameter(property="fabric8.helm.indexTitle", defaultValue="Chart Repository")
    private String helmTitle;
    @Parameter(property="fabric8.helm.introductionHtmlFile", defaultValue="${basedir}/src/main/fabric8/site/helm-introduction.html")
    private File introductionHtmlFile;
    @Parameter(property="fabric8.helm.headHtmlFile", defaultValue="${basedir}/src/main/fabric8/site/helm-head.html")
    private File headHtmlFile;
    @Parameter(property="fabric8.helm.footerHtmlFile", defaultValue="${basedir}/src/main/fabric8/site/helm-footer.html")
    private File footerHtmlFile;
    @Parameter(property="fabric8.helm.outputYamlFile", defaultValue="${project.build.directory}/fabric8/site/helm/index.yaml")
    private File outputFile;
    @Parameter(property="fabric8.helm.outputHtmlFile", defaultValue="${project.build.directory}/fabric8/site/helm/index.html")
    private File outputHtmlFile;
    @Parameter(property="fabric8.helm.tempDir", defaultValue="${project.build.directory}/fabric8/tmp-charts")
    private File tempDir;
    @Component(role=UnArchiver.class, hint="tar")
    private TarUnArchiver unArchiver;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        this.outputFile.getParentFile().mkdirs();
        this.log.info("Creating Helm Chart Index file at: %s", new Object[]{this.outputFile});
        List<AbstractArtifactSearchMojo.ArtifactDTO> artifacts = this.searchMaven("?q=l:%22helm%22");
        ChartsRepository repository = new ChartsRepository();
        TreeMap<String, ChartInfo> charts = new TreeMap<String, ChartInfo>();
        for (AbstractArtifactSearchMojo.ArtifactDTO artifactDTO : artifacts) {
            this.addChartInfo(repository, charts, artifactDTO);
        }
        Set entries = charts.entrySet();
        for (Map.Entry entry : entries) {
            this.getLog().debug((CharSequence)("" + (String)entry.getKey() + " = " + entry.getValue()));
        }
        try {
            ObjectMapper objectMapper = KubernetesHelper.createYamlObjectMapper();
            objectMapper.writeValue(this.outputFile, (Object)repository);
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to write results as YAML to: " + this.outputFile + ". " + iOException, (Exception)iOException);
        }
        this.generateHTML(this.outputHtmlFile, charts);
    }

    protected void generateHTML(File outputHtmlFile, Map<String, ChartInfo> charts) throws MojoExecutionException {
        TreeMap<String, TreeSet<ChartInfo>> chartMap = new TreeMap<String, TreeSet<ChartInfo>>();
        for (ChartInfo chartInfo : charts.values()) {
            String key = chartInfo.getName();
            TreeSet<ChartInfo> set = (TreeSet<ChartInfo>)chartMap.get(key);
            if (set == null) {
                set = new TreeSet<ChartInfo>(this.createChartComparator());
                chartMap.put(key, set);
            }
            set.add(chartInfo);
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(outputHtmlFile));){
            writer.println("<html>");
            writer.println("<head>");
            writer.println(HelmIndexMojo.getHtmlFileContentOrDefault(this.headHtmlFile, "<link href='style.css' rel=stylesheet>\n<link href='custom.css' rel=stylesheet>\n<title>" + this.helmTitle + "</title>\n"));
            writer.println("</head>");
            writer.println("<body>");
            writer.println(HelmIndexMojo.getHtmlFileContentOrDefault(this.introductionHtmlFile, "<h1>" + this.helmTitle + "</h1>"));
            writer.println("<table class='table table-striped table-hover'>");
            writer.println("  <hhead>");
            writer.println("    <tr>");
            writer.println("      <th>Chart</th>");
            writer.println("      <th>Versions</th>");
            writer.println("    </tr>");
            writer.println("  </hhead>");
            writer.println("  <tbody>");
            for (Map.Entry entry : chartMap.entrySet()) {
                ChartInfo first;
                HelmMojo.Chart firstChartfile;
                String key = (String)entry.getKey();
                SortedSet set = (SortedSet)entry.getValue();
                if (set.isEmpty() || (firstChartfile = (first = (ChartInfo)set.first()).getChartfile()) == null) continue;
                String chartDescription = HelmIndexMojo.getDescription(firstChartfile);
                writer.println("    <tr>");
                writer.println("      <td title='" + chartDescription + "'>");
                String iconHtml = "";
                String iconUrl = this.findIconURL(first, set);
                if (Strings.isNotBlank((String)iconUrl)) {
                    iconHtml = "<img class='logo' src='" + iconUrl + "'>";
                }
                writer.println("        " + iconHtml + "<span class='chart-name'>" + key + "</span>");
                writer.println("      </td>");
                writer.println("      <td class='versions'>");
                for (ChartInfo chartInfo : set) {
                    HelmMojo.Chart chartfile = chartInfo.getChartfile();
                    if (chartfile == null) continue;
                    String description = HelmIndexMojo.getDescription(chartfile);
                    String version = chartfile.getVersion();
                    String href = chartInfo.firstUrl();
                    writer.println("        <a href='" + href + "' title='" + description + "'>" + version + "</a>");
                }
                writer.println("      </td>");
                writer.println("    </tr>");
            }
            writer.println("  </tbody>");
            writer.println("  </table>");
            writer.println(HelmIndexMojo.getHtmlFileContentOrDefault(this.footerHtmlFile, ""));
            writer.println("</body>");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + outputHtmlFile + ". " + e, (Exception)e);
        }
    }

    private String findIconURL(ChartInfo first, Iterable<ChartInfo> chartInfos) throws MojoExecutionException {
        for (ChartInfo chartInfo : chartInfos) {
            String icon;
            HelmMojo.Chart chartfile = chartInfo.getChartfile();
            if (chartfile == null || !Strings.isNotBlank((String)(icon = chartfile.getIcon()))) continue;
            return this.convertRelativeIcon(icon);
        }
        String answer = this.convertRelativeIcon(HelmIndexMojo.findManifestIcon(first.getKubernetesManifest()));
        if (Strings.isNullOrBlank((String)answer)) {
            answer = "https://fabric8.io/images/logos/kubernetes.png";
        }
        return answer;
    }

    private static String getDescription(HelmMojo.Chart firstChartfile) {
        String answer = firstChartfile.getDescription();
        return answer != null ? answer : "";
    }

    private Comparator<ChartInfo> createChartComparator() {
        return new Comparator<ChartInfo>(){

            @Override
            public int compare(ChartInfo c1, ChartInfo c2) {
                String v2;
                String v1 = HelmIndexMojo.getVersion(c1);
                int answer = VersionUtil.compareVersions((String)v1, (String)(v2 = HelmIndexMojo.getVersion(c2)));
                if (answer > 0) {
                    return -1;
                }
                if (answer < 0) {
                    return 1;
                }
                return 0;
            }
        };
    }

    protected static String getVersion(ChartInfo c1) {
        HelmMojo.Chart chartfile = c1.getChartfile();
        if (chartfile != null) {
            return chartfile.getVersion();
        }
        return null;
    }

    protected void addChartInfo(ChartsRepository repository, Map<String, ChartInfo> charts, AbstractArtifactSearchMojo.ArtifactDTO artifact) {
        ChartInfo latest = new ChartInfo(this.mavenRepoUrl, artifact);
        String key = artifact.createKey();
        HelmMojo.Chart chartfile = this.createChartFile(artifact);
        if (chartfile != null) {
            latest.setChartfile(chartfile);
            charts.put(key, latest);
            repository.addChart(latest);
        } else {
            this.getLog().warn((CharSequence)("Could not find chartfile for " + latest));
        }
    }

    private HelmMojo.Chart createChartFile(AbstractArtifactSearchMojo.ArtifactDTO artifactDTO) {
        File file = this.resolveArtifactFile(artifactDTO, "helm", "tar.gz");
        File untarDestDir = new File(this.tempDir, artifactDTO.getG() + "/" + artifactDTO.getA() + "-" + artifactDTO.getV() + "-chart");
        untarDestDir.mkdirs();
        this.getLog().debug((CharSequence)("" + artifactDTO.description() + " extracting " + file.getAbsolutePath() + " to " + untarDestDir));
        this.unArchiver.setSourceFile(file);
        this.unArchiver.setDestDirectory(untarDestDir);
        this.unArchiver.setCompression(TarUnArchiver.UntarCompressionMethod.GZIP);
        this.unArchiver.extract();
        File tempChartFile = this.findChartFile(untarDestDir);
        if (!tempChartFile.isFile() || !tempChartFile.exists()) {
            this.getLog().warn((CharSequence)("No Chart.yaml exists at " + tempChartFile));
            return null;
        }
        try {
            return (HelmMojo.Chart)KubernetesHelper.loadYaml((File)tempChartFile, HelmMojo.Chart.class);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to parse " + tempChartFile + ". " + e), (Throwable)e);
            return null;
        }
    }

    private File findChartFile(File chartDir) {
        File answer = new File(chartDir, "Chart.yaml");
        if (answer.isFile() && answer.exists()) {
            return answer;
        }
        File[] files = chartDir.listFiles();
        if (files != null) {
            for (File file : files) {
                answer = new File(file, "Chart.yaml");
                if (!answer.isFile() || !answer.exists()) continue;
                return answer;
            }
        }
        return answer;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected class ChartInfo {
        private List<String> urls = new ArrayList<String>();
        private String name;
        @JsonIgnore
        private HelmMojo.Chart chartfile;
        @JsonIgnore
        private final AbstractArtifactSearchMojo.ArtifactDTO artifact;
        @JsonIgnore
        private Object kubernetesManifest;

        public ChartInfo(String mavenRepoUrl, AbstractArtifactSearchMojo.ArtifactDTO artifact) {
            this.artifact = artifact;
            String artifactId = artifact.getA();
            String version = artifact.getV();
            this.urls.add(mavenRepoUrl + artifact.getG().replace('.', '/') + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "-helm.tar.gz");
            this.name = artifactId;
        }

        public String toString() {
            return "ChartInfo{urls='" + this.urls + '\'' + ", name='" + this.name + '\'' + ", chartfile=" + this.chartfile + '}';
        }

        public String getHome() {
            return this.getChartfile().getHome();
        }

        public List<String> getSources() {
            return this.getChartfile().getSources();
        }

        public String getVersion() {
            return this.getChartfile().getVersion();
        }

        public String getDescription() {
            return this.getChartfile().getDescription();
        }

        public List<String> getKeywords() {
            return this.getChartfile().getKeywords();
        }

        public List<HelmMojo.Chart.Maintainer> getMaintainers() {
            return this.getChartfile().getMaintainers();
        }

        public String getEngine() {
            return this.getChartfile().getEngine();
        }

        public String getIcon() {
            return this.getChartfile().getIcon();
        }

        public String firstUrl() {
            if (this.urls != null && !this.urls.isEmpty()) {
                return this.urls.get(0);
            }
            return "";
        }

        public List<String> getUrls() {
            return this.urls;
        }

        public void setUrls(List<String> urls) {
            this.urls = urls;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public HelmMojo.Chart getChartfile() {
            return this.chartfile;
        }

        public void setChartfile(HelmMojo.Chart chartfile) {
            this.chartfile = chartfile;
        }

        public AbstractArtifactSearchMojo.ArtifactDTO getArtifact() {
            return this.artifact;
        }

        public Object getKubernetesManifest() {
            if (this.kubernetesManifest == null) {
                this.kubernetesManifest = HelmIndexMojo.this.loadKubernetesManifestFile(this.artifact);
            }
            return this.kubernetesManifest;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected class ChartsRepository {
        private String apiVersion = "v1";
        private Map<String, List<ChartInfo>> entries = new TreeMap<String, List<ChartInfo>>();

        protected ChartsRepository() {
        }

        public void addChart(ChartInfo chart) {
            String name;
            List<ChartInfo> list;
            if (this.entries == null) {
                this.entries = new TreeMap<String, List<ChartInfo>>();
            }
            if ((list = this.entries.get(name = chart.getName())) == null) {
                list = new ArrayList<ChartInfo>();
                this.entries.put(name, list);
            }
            list.add(chart);
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public Map<String, List<ChartInfo>> getEntries() {
            return this.entries;
        }

        public void setEntries(Map<String, List<ChartInfo>> entries) {
            this.entries = entries;
        }
    }
}

