/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.core.util.GoalFinder;
import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftNotAvailableException;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public abstract class AbstractFabric8Mojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(property="fabric8.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="fabric8.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Component
    protected GoalFinder goalFinder;
    protected Logger log;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.log = this.createLogger(" ");
        this.executeInternal();
    }

    public abstract void executeInternal() throws MojoExecutionException, MojoFailureException;

    protected String getProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = this.project.getProperties().getProperty(key);
        }
        return value;
    }

    protected Logger createExternalProcessLogger(String prefix) {
        return this.createLogger(prefix + "[[s]]");
    }

    protected Logger createLogger(String prefix) {
        return new AnsiLogger(this.getLog(), this.useColor, this.verbose, this.settings.getInteractiveMode() == false, "F8:" + prefix);
    }

    protected OpenShiftClient getOpenShiftClientOrJenkinsShift(KubernetesClient kubernetes, String namespace) throws MojoExecutionException {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull(kubernetes);
        if (openShiftClient == null) {
            String jenkinshiftUrl = AbstractFabric8Mojo.getJenkinShiftUrl(kubernetes, namespace);
            this.log.debug("Using jenkinshift URL: " + jenkinshiftUrl, new Object[0]);
            if (jenkinshiftUrl == null) {
                throw new MojoExecutionException("Could not find the service `jenkinshift` im namespace `" + namespace + "` on this kubernetes cluster " + kubernetes.getMasterUrl());
            }
            return KubernetesHelper.createJenkinshiftOpenShiftClient((String)jenkinshiftUrl);
        }
        if (openShiftClient == null) {
            throw new MojoExecutionException("Not connected to an OpenShift cluster and JenkinShift could not be found! Cluster: " + kubernetes.getMasterUrl());
        }
        return openShiftClient;
    }

    public static String getJenkinShiftUrl(KubernetesClient kubernetes, String namespace) {
        String fabric8ConsoleURL;
        String jenkinshiftUrl = KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"jenkinshift", (String)namespace, (String)"http", (boolean)true);
        if (jenkinshiftUrl == null && Strings.isNotBlank((String)(fabric8ConsoleURL = AbstractFabric8Mojo.getFabric8ConsoleServiceUrl(kubernetes, namespace)))) {
            jenkinshiftUrl = URLUtils.pathJoin((String[])new String[]{fabric8ConsoleURL, "/k8s"});
        }
        return jenkinshiftUrl;
    }

    private static String getFabric8ConsoleServiceUrl(KubernetesClient kubernetes, String namespace) {
        return KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"fabric8", (String)namespace, (String)"http", (boolean)true);
    }

    protected OpenShiftClient getOpenShiftClientOrNull(KubernetesClient kubernetesClient) {
        try {
            return (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);
        }
        catch (OpenShiftNotAvailableException openShiftNotAvailableException) {
            return null;
        }
    }
}

