/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecBuilder;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import java.util.Map;

public abstract class SelectorVisitor<T>
extends TypedVisitor<T> {
    protected final EnricherManager enricherManager;
    private static ThreadLocal<ProcessorConfig> configHolder = new ThreadLocal();

    public SelectorVisitor(EnricherManager enricherManager) {
        this.enricherManager = enricherManager;
    }

    public static void setProcessorConfig(ProcessorConfig config) {
        configHolder.set(config);
    }

    public static void clearProcessorConfig() {
        configHolder.set(null);
    }

    protected static ProcessorConfig getConfig() {
        ProcessorConfig ret = configHolder.get();
        if (ret == null) {
            throw new IllegalArgumentException("Internal: No ProcessorConfig set");
        }
        return ret;
    }

    public static class ReplicaSet
    extends SelectorVisitor<ReplicaSetSpecBuilder> {
        public ReplicaSet(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(ReplicaSetSpecBuilder item) {
            item.withSelector(this.createLabelSelector(this.enricherManager.extractSelector(ReplicaSet.getConfig(), Kind.REPLICA_SET)));
        }

        private LabelSelector createLabelSelector(Map<String, String> labelSelector) {
            return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(labelSelector)).build();
        }
    }

    public static class ReplicationController
    extends SelectorVisitor<ReplicationControllerSpecBuilder> {
        public ReplicationController(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(ReplicationControllerSpecBuilder item) {
            item.getSelector().putAll(this.enricherManager.extractSelector(ReplicationController.getConfig(), Kind.REPLICATION_CONTROLLER));
        }
    }

    public static class Deployment
    extends SelectorVisitor<DeploymentSpecBuilder> {
        public Deployment(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(DeploymentSpecBuilder item) {
            Map selectorMatchLabels = KubernetesResourceUtil.removeVersionSelector(this.enricherManager.extractSelector(Deployment.getConfig(), Kind.REPLICATION_CONTROLLER));
            LabelSelector selector = item.getSelector();
            if (selector == null) {
                ((DeploymentSpecFluent.SelectorNested)item.withNewSelector().addToMatchLabels(selectorMatchLabels)).endSelector();
            } else {
                selector.getMatchLabels().putAll(selectorMatchLabels);
            }
        }
    }

    public static class Service
    extends SelectorVisitor<ServiceSpecBuilder> {
        public Service(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(ServiceSpecBuilder item) {
            item.getSelector().putAll(this.enricherManager.extractSelector(Service.getConfig(), Kind.SERVICE));
        }
    }
}

