/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.Profile;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.ServiceConfig;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.OpenShiftDependencyResources;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.plugin.converter.DeploymentConfigOpenShiftConverter;
import io.fabric8.maven.plugin.converter.DeploymentOpenShiftConverter;
import io.fabric8.maven.plugin.converter.KubernetesToOpenShiftConverter;
import io.fabric8.maven.plugin.converter.NamespaceOpenShiftConverter;
import io.fabric8.maven.plugin.converter.ReplicSetOpenShiftConverter;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.maven.plugin.mojo.build.AbstractResourceMojo;
import io.fabric8.maven.plugin.mojo.build.ApplyMojo;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;

@Mojo(name="resource", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractResourceMojo {
    private static final String DOCKER_MAVEN_PLUGIN_KEY = "io.fabric8:docker-maven-plugin";
    public static final long DEFAULT_OPENSHIFT_DEPLOY_TIMEOUT_SECONDS = 10800L;
    private static final String DOCKER_IMAGE_USER = "docker.image.user";
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="fabric8.workDir", defaultValue="${project.build.directory}/fabric8")
    private File workDir;
    @Parameter
    private ResourceConfig resources;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter(property="fabric8.mode")
    private PlatformMode mode = PlatformMode.DEFAULT;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter(property="fabric8.kubernetesInitContainerPVChmod", defaultValue="true")
    private boolean kubernetesInitContainerChMod;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ProcessorConfig generator;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    private HandlerHub handlerHub;
    private Map<String, KubernetesToOpenShiftConverter> openShiftConverters;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.openshift.deployTimeoutSeconds")
    private Long openshiftDeployTimeoutSeconds;
    private ClusterAccess clusterAccess;
    private PlatformMode platformMode;
    private OpenShiftDependencyResources openshiftDependencyResources;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        this.clusterAccess = new ClusterAccess(this.namespace);
        try {
            this.lateInit();
            this.resolvedImages = this.getResolvedImages(this.images, this.log);
            if (!(this.skip || this.isPomProject() && !this.hasFabric8Dir())) {
                KubernetesList resources = this.generateResources(this.resolvedImages);
                KubernetesList openShiftResources = this.convertToOpenShiftResources(resources);
                this.writeResources(openShiftResources, ResourceClassifier.OPENSHIFT);
                KubernetesList kubernetesResources = this.convertToKubernetesResources(resources, openShiftResources);
                this.writeResources(kubernetesResources, ResourceClassifier.KUBERNETES);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate fabric8 descriptor", (Exception)e);
        }
    }

    private void lateInit() throws MojoExecutionException {
        Properties properties;
        if (this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:watch") || this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:watch")) {
            properties = this.project.getProperties();
            properties.setProperty("fabric8.watch", "true");
        }
        this.platformMode = this.clusterAccess.resolvePlatformMode(this.mode, this.log);
        this.log.info("Running in [[B]]%s[[B]] mode", new Object[]{this.platformMode.getLabel()});
        if (this.isOpenShiftMode()) {
            properties = this.project.getProperties();
            if (!properties.contains(DOCKER_IMAGE_USER)) {
                String namespace = this.clusterAccess.getNamespace();
                this.log.info("Using docker image name of namespace: " + namespace, new Object[0]);
                properties.setProperty(DOCKER_IMAGE_USER, namespace);
            }
            if (!properties.contains("fabric8.internal.effective.platform.mode")) {
                properties.setProperty("fabric8.internal.effective.platform.mode", this.platformMode.toString());
            }
        }
        this.openShiftConverters = new HashMap<String, KubernetesToOpenShiftConverter>();
        this.openShiftConverters.put("ReplicaSet", new ReplicSetOpenShiftConverter());
        this.openShiftConverters.put("Deployment", new DeploymentOpenShiftConverter(this.platformMode, this.getOpenshiftDeployTimeoutSeconds()));
        this.openShiftConverters.put("DeploymentConfig", new DeploymentConfigOpenShiftConverter(this.getOpenshiftDeployTimeoutSeconds()));
        this.openShiftConverters.put("Namespace", new NamespaceOpenShiftConverter());
        this.handlerHub = new HandlerHub(this.project);
    }

    private boolean isOpenShiftMode() {
        return this.platformMode.equals((Object)PlatformMode.openshift);
    }

    private KubernetesList convertToKubernetesResources(KubernetesList resources, KubernetesList openShiftResources) throws MojoExecutionException {
        KubernetesList kubernetesResources = this.removeOpenShiftObjects(resources);
        KubernetesList kubernetesList = this.processOpenshiftTemplateIfProvided(openShiftResources, kubernetesResources);
        if (this.kubernetesInitContainerChMod) {
            return this.addPersistentVolumeInitContainerChmod(kubernetesList);
        }
        return kubernetesList;
    }

    private KubernetesList addPersistentVolumeInitContainerChmod(KubernetesList kubernetesList) {
        List items = kubernetesList.getItems();
        for (HasMetadata entity : items) {
            DeploymentSpec spec;
            Deployment resource;
            if (entity instanceof Deployment) {
                resource = (Deployment)entity;
                spec = resource.getSpec();
                if (spec == null) continue;
                this.addPersistentVolumeInitContainerChmod(entity, spec.getTemplate());
                continue;
            }
            if (entity instanceof ReplicaSet) {
                resource = (ReplicaSet)entity;
                spec = resource.getSpec();
                if (spec == null) continue;
                this.addPersistentVolumeInitContainerChmod(entity, spec.getTemplate());
                continue;
            }
            if (entity instanceof ReplicationController) {
                resource = (ReplicationController)entity;
                spec = resource.getSpec();
                if (spec == null) continue;
                this.addPersistentVolumeInitContainerChmod(entity, spec.getTemplate());
                continue;
            }
            if (!(entity instanceof DeploymentConfig) || (spec = (resource = (DeploymentConfig)entity).getSpec()) == null) continue;
            this.addPersistentVolumeInitContainerChmod(entity, spec.getTemplate());
        }
        return kubernetesList;
    }

    private void addPersistentVolumeInitContainerChmod(HasMetadata entity, PodTemplateSpec template) {
        PodSpec podSpec;
        if (template != null && (podSpec = template.getSpec()) != null) {
            TreeMap<String, String> nameToMount = new TreeMap<String, String>();
            List volumes = podSpec.getVolumes();
            if (volumes != null) {
                for (Object volume : volumes) {
                    PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
                    if (persistentVolumeClaim == null) continue;
                    String name = volume.getName();
                    nameToMount.put(name, "");
                }
            }
            if (!nameToMount.isEmpty()) {
                HashMap<String, String> annotations;
                String mountPath;
                String name;
                List containers = podSpec.getContainers();
                if (containers != null) {
                    for (Container container : containers) {
                        List volumeMounts = container.getVolumeMounts();
                        if (volumeMounts == null) continue;
                        for (VolumeMount volumeMount : volumeMounts) {
                            name = volumeMount.getName();
                            mountPath = volumeMount.getMountPath();
                            String current = (String)nameToMount.get(name);
                            if (current == null || current.length() != 0) continue;
                            nameToMount.put(name, mountPath);
                        }
                    }
                }
                StringBuffer mountPaths = new StringBuffer();
                StringBuffer mounts = new StringBuffer();
                int idx = 0;
                for (Map.Entry entry : nameToMount.entrySet()) {
                    name = (String)entry.getKey();
                    mountPath = (String)entry.getValue();
                    mountPaths.append(", \"" + mountPath + "\"");
                    String separator = ++idx >= nameToMount.size() ? "" : ",";
                    mounts.append("                    {\n                        \"name\": \"" + name + "\",\n" + "                        \"mountPath\": \"" + mountPath + "\"\n" + "                    }" + separator + "\n");
                }
                String pvAnnotation = "[\n            {\n                \"name\": \"init\",\n                \"image\": \"busybox\",\n                \"command\": [\"chmod\", \"777\"" + mountPaths + "],\n" + "                \"volumeMounts\": [\n" + mounts + "                ]\n" + "            }\n" + "        ]";
                String initContainerAnnotation = "pod.alpha.kubernetes.io/init-containers";
                this.log.verbose("Adding annotation: " + initContainerAnnotation + " = " + pvAnnotation, new Object[0]);
                ObjectMeta metadata = template.getMetadata();
                if (metadata == null) {
                    metadata = new ObjectMeta();
                    template.setMetadata(metadata);
                }
                if ((annotations = metadata.getAnnotations()) == null) {
                    annotations = new HashMap<String, String>();
                    metadata.setAnnotations(annotations);
                }
                annotations.put(initContainerAnnotation, pvAnnotation);
            }
        }
    }

    private KubernetesList processOpenshiftTemplateIfProvided(KubernetesList openShiftResources, KubernetesList kubernetesResources) throws MojoExecutionException {
        Template template = ResourceMojo.getSingletonTemplate(openShiftResources);
        if (template != null) {
            KubernetesList kubernetesTemplateList = this.createKubernetesTemplate(kubernetesResources, template);
            if (kubernetesTemplateList != null) {
                this.writeResources(kubernetesTemplateList, ResourceClassifier.KUBERNETES_TEMPLATE);
            }
            kubernetesResources = this.replaceTemplateExpressions(kubernetesResources, template);
        }
        return kubernetesResources;
    }

    private KubernetesList createKubernetesTemplate(KubernetesList kubernetesResources, Template template) {
        Template customTemplate = ResourceMojo.createTemplateWithObjects(kubernetesResources, template);
        if (customTemplate != null) {
            return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new HasMetadata[]{customTemplate})).build();
        }
        return null;
    }

    private KubernetesList replaceTemplateExpressions(KubernetesList kubernetesResources, Template template) throws MojoExecutionException {
        Template customTemplate = ResourceMojo.createTemplateWithObjects(kubernetesResources, template);
        if (customTemplate != null) {
            try {
                return Templates.processTemplatesLocally((Template)customTemplate, (boolean)false);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to replace template expressions in kubernetes manifest: " + e, (Exception)e);
            }
        }
        return kubernetesResources;
    }

    private static Template createTemplateWithObjects(KubernetesList kubernetesResources, Template template) {
        List parameters = template.getParameters();
        List items = kubernetesResources.getItems();
        Template tempTemplate = null;
        if (parameters != null && parameters.size() > 0 && items != null && items.size() > 0) {
            tempTemplate = new Template();
            tempTemplate.setMetadata(template.getMetadata());
            tempTemplate.setParameters(parameters);
            tempTemplate.setObjects(items);
        }
        return tempTemplate;
    }

    public Long getOpenshiftDeployTimeoutSeconds() {
        if (this.openshiftDeployTimeoutSeconds == null) {
            this.openshiftDeployTimeoutSeconds = 10800L;
        }
        return this.openshiftDeployTimeoutSeconds;
    }

    public void setOpenshiftDeployTimeoutSeconds(Long openshiftDeployTimeoutSeconds) {
        this.openshiftDeployTimeoutSeconds = openshiftDeployTimeoutSeconds;
    }

    private KubernetesList removeOpenShiftObjects(KubernetesList list) {
        KubernetesListBuilder ret = new KubernetesListBuilder();
        ret.withMetadata(list.getMetadata());
        for (HasMetadata item : list.getItems()) {
            if (!this.isOpenshiftItem(item)) {
                ret.addToItems(new HasMetadata[]{item});
                continue;
            }
            this.log.verbose("kubernetes.yml: Removed OpenShift specific resource '%s' of type %s", new Object[]{KubernetesHelper.getName((HasMetadata)item), KubernetesHelper.getKind((HasMetadata)item)});
        }
        return ret.build();
    }

    private boolean isOpenshiftItem(HasMetadata item) {
        return item.getClass().getPackage().getName().contains("openshift");
    }

    private KubernetesList generateResources(List<ImageConfiguration> images) throws IOException, MojoExecutionException {
        this.openshiftDependencyResources = new OpenShiftDependencyResources(this.log);
        EnricherContext ctx = new EnricherContext(this.project, this.session, this.goalFinder, this.extractEnricherConfig(), this.resolvedImages, this.resources, this.log, this.useProjectClasspath, this.openshiftDependencyResources);
        EnricherManager enricherManager = new EnricherManager(ctx);
        KubernetesListBuilder builder = this.generateAppResources(images, enricherManager);
        this.addProfiledResourcesFromSubirectories(builder, this.resourceDir, enricherManager);
        return builder.build();
    }

    private void addProfiledResourcesFromSubirectories(KubernetesListBuilder builder, File resourceDir, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        File[] profileDirs = resourceDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (profileDirs != null) {
            for (File profileDir : profileDirs) {
                Profile profile = ProfileUtil.findProfile((String)profileDir.getName(), (File)resourceDir);
                if (profile == null) {
                    throw new MojoExecutionException(String.format("Invalid profile '%s' given as directory in %s. Please either define a profile of this name or move this directory away", profileDir.getName(), resourceDir));
                }
                ProcessorConfig enricherConfig = profile.getEnricherConfig();
                File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)profileDir);
                if (resourceFiles.length <= 0) continue;
                KubernetesListBuilder profileBuilder = this.readResourceFragments(resourceFiles);
                enricherManager.createDefaultResources(enricherConfig, profileBuilder);
                enricherManager.enrich(enricherConfig, profileBuilder);
                KubernetesList profileItems = profileBuilder.build();
                for (HasMetadata item : profileItems.getItems()) {
                    builder.addToItems(new HasMetadata[]{item});
                }
            }
        }
    }

    private KubernetesListBuilder generateAppResources(List<ImageConfiguration> images, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        KubernetesListBuilder builder;
        File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)this.resourceDir);
        if (resourceFiles != null && resourceFiles.length > 0) {
            this.log.info("Using resource templates from %s", new Object[]{this.resourceDir});
            builder = this.readResourceFragments(resourceFiles);
        } else {
            builder = new KubernetesListBuilder();
        }
        if (this.resources != null) {
            this.addConfiguredResources(builder, images);
        }
        enricherManager.createDefaultResources(builder);
        enricherManager.enrich(builder);
        return builder;
    }

    private KubernetesListBuilder readResourceFragments(File[] resourceFiles) throws IOException, MojoExecutionException {
        String defaultName = MavenUtil.createDefaultResourceName((MavenProject)this.project, (String[])new String[0]);
        KubernetesListBuilder builder = KubernetesResourceUtil.readResourceFragmentsFrom((String)"v1", (String)"extensions/v1beta1", (String)defaultName, (File[])this.mavenFilterFiles(resourceFiles));
        return builder;
    }

    private ProcessorConfig extractEnricherConfig() throws IOException {
        if (this.enricher != null) {
            return this.enricher;
        }
        return ProfileUtil.extractProcesssorConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.resourceDir);
    }

    private ProcessorConfig extractGeneratorConfig() throws IOException {
        if (this.generator != null) {
            return this.generator;
        }
        return ProfileUtil.extractProcesssorConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.resourceDir);
    }

    private KubernetesList convertToOpenShiftResources(KubernetesList resources) throws MojoExecutionException {
        KubernetesListBuilder builder = new KubernetesListBuilder();
        builder.withMetadata(resources.getMetadata());
        List items = resources.getItems();
        ArrayList<HasMetadata> objects = new ArrayList<HasMetadata>();
        if (items != null) {
            for (HasMetadata item : items) {
                HasMetadata converted;
                String name;
                if (item instanceof Deployment && this.hasDeploymentConfigNamed(items, name = KubernetesHelper.getName((HasMetadata)item)) || (converted = this.convertKubernetesItemToOpenShift(item)) == null) continue;
                objects.add(converted);
            }
        }
        this.openshiftDependencyResources.addMissingResources(objects);
        if (this.openshiftManifest != null && this.openshiftManifest.isFile() && this.openshiftManifest.exists()) {
            Set<HasMetadata> oldEntities;
            String namespace = this.clusterAccess.getNamespace();
            KubernetesClient client = this.clusterAccess.createKubernetesClient();
            Controller controller = new Controller(client);
            try {
                oldEntities = ApplyMojo.loadResources(client, controller, namespace, this.openshiftManifest, this.project, this.log);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to load openshift manifest " + this.openshiftManifest + ". " + e, e);
            }
            for (HasMetadata entity : oldEntities) {
                if (!(entity instanceof ImageStream) && !(entity instanceof ImageStreamTag) || KubernetesResourceUtil.findResourceByName(objects, entity.getClass(), (String)KubernetesHelper.getName((HasMetadata)entity)) != null) continue;
                objects.add(entity);
            }
        }
        this.moveTemplatesToTopLevel(builder, objects);
        return builder.build();
    }

    private void moveTemplatesToTopLevel(KubernetesListBuilder builder, List<HasMetadata> objects) {
        Template template = this.extractAndRemoveTemplates(objects);
        if (template != null) {
            this.openshiftDependencyResources.addMissingParameters(template);
            builder.addToItems(new HasMetadata[]{template});
        } else {
            for (HasMetadata object : objects) {
                builder.addToItems(new HasMetadata[]{object});
            }
        }
    }

    private Template extractAndRemoveTemplates(List<HasMetadata> items) {
        Template extractedTemplate = null;
        for (HasMetadata item : new ArrayList<HasMetadata>(items)) {
            if (!(item instanceof Template) || KubernetesResourceUtil.isAppCatalogResource((HasMetadata)item)) continue;
            Template template = (Template)item;
            extractedTemplate = extractedTemplate == null ? template : Templates.combineTemplates((Template)extractedTemplate, (Template)template);
            items.remove(item);
        }
        if (extractedTemplate != null) {
            extractedTemplate.setObjects(items);
        }
        return extractedTemplate;
    }

    private boolean hasDeploymentConfigNamed(List<HasMetadata> items, String name) {
        for (HasMetadata item : items) {
            String dcName;
            if (!(item instanceof DeploymentConfig) || !Objects.equals(name, dcName = KubernetesHelper.getName((HasMetadata)item))) continue;
            return true;
        }
        return false;
    }

    private HasMetadata convertKubernetesItemToOpenShift(HasMetadata item) {
        if (item instanceof ConfigMap && Objects.equals("true", KubernetesHelper.getOrCreateAnnotations((HasMetadata)item).get("maven.fabric8.io/app-catalog"))) {
            return null;
        }
        HasMetadata dependencyResource = this.openshiftDependencyResources.convertKubernetesItemToOpenShift(item);
        if (dependencyResource != null) {
            return dependencyResource;
        }
        KubernetesToOpenShiftConverter converter = this.openShiftConverters.get(item.getKind());
        return converter != null ? converter.convert(item) : item;
    }

    private List<ImageConfiguration> getResolvedImages(List<ImageConfiguration> images, final Logger log) throws MojoExecutionException {
        final Properties resolveProperties = this.project.getProperties();
        List ret = ConfigHelper.resolveImages((Logger)log, images, (ConfigHelper.Resolver)new ConfigHelper.Resolver(){

            public List<ImageConfiguration> resolve(ImageConfiguration image) {
                return ResourceMojo.this.imageConfigResolver.resolve(image, resolveProperties);
            }
        }, null, (ConfigHelper.Customizer)new ConfigHelper.Customizer(){

            public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
                try {
                    return GeneratorManager.generate(configs, ResourceMojo.this.extractGeneratorConfig(), ResourceMojo.this.project, ResourceMojo.this.session, ResourceMojo.this.goalFinder, "fabric8:resource", log, ResourceMojo.this.mode, ResourceMojo.this.buildStrategy, ResourceMojo.this.useProjectClasspath);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot extract generator: " + e, e);
                }
            }
        });
        Date now = this.getBuildReferenceDate();
        this.storeReferenceDateInPluginContext(now);
        String minimalApiVersion = ConfigHelper.initAndValidate((List)ret, null, (ConfigHelper.NameFormatter)new ImageNameFormatter(this.project, now), (Logger)log);
        return ret;
    }

    private void storeReferenceDateInPluginContext(Date now) {
        Map pluginContext = this.getPluginContext();
        pluginContext.put("CONTEXT_KEY_BUILD_TIMESTAMP", now);
    }

    private Date getBuildReferenceDate() throws MojoExecutionException {
        if (this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:build") || this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:deploy") || this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:run")) {
            return new Date();
        }
        File tsFile = new File(this.project.getBuild().getDirectory(), "docker/build.timestamp");
        if (!tsFile.exists()) {
            return new Date();
        }
        try {
            return EnvUtil.loadTimestamp((File)tsFile);
        }
        catch (MojoExecutionException e) {
            throw new MojoExecutionException("Cannot read timestamp from " + tsFile, (Exception)((Object)e));
        }
    }

    private void addConfiguredResources(KubernetesListBuilder builder, List<ImageConfiguration> images) {
        this.log.verbose("Adding resources from plugin configuration", new Object[0]);
        this.addServices(builder, this.resources.getServices());
        this.addController(builder, images);
    }

    private void addController(KubernetesListBuilder builder, List<ImageConfiguration> images) {
        ReplicationControllerHandler rcHandler = this.handlerHub.getReplicationControllerHandler();
        if (this.resources.getReplicaSetName() != null) {
            builder.addToReplicationControllerItems(new ReplicationController[]{rcHandler.getReplicationController(this.resources, images)});
        }
    }

    private File[] mavenFilterFiles(File[] resourceFiles) throws MojoExecutionException {
        if (!this.workDir.exists() && !this.workDir.mkdirs()) {
            throw new MojoExecutionException("Cannot create working dir " + this.workDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(this.workDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new MojoExecutionException(String.format("Cannot filter %s to %s", resource, targetFile), (Exception)((Object)exp));
            }
        }
        return ret;
    }

    private void addServices(KubernetesListBuilder builder, List<ServiceConfig> serviceConfig) {
        if (serviceConfig != null) {
            ServiceHandler serviceHandler = this.handlerHub.getServiceHandler();
            builder.addToServiceItems(this.toArray(serviceHandler.getServices(serviceConfig)));
        }
    }

    private Service[] toArray(List<Service> services) {
        if (services == null) {
            return new Service[0];
        }
        if (services instanceof ArrayList) {
            return ((ArrayList)services).toArray(new Service[services.size()]);
        }
        Service[] ret = new Service[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            ret[i] = services.get(i);
        }
        return ret;
    }

    private boolean hasFabric8Dir() {
        return this.resourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }
}

