/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.build.AbstractResourceMojo;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.utils.Lists;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="app-catalog", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class AppCatalogMojo
extends AbstractResourceMojo {
    private Set<String> copiedAnnotations = new HashSet<String>(Arrays.asList("fabric8.io/build-url", "fabric8.io/build-url", "fabric8.io/build-id", "fabric8.io/docs-url", "fabric8.io/git-url", "fabric8.io/git-commit", "fabric8.io/git-branch", "fabric8.io/iconUrl"));

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        String name;
        ArrayList<Template> openshiftResources = new ArrayList<Template>();
        ArrayList<ConfigMap> kubernetesResources = new ArrayList<ConfigMap>();
        Map<URL, KubernetesResource> openshiftMap = this.loadYamlResourcesOnClassPath("META-INF/fabric8/openshift.yml");
        this.log.info("Found " + openshiftMap.size() + " openshift resources", new Object[0]);
        for (Map.Entry<URL, KubernetesResource> entry : openshiftMap.entrySet()) {
            URL url = entry.getKey();
            KubernetesResource kubernetesResource = entry.getValue();
            Template template = null;
            if (kubernetesResource instanceof Template) {
                template = (Template)kubernetesResource;
                KubernetesHelper.getOrCreateAnnotations((HasMetadata)template).put("maven.fabric8.io/app-catalog", "true");
                this.log.debug("Found Template " + KubernetesHelper.getName((HasMetadata)template) + " with " + Lists.notNullList((List)template.getParameters()).size() + " parameters", new Object[0]);
            } else {
                HasMetadata hasMetadata;
                ObjectMeta metadata;
                TemplateBuilder builder = new TemplateBuilder();
                boolean bl = false;
                if (kubernetesResource instanceof HasMetadata && (metadata = (hasMetadata = (HasMetadata)kubernetesResource).getMetadata()) != null && Strings.isNotBlank((String)metadata.getName())) {
                    bl = true;
                    KubernetesHelper.getOrCreateAnnotations((HasMetadata)hasMetadata).put("maven.fabric8.io/app-catalog", "true");
                    builder.withMetadata(metadata);
                }
                if (!bl) {
                    HashMap<String, String> labels = new HashMap<String, String>();
                    HashMap<String, String> annotations = new HashMap<String, String>();
                    annotations.put("maven.fabric8.io/app-catalog", "true");
                    String name2 = this.extractNameFromURL(url, labels);
                    if (name2.equals("META-INF")) {
                        this.log.debug("Ignoring local build dependency " + url, new Object[0]);
                        continue;
                    }
                    if (Strings.isNullOrBlank((String)name2)) {
                        this.log.warn("Cannot generate a template name from URL: " + url, new Object[0]);
                        continue;
                    }
                    this.populateLabelsFromResources(kubernetesResource, labels);
                    this.populateAnnotationsFromResources(kubernetesResource, annotations);
                    ((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)builder.withNewMetadata().withName(name2)).withLabels(labels)).withAnnotations(annotations)).endMetadata();
                }
                if (kubernetesResource instanceof KubernetesList) {
                    KubernetesList list = (KubernetesList)kubernetesResource;
                    List items = list.getItems();
                    if (items == null || items.isEmpty()) {
                        this.log.warn("Ignoring resource " + url + " as it contains a List which contains no items!", new Object[0]);
                        continue;
                    }
                    builder.withObjects(items);
                }
                template = builder.build();
            }
            if (template == null) continue;
            openshiftResources.add(template);
        }
        HashMap<String, Template> kubernetesTemplates = new HashMap<String, Template>();
        Map<URL, KubernetesResource> kubernetesTemplateMap = this.loadYamlResourcesOnClassPath("META-INF/fabric8/" + ResourceClassifier.KUBERNETES_TEMPLATE.getValue() + ".yml");
        for (Map.Entry entry : kubernetesTemplateMap.entrySet()) {
            URL url = (URL)entry.getKey();
            KubernetesResource resource = (KubernetesResource)entry.getValue();
            if (!(resource instanceof Template)) continue;
            Template template = (Template)resource;
            name = KubernetesHelper.getName((HasMetadata)template);
            if (Strings.isNullOrBlank((String)name)) {
                this.log.warn("Ignoring Template from " + url + " as it has no name!", new Object[0]);
                continue;
            }
            if (kubernetesTemplates.containsKey(name)) {
                this.log.warn("Found duplicate template named: " + name + " for url: " + url, new Object[0]);
            }
            kubernetesTemplates.put(name, template);
        }
        HashSet<String> kubernetesTemplateFileNames = new HashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Map<URL, KubernetesResource> kubernetesMap = this.loadYamlResourcesOnClassPath("META-INF/fabric8/kubernetes.yml");
        for (Map.Entry<URL, KubernetesResource> entry : kubernetesMap.entrySet()) {
            Template template;
            URL url = entry.getKey();
            KubernetesResource resource = entry.getValue();
            HashMap<String, String> labels = new HashMap<String, String>();
            HashMap<String, String> annotations = new HashMap<String, String>();
            String name3 = this.extractNameFromURL(url, labels);
            if (name3.equals("META-INF")) {
                this.log.debug("Ignoring local build dependency " + url, new Object[0]);
                continue;
            }
            if (Strings.isNullOrBlank((String)name3)) {
                this.log.warn("Cannot generate a template name from URL: " + url, new Object[0]);
                continue;
            }
            if (kubernetesTemplates.containsKey(name3)) {
                this.log.info("Ignoring duplicate template " + name3 + " from url: " + url, new Object[0]);
                continue;
            }
            this.populateLabelsFromResources(resource, labels);
            this.populateAnnotationsFromResources(resource, annotations);
            TemplateBuilder builder = new TemplateBuilder();
            ((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)builder.withNewMetadata().withName(name3)).withLabels(labels)).withAnnotations(annotations)).endMetadata();
            if (resource instanceof KubernetesList) {
                KubernetesList list = (KubernetesList)resource;
                List items = list.getItems();
                if (items == null || items.isEmpty()) {
                    this.log.warn("Ignoring resource " + url + " as it contains a List which contains no items!", new Object[0]);
                    continue;
                }
                builder.withObjects(items);
            } else if (resource instanceof HasMetadata) {
                HasMetadata hasMetadata = (HasMetadata)resource;
                builder.withObjects(new HasMetadata[]{hasMetadata});
            }
            if ((template = builder.build()) == null) continue;
            kubernetesTemplates.put(name3, template);
            hashSet.add(name3 + "-template.yml");
        }
        for (Map.Entry<URL, Object> entry : kubernetesTemplates.entrySet()) {
            name = (String)((Object)entry.getKey());
            Template template = (Template)entry.getValue();
            String templateYaml = null;
            try {
                templateYaml = KubernetesHelper.toYaml((Object)template);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to convert template " + name + " into YAML: " + e, (Exception)e);
            }
            String catalogName = "catalog-" + name;
            LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>(KubernetesHelper.getLabels((HasMetadata)template));
            Map annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)template);
            annotations.put("maven.fabric8.io/app-catalog", "true");
            this.populateLabelsFromResources((KubernetesResource)template, labels);
            this.populateAnnotationsFromResources((KubernetesResource)template, annotations);
            labels.put("kind", "catalog");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(catalogName + ".yml", templateYaml);
            kubernetesTemplateFileNames.add(catalogName + "-configmap.yml");
            ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(catalogName)).withLabels(labels)).withAnnotations(annotations)).endMetadata()).withData(data)).build();
            kubernetesResources.add(configMap);
        }
        if (openshiftResources.isEmpty()) {
            this.log.warn("No OpenShift resources generated", new Object[0]);
        } else {
            this.writeResources(((KubernetesListBuilder)new KubernetesListBuilder().withItems(openshiftResources)).build(), ResourceClassifier.OPENSHIFT);
        }
        if (kubernetesResources.isEmpty()) {
            this.log.warn("No Kubernetes resources generated", new Object[0]);
        } else {
            this.writeResources(((KubernetesListBuilder)new KubernetesListBuilder().withItems(kubernetesResources)).build(), ResourceClassifier.KUBERNETES);
        }
        this.removeGeneratedFilesNotMatchingSuffix("kubernetes", kubernetesTemplateFileNames);
        this.removeGeneratedFilesNotMatchingSuffix("openshift", hashSet);
    }

    protected void removeGeneratedFilesNotMatchingSuffix(String kind, Set<String> validFileNames) {
        this.log.debug("Removing files not in set: " + validFileNames, new Object[0]);
        File kubernetesOutputDir = new File(this.targetDir, kind);
        File[] files = kubernetesOutputDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (validFileNames.contains(file.getName())) continue;
                file.delete();
            }
        }
    }

    private String extractNameFromURL(URL url, Map<String, String> labels) {
        String[] parts;
        String text = url.toString();
        int idx = text.lastIndexOf(33);
        if (idx > 0) {
            text = text.substring(0, idx);
        }
        if ((parts = text.split("/")) != null && parts.length > 2) {
            String version = parts[parts.length - 2];
            String name = parts[parts.length - 3];
            labels.put("project", name);
            labels.put("version", version);
            return name;
        }
        return null;
    }

    private void populateLabelsFromResources(KubernetesResource resource, Map<String, String> labels) {
        if (resource instanceof KubernetesList) {
            KubernetesList list = (KubernetesList)resource;
            List items = list.getItems();
            if (items != null) {
                for (HasMetadata item : items) {
                    this.populateLabelsFromEntity(item, labels);
                }
            }
        } else if (resource instanceof HasMetadata) {
            HasMetadata entity = (HasMetadata)resource;
            this.populateLabelsFromEntity(entity, labels);
        }
    }

    private void populateLabelsFromEntity(HasMetadata item, Map<String, String> labels) {
        Map itemLabels;
        ObjectMeta metadata = item.getMetadata();
        if (metadata != null && (itemLabels = metadata.getLabels()) != null && itemLabels.size() > 0) {
            for (Map.Entry entry : itemLabels.entrySet()) {
                String key = (String)entry.getKey();
                if (labels.containsKey(key)) continue;
                labels.put(key, (String)entry.getValue());
            }
        }
    }

    private void populateAnnotationsFromResources(KubernetesResource resource, Map<String, String> annotations) {
        if (resource instanceof KubernetesList) {
            KubernetesList list = (KubernetesList)resource;
            List items = list.getItems();
            if (items != null) {
                for (HasMetadata item : items) {
                    this.populateAnnotationsForEntity(item, annotations);
                }
            }
        } else if (resource instanceof HasMetadata) {
            HasMetadata entity = (HasMetadata)resource;
            this.populateAnnotationsForEntity(entity, annotations);
        }
    }

    private void populateAnnotationsForEntity(HasMetadata item, Map<String, String> labels) {
        Map itemAnnotations;
        ObjectMeta metadata = item.getMetadata();
        if (metadata != null && (itemAnnotations = metadata.getAnnotations()) != null && itemAnnotations.size() > 0) {
            for (Map.Entry entry : itemAnnotations.entrySet()) {
                String key = (String)entry.getKey();
                if (labels.containsKey(key) || !this.copiedAnnotations.contains(key)) continue;
                labels.put(key, (String)entry.getValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<URL, KubernetesResource> loadYamlResourcesOnClassPath(String resourcePath) throws MojoExecutionException {
        List<URL> resourceList = this.findResourcesOnClassPath(resourcePath);
        HashMap<URL, KubernetesResource> resourceMap = new HashMap<URL, KubernetesResource>();
        Iterator<URL> iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try {
                InputStream is;
                block18: {
                    is = url.openStream();
                    Throwable throwable = null;
                    try {
                        if (is != null) {
                            try {
                                KubernetesResource resource = (KubernetesResource)KubernetesHelper.loadYaml((InputStream)is, KubernetesResource.class);
                                resourceMap.put(url, resource);
                            }
                            catch (IOException e) {
                                this.log.warn("Ignoring resource " + url + " as it could not be parsed: " + e, new Object[]{e});
                                if (is == null) continue;
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    continue;
                                }
                                is.close();
                                continue;
                            }
                        }
                        if (is == null) continue;
                        if (throwable == null) break block18;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (is == null) throw throwable5;
                            if (throwable == null) {
                                is.close();
                                throw throwable5;
                            }
                            try {
                                is.close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                                throw throwable5;
                            }
                        }
                    }
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
            catch (IOException e) {
                this.log.warn("Ignoring resource " + url + " as it could not be opened: " + e, new Object[]{e});
            }
        }
        return resourceMap;
    }

    protected List<URL> findResourcesOnClassPath(String resourcePath) throws MojoExecutionException {
        try {
            URLClassLoader classLoader = ClassUtil.createProjectClassLoader((MavenProject)this.project, (Logger)this.log);
            ArrayList<URL> resourceList = new ArrayList<URL>();
            Enumeration<URL> resources = classLoader.getResources(resourcePath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (url == null) continue;
                resourceList.add(url);
            }
            return resourceList;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to find " + resourcePath + " on the compile classpath: " + e, (Exception)e);
        }
    }
}

