/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.ClientScaleableResource;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.GoalFinder;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.WatchMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.maven.plugin.mojo.build.ApplyMojo;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Files;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="watch", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class WatchMojo
extends io.fabric8.maven.docker.WatchMojo {
    @Parameter
    ProcessorConfig generator;
    @Parameter(property="fabric8.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="fabric8.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/kubernetes.yml")
    private File kubernetesManifest;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter(property="fabric8.mode")
    private PlatformMode mode = PlatformMode.auto;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Component
    protected GoalFinder goalFinder;
    private ClusterAccess clusterAccess;
    private KubernetesClient kubernetes;
    private Controller controller;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        super.execute();
    }

    protected synchronized void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        this.clusterAccess = new ClusterAccess(this.namespace);
        this.kubernetes = this.clusterAccess.createKubernetesClient();
        this.controller = new Controller(this.kubernetes);
        URL masterUrl = this.kubernetes.getMasterUrl();
        KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
        super.executeInternal(hub);
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        if (this.generator == null) {
            List<String> includes = Arrays.asList("spring-boot");
            HashSet<Object> excludes = new HashSet<Object>(Arrays.asList(new Object[0]));
            HashMap config = new HashMap();
            this.generator = new ProcessorConfig(includes, excludes, config);
        }
        try {
            return GeneratorManager.generate(configs, this.generator, this.project, this.session, this.goalFinder, "fabric8:watch", this.log, this.mode, this.buildStrategy, false);
        }
        catch (MojoExecutionException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + (Object)((Object)e), e);
        }
    }

    protected void buildImage(ServiceHub hub, ImageConfiguration imageConfig) throws DockerAccessException, MojoExecutionException {
        String imageName = imageConfig.getName();
        try {
            String imagePrefix = this.getImagePrefix(imageName);
            imageName = imagePrefix + "%t";
            ImageNameFormatter formatter = new ImageNameFormatter(this.project, new Date());
            imageName = formatter.format(imageName);
            imageConfig.setName(imageName);
            this.log.info("build new image: " + imageConfig.getName(), new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Caught: " + e, new Object[]{e});
        }
        super.buildImage(hub, imageConfig);
    }

    private String getImagePrefix(String imageName) throws MojoExecutionException {
        String imagePrefix = null;
        int idx = imageName.lastIndexOf(58);
        if (idx < 0) {
            throw new MojoExecutionException("No ':' in the image name:  " + imageName);
        }
        imagePrefix = imageName.substring(0, idx + 1);
        return imagePrefix;
    }

    protected void restartContainer(ServiceHub hub, WatchMojo.ImageWatcher watcher) throws DockerAccessException, MojoExecutionException, MojoFailureException {
        ImageConfiguration imageConfig = watcher.getImageConfiguration();
        String imageName = imageConfig.getName();
        try {
            File manifest = KubernetesHelper.isOpenShift((KubernetesClient)this.kubernetes) ? this.openshiftManifest : this.kubernetesManifest;
            if (!Files.isFile((File)manifest)) {
                throw new MojoFailureException("No such generated manifest file: " + manifest);
            }
            String namespace = this.clusterAccess.getNamespace();
            Set<HasMetadata> entities = ApplyMojo.loadResources(this.kubernetes, this.controller, namespace, manifest, this.project, this.log);
            String imagePrefix = this.getImagePrefix(imageName);
            for (HasMetadata entity : entities) {
                this.updateImageName(this.kubernetes, namespace, entity, imagePrefix, imageName);
            }
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (Logger)this.log);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void updateImageName(KubernetesClient kubernetes, String namespace, HasMetadata entity, String imagePrefix, String imageName) {
        DeploymentConfig resource;
        DeploymentConfigSpec spec;
        String name = KubernetesHelper.getName((HasMetadata)entity);
        if (entity instanceof Deployment) {
            Deployment resource2 = (Deployment)entity;
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec2 != null && this.updateImageName(entity, spec2.getTemplate(), imagePrefix, imageName)) {
                ((ClientScaleableResource)((ClientNonNamespaceOperation)kubernetes.extensions().deployments().inNamespace(namespace)).withName(name)).replace((Object)resource2);
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource3 = (ReplicaSet)entity;
            ReplicaSetSpec spec3 = resource3.getSpec();
            if (spec3 != null && this.updateImageName(entity, spec3.getTemplate(), imagePrefix, imageName)) {
                ((ClientRollableScallableResource)((ClientNonNamespaceOperation)kubernetes.extensions().replicaSets().inNamespace(namespace)).withName(name)).replace((Object)resource3);
            }
        } else if (entity instanceof ReplicationController) {
            ReplicationController resource4 = (ReplicationController)entity;
            ReplicationControllerSpec spec4 = resource4.getSpec();
            if (spec4 != null && this.updateImageName(entity, spec4.getTemplate(), imagePrefix, imageName)) {
                ((ClientRollableScallableResource)((ClientNonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name)).replace((Object)resource4);
            }
        } else if (entity instanceof DeploymentConfig && (spec = (resource = (DeploymentConfig)entity).getSpec()) != null && this.updateImageName(entity, spec.getTemplate(), imagePrefix, imageName)) {
            OpenShiftClient openshiftClient = new Controller(kubernetes).getOpenShiftClientOrNull();
            if (openshiftClient == null) {
                this.log.warn("Ignoring DeploymentConfig " + name + " as not connected to an OpenShift cluster", new Object[0]);
            }
            ((ClientScaleableResource)((ClientNonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).withName(name)).replace((Object)resource);
        }
    }

    private boolean updateImageName(HasMetadata entity, PodTemplateSpec template, String imagePrefix, String imageName) {
        List containers;
        boolean answer = false;
        PodSpec spec = template.getSpec();
        if (spec != null && (containers = spec.getContainers()) != null) {
            for (Container container : containers) {
                String image = container.getImage();
                if (image == null || !image.startsWith(imagePrefix)) continue;
                container.setImage(imageName);
                this.log.info("Updating " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity) + " to use image: " + imageName, new Object[0]);
                answer = true;
            }
        }
        return answer;
    }

    protected String getLogPrefix() {
        return "F8: ";
    }
}

