/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.infra;

import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.IoUtil;
import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public abstract class AbstractInstallMojo
extends AbstractFabric8Mojo {
    protected static final String GOFABRIC8 = "gofabric8";
    private static final String GOFABRIC8_VERSION_URL = "https://raw.githubusercontent.com/fabric8io/gofabric8/master/version/VERSION";
    private static String GOFABRIC_DOWNLOAD_URL_FORMAT = "https://github.com/fabric8io/gofabric8/releases/download/v%s/gofabric8-%s-%s";
    @Parameter(property="fabric8.cluster.kind")
    protected String clusterKind;
    @Parameter(property="fabric8.mode")
    protected PlatformMode mode;
    @Parameter(property="fabric8.dir", defaultValue="${user.home}/.fabric8/bin")
    private File fabric8BinDir;
    @Component
    private Prompter prompter;

    protected File installGofabric8IfNotAvailable() throws MojoExecutionException {
        File gofabric8 = ProcessUtil.findExecutable((Logger)this.log, (String)GOFABRIC8);
        if (gofabric8 == null) {
            this.validateFabric8Dir();
            String fileName = GOFABRIC8;
            if (Platform.windows.equals((Object)this.getPlatform())) {
                fileName = fileName + ".exe";
            }
            if (!((gofabric8 = new File(this.fabric8BinDir, fileName)).exists() && gofabric8.isFile() && gofabric8.canExecute())) {
                this.downloadGoFabric8(gofabric8);
            }
            if (!ProcessUtil.folderIsOnPath((Logger)this.log, (File)this.fabric8BinDir)) {
                this.updateStartupScriptInstructions();
            }
        } else {
            this.log.info("Found %s", new Object[]{gofabric8});
            this.runGofabric8(gofabric8, "version");
        }
        return gofabric8;
    }

    private void updateStartupScriptInstructions() throws MojoExecutionException {
        String absolutePath = this.fabric8BinDir.getAbsolutePath();
        String indent = "  ";
        this.log.warn("The fabric8 bin folder %s is not on the PATH.", new Object[]{this.fabric8BinDir.getAbsolutePath()});
        this.log.warn("To easily start fabric8 CLI tools like [[B]]gofabric8[[B]] directly, please adapt your environment:", new Object[0]);
        if (this.getPlatform().equals(Platform.windows.name())) {
            this.log.info("Please add the following to PATH environment variable:", new Object[0]);
            this.log.info("%s[[C]]set PATH=%%PATH%%;%s[[C]]", new Object[]{indent, absolutePath});
        } else {
            String setPathCmd = "export PATH=$PATH:" + absolutePath;
            this.log.info("Please add the following to your ~/.bashrc:", new Object[0]);
            this.log.info("%s[[C]]%s[[C]]", new Object[]{indent, setPathCmd});
            File rcFile = this.getStartupScript();
            if (rcFile != null) {
                this.updateStartupScript(rcFile, setPathCmd);
            }
        }
    }

    private void updateStartupScript(File rcFile, String setPathCmd) throws MojoExecutionException {
        try {
            String answer = this.prompter.prompt("Would you like to add the path setting to your ~/" + rcFile.getName() + " now? (Y/n)");
            if (answer != null && answer.startsWith("Y")) {
                this.addToStartupScript(rcFile, setPathCmd);
                this.log.info("Updated %s. Please type the following command to update your current shell:", new Object[]{rcFile});
                this.log.info("     [[C]]source ~/%s[[C]]", new Object[]{rcFile.getName()});
            }
        }
        catch (PrompterException e) {
            this.log.warn("Failed to ask user prompt: " + (Object)((Object)e), new Object[]{e});
        }
    }

    private File getStartupScript() {
        File homeDir = new File(System.getProperty("user.home", "."));
        for (String fileName : new String[]{".bashrc", ".zshrc", ".profile", ".bash_profile"}) {
            File testFile = new File(homeDir, fileName);
            if (!testFile.exists() || !testFile.isFile()) continue;
            return testFile;
        }
        return null;
    }

    private void addToStartupScript(File rcFile, String text) throws MojoExecutionException {
        try (FileWriter writer = new FileWriter(rcFile, true);){
            writer.append("\n");
            writer.append("# Added by fabric8-maven-plugin at " + new Date() + "\n");
            writer.append(text + "\n");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to append to " + rcFile + ": " + e, (Exception)e);
        }
    }

    private void validateFabric8Dir() throws MojoExecutionException {
        if (!this.fabric8BinDir.exists()) {
            if (!this.fabric8BinDir.mkdirs()) {
                throw new MojoExecutionException(String.format("Failed to create directory %s. Do you have permission on this folder?", this.fabric8BinDir));
            }
        } else if (!this.fabric8BinDir.isDirectory()) {
            throw new MojoExecutionException(String.format("%s exists but is not a directory", this.fabric8BinDir));
        }
    }

    protected void downloadGoFabric8(File destFile) throws MojoExecutionException {
        File tempFile = this.downloadToTempFile();
        this.moveFile(tempFile, destFile);
        this.runGofabric8(destFile, "version");
    }

    private File downloadToTempFile() throws MojoExecutionException {
        File destFile = this.createGofabric8DownloadFile();
        URL downloadUrl = this.getGofabric8DownloadUrl();
        IoUtil.download((Logger)this.log, (URL)downloadUrl, (File)destFile);
        return destFile;
    }

    private File createGofabric8DownloadFile() throws MojoExecutionException {
        Object file = null;
        try {
            File downloadDir = Files.createTempDirectory(this.fabric8BinDir.toPath(), "download", new FileAttribute[0]).toFile();
            downloadDir.deleteOnExit();
            File ret = new File(downloadDir, GOFABRIC8);
            ret.deleteOnExit();
            this.log.debug("Downloading gofabric8 to temporary file %s", new Object[]{ret});
            return ret;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create a temporary file for the download");
        }
    }

    private URL getGofabric8DownloadUrl() throws MojoExecutionException {
        String version = this.getGoFabric8Version();
        String platform = this.getPlatform().name();
        String arch = this.getArchitecture().name();
        String releaseUrl = String.format(GOFABRIC_DOWNLOAD_URL_FORMAT, version, platform, arch);
        if (platform.equalsIgnoreCase("windows")) {
            releaseUrl = releaseUrl + ".exe";
        }
        this.log.info("Downloading gofabric8:", new Object[0]);
        this.log.info("   Version:      [[B]]%s[[B]]", new Object[]{version});
        this.log.info("   Platform:     [[B]]%s[[B]]", new Object[]{platform});
        this.log.info("   Architecture: [[B]]%s[[B]]", new Object[]{arch});
        try {
            return new URL(releaseUrl);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to create URL from " + releaseUrl + ": " + e, (Exception)e);
        }
    }

    private void moveFile(File tempFile, File destFile) throws MojoExecutionException {
        if (!tempFile.renameTo(destFile)) {
            try {
                IOHelpers.copy((InputStream)new FileInputStream(tempFile), (OutputStream)new FileOutputStream(destFile));
                this.log.info("Downloaded gofabric8 to %s", new Object[]{destFile});
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy temporary file " + tempFile + " to " + destFile + ": " + e, (Exception)e);
            }
        }
        if (!destFile.setExecutable(true)) {
            throw new MojoExecutionException("Cannot make " + destFile + " executable");
        }
    }

    private String getGoFabric8Version() throws MojoExecutionException {
        try {
            String version = IOHelpers.readFully((URL)new URL(GOFABRIC8_VERSION_URL));
            return version;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load gofabric8 version from https://raw.githubusercontent.com/fabric8io/gofabric8/master/version/VERSION. " + e, (Exception)e);
        }
    }

    private Architecture getArchitecture() {
        String osArch = System.getProperty("os.arch");
        if (osArch != null && osArch.toLowerCase().contains("arm")) {
            return Architecture.arm;
        }
        return Architecture.amd64;
    }

    protected Platform getPlatform() {
        String osName = System.getProperty("os.name");
        if (osName.contains("OS X") || osName.contains("Mac ")) {
            return Platform.darwin;
        }
        if (osName.contains("Windows")) {
            return Platform.windows;
        }
        return Platform.linux;
    }

    protected void runGofabric8(File command, String ... args) throws MojoExecutionException {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        argList.add("--batch");
        String argLine = Strings.join(argList, (String)" ");
        this.log.info("Running %s %s", new Object[]{command, argLine});
        String message = command.getName() + " " + argLine;
        try {
            int result = ProcessUtil.runCommand((Logger)this.createExternalProcessLogger("[[B]]gofabric8[[B]] "), (File)command, argList);
            if (result != 0) {
                throw new MojoExecutionException("Failed to execute " + message + " result was: " + result);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to execute %s : %s", command, e.getMessage()), (Exception)e);
        }
    }

    protected boolean isMinishift() {
        if (Strings.isNotBlank((String)this.clusterKind)) {
            String text = this.clusterKind.toLowerCase().trim();
            return text.equals("minishift") || text.equals("openshift");
        }
        return this.mode != null && this.mode == PlatformMode.openshift;
    }

    private static enum Architecture {
        amd64,
        arm;

    }

    private static enum Platform {
        linux,
        darwin,
        windows;

    }
}

