/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.config.MetaDataConfig;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.util.PluginServiceFactory;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.plugin.enricher.MetadataEnricher;
import io.fabric8.maven.plugin.enricher.MetadataVisitor;
import io.fabric8.maven.plugin.enricher.SelectorVisitor;
import io.fabric8.utils.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnricherManager {
    private List<Enricher> enrichers;
    private final ProcessorConfig enricherConfig;
    private Logger log;
    private final List<? extends MetadataVisitor<?>> metaDataVisitors;
    private final List<? extends SelectorVisitor<?>> selectorVisitors;

    public EnricherManager(EnricherContext enricherContext) {
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)enricherContext);
        this.log = enricherContext.getLog();
        this.enricherConfig = enricherContext.getConfig();
        this.enrichers = pluginFactory.createServiceObjects(new String[]{"META-INF/fabric8-enricher-default", "META-INF/fabric8/enricher-default", "META-INF/fabric8-enricher", "META-INF/fabric8/enricher"});
        Collections.reverse(this.enrichers);
        ResourceConfig resources = enricherContext.getResourceConfig();
        if (resources != null) {
            this.addMetaDataEnricher(this.enrichers, enricherContext, MetadataEnricher.Type.LABEL, resources.getLabels());
            this.addMetaDataEnricher(this.enrichers, enricherContext, MetadataEnricher.Type.ANNOTATION, resources.getAnnotations());
        }
        this.enrichers = this.filterEnrichers(this.enrichers);
        this.logEnrichers(this.enrichers);
        this.metaDataVisitors = Arrays.asList(new MetadataVisitor[]{new MetadataVisitor.Deployment(this), new MetadataVisitor.ReplicaSet(this), new MetadataVisitor.ReplicationController(this), new MetadataVisitor.Service(this), new MetadataVisitor.PodSpec(this)});
        this.selectorVisitors = Arrays.asList(new SelectorVisitor[]{new SelectorVisitor.Deployment(this), new SelectorVisitor.ReplicaSet(this), new SelectorVisitor.ReplicationController(this), new SelectorVisitor.Service(this)});
    }

    private void addMetaDataEnricher(List<Enricher> enrichers, EnricherContext ctx, MetadataEnricher.Type type, MetaDataConfig metaData) {
        if (metaData != null) {
            enrichers.add(new MetadataEnricher(ctx, type, metaData));
        }
    }

    private void logEnrichers(List<Enricher> enrichers) {
        this.log.verbose("Enrichers:", new Object[0]);
        for (Enricher enricher : enrichers) {
            this.log.verbose("- %s", new Object[]{enricher.getName()});
        }
    }

    public void createDefaultResources(KubernetesListBuilder builder) {
        this.addDefaultResources(builder);
    }

    public void enrich(KubernetesListBuilder builder) {
        this.enrichLabels(builder);
        this.addMissingSelectors(builder);
        this.adapt(builder);
    }

    private void enrichLabels(KubernetesListBuilder builder) {
        this.visit(builder, this.metaDataVisitors);
    }

    private void addMissingSelectors(KubernetesListBuilder builder) {
        for (SelectorVisitor<?> visitor : this.selectorVisitors) {
            builder.accept(visitor);
        }
    }

    private void adapt(final KubernetesListBuilder builder) {
        this.loop(new Function<Enricher, Void>(){

            public Void apply(Enricher enricher) {
                enricher.adapt(builder);
                return null;
            }
        });
    }

    private void addDefaultResources(final KubernetesListBuilder builder) {
        this.loop(new Function<Enricher, Void>(){

            public Void apply(Enricher enricher) {
                enricher.addMissingResources(builder);
                return null;
            }
        });
    }

    Map<String, String> extractLabels(Kind kind) {
        return this.extract(Extractor.LABEL_EXTRACTOR, kind);
    }

    Map<String, String> extractAnnotations(Kind kind) {
        return this.extract(Extractor.ANNOTATION_EXTRACTOR, kind);
    }

    Map<String, String> extractSelector(Kind kind) {
        return this.extract(Extractor.SELECTOR_EXTRACTOR, kind);
    }

    private List<Enricher> filterEnrichers(List<Enricher> enrichers) {
        ArrayList<Enricher> ret = new ArrayList<Enricher>();
        for (Enricher enricher : this.enricherConfig.order(enrichers, "enricher")) {
            if (!this.enricherConfig.use(enricher.getName())) continue;
            ret.add(enricher);
        }
        return ret;
    }

    private void loop(Function<Enricher, Void> function) {
        for (Enricher enricher : this.enrichers) {
            function.apply((Object)enricher);
        }
    }

    private Map<String, String> extract(Extractor extractor, Kind kind) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Enricher enricher : this.enrichers) {
            this.putAllIfNotNull(ret, extractor.extract(enricher, kind));
        }
        return ret;
    }

    private void putAllIfNotNull(Map<String, String> ret, Map<String, String> toPut) {
        if (toPut != null) {
            ret.putAll(toPut);
        }
    }

    private void visit(KubernetesListBuilder builder, List<? extends MetadataVisitor<?>> visitors) {
        for (MetadataVisitor<?> visitor : visitors) {
            builder.accept(visitor);
        }
    }

    static enum Extractor {
        LABEL_EXTRACTOR{

            @Override
            public Map<String, String> extract(Enricher enricher, Kind kind) {
                return enricher.getLabels(kind);
            }
        }
        ,
        ANNOTATION_EXTRACTOR{

            @Override
            public Map<String, String> extract(Enricher enricher, Kind kind) {
                return enricher.getAnnotations(kind);
            }
        }
        ,
        SELECTOR_EXTRACTOR{

            @Override
            public Map<String, String> extract(Enricher enricher, Kind kind) {
                return enricher.getSelector(kind);
            }
        };


        abstract Map<String, String> extract(Enricher var1, Kind var2);
    }
}

