/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.SpringBootUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.develop.AbstractTailLogMojo;
import io.fabric8.utils.Closeables;
import io.fabric8.utils.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="watch-spring-boot", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.VALIDATE)
@Execute(goal="deploy")
public class WatchSpringBootMojo
extends AbstractTailLogMojo {
    @Override
    protected void applyEntities(Controller controller, KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        this.tailAppPodsLogs(kubernetes, namespace, entities, false, null, true, null, false);
        boolean serviceFound = false;
        long serviceUrlWaitTimeSeconds = this.serviceUrlWaitTimeSeconds;
        for (HasMetadata entity : entities) {
            if (!(entity instanceof Service)) continue;
            Service service = (Service)entity;
            String name = KubernetesHelper.getName((HasMetadata)service);
            ClientResource serviceResource = (ClientResource)((ClientNonNamespaceOperation)kubernetes.services().inNamespace(namespace)).withName(name);
            String url = null;
            int i = 0;
            while ((long)i < serviceUrlWaitTimeSeconds) {
                Service s;
                if (i > 0) {
                    Thread.sleep(1000L);
                }
                if ((s = (Service)serviceResource.get()) != null && Strings.isNotBlank((String)(url = this.getExternalServiceURL(s))) || !this.isExposeService(service)) break;
                ++i;
            }
            serviceUrlWaitTimeSeconds = 1L;
            if (!Strings.isNotBlank(url) || !url.startsWith("http")) continue;
            serviceFound = true;
            this.runRemoteSpringApplication(url);
        }
        if (!serviceFound) {
            throw new MojoExecutionException("No external service found for this application! So cannot watch a remote container!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runRemoteSpringApplication(String url) throws MojoExecutionException {
        this.log.info("Running RemoteSpringApplication against endpoint: " + url, new Object[0]);
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((MavenProject)this.project);
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret", System.getProperty("spring.devtools.remote.secret"));
        if (Strings.isNullOrBlank((String)remoteSecret)) {
            this.log.warn("There is no `spring.devtools.remote.secret` property defined in your src/main/resources/application.properties. Please add one!", new Object[0]);
            throw new MojoExecutionException("No spring.devtools.remote.secret property defined in application.properties or system properties");
        }
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) throw new MojoExecutionException("ClassLoader must be a URLClassLoader but it is: " + classLoader.getClass().getName());
        URLClassLoader pluginClassLoader = (URLClassLoader)classLoader;
        URLClassLoader projectClassLoader = ClassUtil.createProjectClassLoader((MavenProject)this.project, (Logger)this.log);
        URLClassLoader[] classLoaders = new URLClassLoader[]{projectClassLoader, pluginClassLoader};
        StringBuilder buffer = new StringBuilder("java -cp ");
        int count = 0;
        for (URLClassLoader urlClassLoader : classLoaders) {
            URL[] urLs;
            for (URL u : urLs = urlClassLoader.getURLs()) {
                if (count++ > 0) {
                    buffer.append(File.pathSeparator);
                }
                try {
                    URI uri = u.toURI();
                    File file = new File(uri);
                    buffer.append(file.getCanonicalPath());
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to create classpath: " + e, e);
                }
            }
        }
        buffer.append(" -Dspring.devtools.remote.secret=");
        buffer.append(remoteSecret);
        buffer.append(" org.springframework.boot.devtools.RemoteSpringApplication ");
        buffer.append(url);
        try {
            String command = buffer.toString();
            this.log.debug("Running: " + command, new Object[0]);
            final Process process = Runtime.getRuntime().exec(command);
            Runtime.getRuntime().addShutdownHook(new Thread("mvn fabric8:watch-spring-boot shutdown hook"){

                @Override
                public void run() {
                    WatchSpringBootMojo.this.log.info("Terminating the RemoteSpringApplication", new Object[0]);
                    process.destroy();
                }
            });
            Logger logger = this.createLogger("[[G]][Spring][[G]] ");
            this.processOutput(logger, process.getInputStream(), false);
            this.processOutput(logger, process.getErrorStream(), true);
            int status = process.waitFor();
            if (status == 0) return;
            this.log.warn("Process returned status: " + status, new Object[0]);
            return;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run RemoteSpringApplication: " + e, e);
        }
    }

    protected void processOutput(Logger logger, InputStream inputStream, boolean error) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (error) {
                    logger.error("%s", new Object[]{line});
                    continue;
                }
                logger.info("%s", new Object[]{line});
            }
        }
        catch (Exception e) {
            logger.error("Failed to process " + (error ? "stderr" : "stdout") + ": " + e, new Object[0]);
            throw e;
        }
        finally {
            Closeables.closeQuietly((Reader)reader);
        }
    }
}

