/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.maven.core.config.MetaDataConfig;
import io.fabric8.maven.core.util.MapUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MetadataEnricher
extends BaseEnricher
implements Enricher {
    private final Type type;
    private final MetaDataConfig config;

    public MetadataEnricher(EnricherContext context, Type type, MetaDataConfig config) {
        super(context, type == Type.LABEL ? "f8-label" : "f8-annotation");
        this.type = type;
        this.config = config;
    }

    public Map<String, String> getLabels(Kind kind) {
        if (this.type == Type.LABEL) {
            return this.getConfiguredData(kind);
        }
        return null;
    }

    public Map<String, String> getAnnotations(Kind kind) {
        if (this.type == Type.ANNOTATION) {
            return this.getConfiguredData(kind);
        }
        return null;
    }

    public void adapt(KubernetesListBuilder builder) {
        final Map<String, String> all = this.propertiesToMap(this.config.getAll());
        if (all != null) {
            builder.accept((Visitor)new TypedVisitor<ObjectMetaBuilder>(){

                public void visit(ObjectMetaBuilder element) {
                    Map meta = MetadataEnricher.this.type == Type.LABEL ? element.getLabels() : element.getAnnotations();
                    MapUtil.mergeIfAbsent((Map)meta, (Map)all);
                }
            });
        }
    }

    private Map<String, String> getConfiguredData(Kind kind) {
        if (kind == Kind.SERVICE) {
            return this.propertiesToMap(this.config.getService());
        }
        if (kind == Kind.DEPLOYMENT || kind == Kind.DEPLOYMENT_CONFIG) {
            return this.propertiesToMap(this.config.getDeployment());
        }
        if (kind == Kind.REPLICATION_CONTROLLER || kind == Kind.REPLICA_SET) {
            return this.propertiesToMap(this.config.getReplicaSet());
        }
        if (kind == Kind.POD_SPEC) {
            return this.propertiesToMap(this.config.getPod());
        }
        return null;
    }

    private Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                propertyMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return propertyMap;
    }

    public static enum Type {
        LABEL,
        ANNOTATION;

    }
}

