/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.ClientScaleableResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.build.ApplyMojo;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="debug", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PACKAGE)
public class DebugMojo
extends ApplyMojo {
    @Parameter(property="fabric8.debug.port", defaultValue="5005")
    private String localDebugPort;
    private String remoteDebugPort = "5005";
    private Watch podWatcher;
    private CountDownLatch terminateLatch = new CountDownLatch(1);
    private Pod foundPod;
    private Logger podWaitLog;

    @Override
    protected void applyEntities(Controller controller, KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        LabelSelector firstSelector = null;
        for (HasMetadata entity : entities) {
            DeploymentSpec spec;
            Deployment resource;
            String name = KubernetesHelper.getName((HasMetadata)entity);
            LabelSelector selector = null;
            if (entity instanceof Deployment) {
                resource = (Deployment)entity;
                spec = resource.getSpec();
                if (spec != null) {
                    if (this.enableDebugging(entity, spec.getTemplate())) {
                        ((ClientScaleableResource)((ClientNonNamespaceOperation)kubernetes.extensions().deployments().inNamespace(namespace)).withName(name)).replace((Object)resource);
                    }
                    selector = this.getPodLabelSelector(entity);
                }
            } else if (entity instanceof ReplicaSet) {
                resource = (ReplicaSet)entity;
                spec = resource.getSpec();
                if (spec != null) {
                    if (this.enableDebugging(entity, spec.getTemplate())) {
                        ((ClientRollableScallableResource)((ClientNonNamespaceOperation)kubernetes.extensions().replicaSets().inNamespace(namespace)).withName(name)).replace((Object)resource);
                    }
                    selector = this.getPodLabelSelector(entity);
                }
            } else if (entity instanceof ReplicationController) {
                resource = (ReplicationController)entity;
                spec = resource.getSpec();
                if (spec != null) {
                    if (this.enableDebugging(entity, spec.getTemplate())) {
                        ((ClientRollableScallableResource)((ClientNonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name)).replace((Object)resource);
                    }
                    selector = this.getPodLabelSelector(entity);
                }
            } else if (entity instanceof DeploymentConfig && (spec = (resource = (DeploymentConfig)entity).getSpec()) != null) {
                if (this.enableDebugging(entity, spec.getTemplate())) {
                    OpenShiftClient openshiftClient = new Controller(kubernetes).getOpenShiftClientOrNull();
                    if (openshiftClient == null) {
                        this.log.warn("Ignoring DeploymentConfig %s as not connected to an OpenShift cluster", new Object[]{name});
                        continue;
                    }
                    ((ClientScaleableResource)((ClientNonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).withName(name)).replace((Object)resource);
                }
                selector = this.getPodLabelSelector(entity);
            }
            if (selector != null) {
                firstSelector = selector;
                continue;
            }
            controller.apply((Object)entity, fileName);
        }
        if (firstSelector != null) {
            String podName = this.waitForRunningPodWithEnvVar(kubernetes, namespace, firstSelector, "JAVA_ENABLE_DEBUG", "true");
            this.portForward(controller, podName);
        }
    }

    private String waitForRunningPodWithEnvVar(KubernetesClient kubernetes, String namespace, LabelSelector selector, final String envVarName, final String envVarValue) throws MojoExecutionException {
        FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> pods = this.withSelector((ClientNonNamespaceOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>>)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(namespace)), selector);
        this.log.info("Waiting for debug pod with selector " + selector + " and $" + envVarName + " = " + envVarValue, new Object[0]);
        this.podWaitLog = this.createExternalProcessLogger("[[Y]][W][[Y]] ");
        PodList list = (PodList)pods.list();
        if (list != null) {
            List items = list.getItems();
            Pod latestPod = KubernetesResourceUtil.getNewestPod((Collection)list.getItems());
            if (latestPod != null && this.podHasEnvVarValue(latestPod, envVarName, envVarValue)) {
                return KubernetesHelper.getName((HasMetadata)latestPod);
            }
        }
        this.podWatcher = (Watch)pods.watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                DebugMojo.this.podWaitLog.info(KubernetesHelper.getName((HasMetadata)pod) + " status: " + DebugMojo.this.getPodStatusDescription(pod) + DebugMojo.this.getPodStatusMessagePostfix(action), new Object[0]);
                if (DebugMojo.this.isAddOrModified(action) && KubernetesHelper.isPodRunning((Pod)pod) && KubernetesHelper.isPodReady((Pod)pod) && DebugMojo.this.podHasEnvVarValue(pod, envVarName, envVarValue)) {
                    DebugMojo.this.foundPod = pod;
                    DebugMojo.this.terminateLatch.countDown();
                }
            }

            public void onClose(KubernetesClientException e) {
            }
        });
        while (this.terminateLatch.getCount() > 0L) {
            try {
                this.terminateLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.foundPod == null) continue;
            return KubernetesHelper.getName((HasMetadata)this.foundPod);
        }
        throw new MojoExecutionException("Could not find a running pod with $" + envVarName + " = " + envVarValue);
    }

    private boolean isAddOrModified(Watcher.Action action) {
        return action.equals((Object)Watcher.Action.ADDED) || action.equals((Object)Watcher.Action.MODIFIED);
    }

    private boolean podHasEnvVarValue(Pod pod, String envVarName, String envVarValue) {
        Container container;
        List env;
        List containers;
        PodSpec spec = pod.getSpec();
        if (spec != null && (containers = spec.getContainers()) != null && !containers.isEmpty() && (env = (container = (Container)containers.get(0)).getEnv()) != null) {
            for (EnvVar envVar : env) {
                if (!Objects.equal((Object)envVar.getName(), (Object)envVarName) || !Objects.equal((Object)envVar.getValue(), (Object)envVarValue)) continue;
                return true;
            }
        }
        return false;
    }

    private void portForward(Controller controller, String podName) throws MojoExecutionException {
        File command = this.getKubeCtlExecutable(controller);
        this.log.info("Port forwarding to port " + this.remoteDebugPort + " on pod " + podName + " using command " + command, new Object[0]);
        ArrayList<String> args = new ArrayList<String>();
        args.add("port-forward");
        args.add(podName);
        args.add(this.localDebugPort + ":" + this.remoteDebugPort);
        String commandLine = command + " " + Strings.join(args, (String)" ");
        this.log.verbose("Executing command " + commandLine, new Object[0]);
        try {
            this.log.info("", new Object[0]);
            this.log.info("Now you can start a Remote debug execution in your IDE by using localhost and the debug port " + this.localDebugPort, new Object[0]);
            this.log.info("", new Object[0]);
            ProcessUtil.runCommand((Logger)this.createExternalProcessLogger("[[B]]" + command.getName() + "[[B]] "), (File)command, args, (boolean)true);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to start port forwarding with " + commandLine + ": " + e, e);
        }
    }

    private boolean enableDebugging(HasMetadata entity, PodTemplateSpec template) {
        List containers;
        PodSpec podSpec;
        if (template != null && (podSpec = template.getSpec()) != null && (containers = podSpec.getContainers()).size() > 0) {
            ArrayList ports;
            Container container = (Container)containers.get(0);
            ArrayList env = container.getEnv();
            if (env == null) {
                env = new ArrayList();
            }
            this.remoteDebugPort = KubernetesResourceUtil.getEnvVar(env, (String)"JAVA_DEBUG_PORT", (String)"5005");
            boolean enabled = false;
            if (KubernetesResourceUtil.setEnvVar(env, (String)"JAVA_ENABLE_DEBUG", (String)"true")) {
                container.setEnv(env);
                enabled = true;
            }
            if ((ports = container.getPorts()) == null) {
                ports = new ArrayList();
            }
            if (KubernetesResourceUtil.addPort(ports, (String)this.remoteDebugPort, (String)"debug", (Logger)this.log)) {
                container.setPorts(ports);
                enabled = true;
            }
            if (enabled) {
                this.log.info("Enabling debug on " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
                return true;
            }
        }
        return false;
    }
}

