/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.utils.Files;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

@Mojo(name="distro", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class DistroMojo
extends AbstractFabric8Mojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver archiver;
    private String[] types = new String[]{"kubernetes", "openshift"};
    private String[] jarPrefixes = new String[]{"", "WEB-INF/classes/"};

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        File outDir = this.prepareOutputDir();
        Files.recursiveDelete((File)outDir);
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            String type = artifact.getType();
            if (!"compile".equals(artifact.getScope()) || !"jar".equals(type) && !"war".equals(type)) continue;
            File file = artifact.getFile();
            this.processDependencyFile(outDir, file);
        }
        File destinationFile = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + "templates" + ".zip");
        MavenUtil.createArchive((File)outDir, (File)destinationFile, (ZipArchiver)this.archiver);
        this.projectHelper.attachArtifact(this.project, "zip", "templates", destinationFile);
    }

    protected void processDependencyFile(File outDir, File jar) throws MojoExecutionException {
        if (jar.isFile() && jar.exists()) {
            String name = jar.getName();
            int idx = name.lastIndexOf(".");
            if (idx > 0) {
                name = name.substring(0, idx);
            }
            if ((idx = (name = Strings.stripSuffix((String)name, (String)"-SNAPSHOT")).lastIndexOf(45)) > 0) {
                name = name.substring(0, idx);
            }
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(jar);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Could not create JarFile for " + jar + ". " + e), (Throwable)e);
            }
            for (String jarPrefix : this.jarPrefixes) {
                for (String type : this.types) {
                    String resourceName = jarPrefix + "META-INF/fabric8/" + type + ".yml";
                    JarEntry jarEntry = jarFile.getJarEntry(resourceName);
                    if (jarEntry != null) {
                        this.getLog().info((CharSequence)("Found entry " + resourceName + " in " + jar));
                        try (InputStream is = jarFile.getInputStream(jarEntry);){
                            File outFile = new File(outDir, type + "/" + this.getFolderName(jar) + "/" + name + ".yml");
                            outFile.getParentFile().mkdirs();
                            IOHelpers.copy((InputStream)is, (OutputStream)new FileOutputStream(outFile));
                            continue;
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Failed to process " + jar + ". " + e, (Exception)e);
                        }
                    }
                    this.getLog().debug((CharSequence)("No entry " + resourceName + " in " + jar));
                }
            }
        }
    }

    private String getFolderName(File jar) {
        String packageName;
        File packageFolder;
        File artifactFolder;
        String answer = "microservices";
        File versionDir = jar.getParentFile();
        if (versionDir != null && (artifactFolder = versionDir.getParentFile()) != null && (packageFolder = artifactFolder.getParentFile()) != null && Strings.isNotBlank((String)(packageName = packageFolder.getName())) && Objects.equals("packages", packageName)) {
            return "main";
        }
        return answer;
    }

    private File prepareOutputDir() {
        File dirF;
        String dir = this.getProperty("fabric8.helm.outputDir");
        if (dir == null) {
            dir = this.project.getBuild().getDirectory() + "/fabric8/distro/";
        }
        if (Files.isDirectory((File)(dirF = new File(dir)))) {
            Files.recursiveDelete((File)dirF);
        }
        dirF.mkdir();
        return dirF;
    }

    protected URLClassLoader getCompileClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            return this.createClassLoader(classpathElements, this.project.getBuild().getOutputDirectory());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
    }

    protected URLClassLoader getTestClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getTestClasspathElements();
            return this.createClassLoader(classpathElements, this.project.getBuild().getTestOutputDirectory());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
    }

    protected URLClassLoader createClassLoader(List<String> classpathElements, String ... paths) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            URL url = this.pathToUrl(path);
            urls.add(url);
        }
        for (Object e : classpathElements) {
            if (e == null) continue;
            String path = e.toString();
            URL url = this.pathToUrl(path);
            urls.add(url);
        }
        this.getLog().debug((CharSequence)("Creating class loader from: " + urls));
        return DistroMojo.createURLClassLoader(urls);
    }

    protected static URLClassLoader createURLClassLoader(Collection<URL> jars) {
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }

    private URL pathToUrl(String path) throws MalformedURLException {
        File file = new File(path);
        return file.toURI().toURL();
    }
}

