/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.internal;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Configs;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.project.support.BuildConfigHelper;
import io.fabric8.project.support.GitUtils;
import io.fabric8.project.support.UserDetails;
import io.fabric8.utils.Base64Encoder;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.eclipse.jgit.lib.Repository;

@Mojo(name="import", requiresProject=true)
public class ImportMojo
extends AbstractFabric8Mojo {
    public static final String FABRIC8_GIT_APP_SECRETS_CONFIGMAP = "fabric8-git-app-secrets";
    public static final String PROPERTY_PRIVATE_KEY = "ssh-key";
    public static final String PROPERTY_PUBLIC_KEY = "ssh-key.pub";
    public static final String GOGS_REPO_HOST = "gogs";
    @Parameter(defaultValue="${basedir}")
    private File basedir;
    @Parameter(property="fabric8.project.name")
    private String projectName;
    @Parameter(property="fabric8.origin.branchName", defaultValue="origin")
    private String originBranchName;
    @Parameter(property="fabric8.passsword.retry")
    private boolean retryPassword;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.secret.namespace")
    private String secretNamespace;
    @Parameter(property="fabric8.secret.name")
    private String gogsSecretName;
    @Component
    private Prompter prompter;
    private ClusterAccess clusterAccess;
    private String gitUserName;
    private String gitPassword;
    private String gitEmail;
    private boolean gitSecretUpdated;

    private static String getQualifiedName(HasMetadata hasMetadata, String defaultNamespace) {
        return Strings.defaultIfEmpty((String)KubernetesHelper.getNamespace((HasMetadata)hasMetadata), (String)defaultNamespace) + "/" + KubernetesHelper.getName((HasMetadata)hasMetadata);
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        block14: {
            if (!this.basedir.isDirectory() || !this.basedir.exists()) {
                throw new MojoExecutionException("No directory for base directory: " + this.basedir);
            }
            String gitRemoteURL = null;
            Repository repository = null;
            try {
                repository = GitUtils.findRepository((File)this.basedir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to find local git repository in current directory: " + e, (Exception)e);
            }
            try {
                gitRemoteURL = GitUtils.getRemoteURL((Repository)repository);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to get the current git branch: " + e, e);
            }
            try {
                BuildConfigHelper.CreateGitProjectResults createGitProjectResults;
                this.clusterAccess = new ClusterAccess(this.namespace);
                if (Strings.isNullOrBlank((String)this.projectName)) {
                    this.projectName = this.basedir.getName();
                }
                KubernetesClient kubernetes = this.clusterAccess.createDefaultClient(this.log);
                KubernetesResourceUtil.validateKubernetesMasterUrl((URL)kubernetes.getMasterUrl());
                String namespace = this.clusterAccess.getNamespace();
                OpenShiftClient openShiftClient = this.getOpenShiftClientOrJenkinsShift(kubernetes, namespace);
                if (gitRemoteURL != null) {
                    String branch = repository.getBranch();
                    BuildConfig buildConfig = this.findBuildConfigForGitRepo(openShiftClient, namespace, gitRemoteURL, branch);
                    if (buildConfig != null) {
                        this.logBuildConfigLink(kubernetes, namespace, buildConfig, this.log);
                        throw new MojoExecutionException("Project already imported into build " + KubernetesHelper.getName((HasMetadata)buildConfig) + " for URI: " + gitRemoteURL + " and branch: " + branch);
                    }
                    HashMap<String, String> annotations = new HashMap<String, String>();
                    annotations.put("fabric8.io/git-clone-url", gitRemoteURL);
                    buildConfig = BuildConfigHelper.createBuildConfig((KubernetesClient)kubernetes, (String)namespace, (String)this.projectName, (String)gitRemoteURL, annotations);
                    ((ClientNonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).create((Object[])new BuildConfig[]{buildConfig});
                    this.ensureExternalGitSecretsAreSetupFor(kubernetes, namespace, gitRemoteURL);
                    this.logBuildConfigLink(kubernetes, namespace, buildConfig, this.log);
                    break block14;
                }
                UserDetails userDetails = this.createGogsUserDetails(kubernetes, namespace);
                try {
                    createGitProjectResults = BuildConfigHelper.importNewGitProject((KubernetesClient)kubernetes, (UserDetails)userDetails, (File)this.basedir, (String)namespace, (String)this.projectName, (String)this.originBranchName, (String)"Importing project from mvn fabric8:import", (boolean)false);
                }
                catch (WebApplicationException e) {
                    Response response = e.getResponse();
                    if (response.getStatus() > 400) {
                        String message = this.getEntityMessage(response);
                        this.log.warn("Could not create the git repository: %s %s", new Object[]{e, message});
                        this.log.warn("Are your username and password correct in the Secret %s/%s?", new Object[]{this.secretNamespace, this.gogsSecretName});
                        this.log.warn("To re-enter your password rerun this command with -Dfabric8.passsword.retry=true", new Object[0]);
                        throw new MojoExecutionException("Could not create the git repository. Are your username and password correct in the Secret " + this.secretNamespace + "/" + this.gogsSecretName + "?" + (Object)((Object)e) + message, (Exception)((Object)e));
                    }
                    throw e;
                }
                BuildConfig buildConfig = createGitProjectResults.getBuildConfig();
                ((ClientNonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).create((Object[])new BuildConfig[]{buildConfig});
                this.logBuildConfigLink(kubernetes, namespace, buildConfig, this.log);
            }
            catch (KubernetesClientException e) {
                KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (Logger)this.log);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    protected void ensureExternalGitSecretsAreSetupFor(KubernetesClient kubernetes, String namespace, String gitRemoteURL) throws MojoExecutionException {
        String secretNamespace = this.getSecretNamespace();
        this.ensureNamespaceExists(kubernetes, secretNamespace);
        ConfigMap configMap = this.getSecretGitConfigMap(kubernetes, namespace, secretNamespace);
        String host = GitUtils.getGitHostName((String)gitRemoteURL);
        if (host == null) {
            host = "default";
        }
        String protocol = GitUtils.getGitProtocol((String)gitRemoteURL);
        boolean isSsh = Objects.equal((Object)"ssh", (Object)protocol);
        String currentSecretName = (String)configMap.getData().get(host);
        if (currentSecretName == null) {
            currentSecretName = this.createGitSecretName(namespace, host);
        }
        Secret secret = this.findOrCreateGitSecret(kubernetes, currentSecretName, host);
        if (isSsh) {
            HashMap<String, String> secretData = secret.getData();
            if (secretData == null) {
                secretData = new HashMap<String, String>();
            }
            if (!secretData.containsKey(PROPERTY_PRIVATE_KEY) || !secretData.containsKey(PROPERTY_PUBLIC_KEY)) {
                String answer = null;
                try {
                    answer = this.prompter.prompt("Would you like to import your local SSH public/private key pair from your ~/.ssh folder? (Y/n)");
                }
                catch (PrompterException e) {
                    this.log.warn("Failed to get prompt: %s", new Object[]{e});
                }
                if (answer != null && answer.trim().isEmpty() || answer.trim().toUpperCase().startsWith("Y")) {
                    this.chooseSshKeyPairs(secretData, host);
                    secret.setData(secretData);
                }
            }
        } else {
            this.getGogsSecretField(kubernetes, secret, host, "username");
            this.getGogsSecretField(kubernetes, secret, host, "password");
        }
        this.createOrUpdateSecret(kubernetes, secret);
        this.updateSecretGitConfigMap(kubernetes, secretNamespace, configMap, host, currentSecretName);
    }

    private ConfigMap getSecretGitConfigMap(KubernetesClient kubernetes, String namespace, String secretNamespace) {
        ConfigMap configMap = (ConfigMap)((ClientResource)((ClientNonNamespaceOperation)kubernetes.configMaps().inNamespace(secretNamespace)).withName(FABRIC8_GIT_APP_SECRETS_CONFIGMAP)).get();
        if (configMap == null) {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("provider", "fabric8");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(GOGS_REPO_HOST, this.createGitSecretName(namespace, GOGS_REPO_HOST));
            configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(FABRIC8_GIT_APP_SECRETS_CONFIGMAP)).withLabels(labels)).endMetadata()).withData(data)).build();
            this.log.info("Creating ConfigMap fabric8-git-app-secrets in namespace " + secretNamespace, new Object[0]);
            ((ClientResource)((ClientNonNamespaceOperation)kubernetes.configMaps().inNamespace(secretNamespace)).withName(FABRIC8_GIT_APP_SECRETS_CONFIGMAP)).create((Object[])new ConfigMap[]{configMap});
        }
        if (configMap.getData() == null) {
            configMap.setData(new HashMap());
        }
        return configMap;
    }

    private void updateSecretGitConfigMap(KubernetesClient kubernetes, String secretNamespace, ConfigMap configMap, String host, String currentSecretName) {
        HashMap<String, String> data = configMap.getData();
        if (data == null) {
            data = new HashMap<String, String>();
        }
        if (!Objects.equal((Object)data.put(host, currentSecretName), (Object)currentSecretName)) {
            configMap.setData(data);
            this.log.info("Updating ConfigMap " + ImportMojo.getQualifiedName((HasMetadata)configMap, secretNamespace), new Object[0]);
            ((ClientResource)((ClientNonNamespaceOperation)kubernetes.configMaps().inNamespace(secretNamespace)).withName(FABRIC8_GIT_APP_SECRETS_CONFIGMAP)).replace((Object)configMap);
        }
    }

    private void chooseSshKeyPairs(Map<String, String> secretData, String host) throws MojoExecutionException {
        File[] files;
        String homeDir = System.getProperty("user.home", ".");
        File sshDir = new File(homeDir, ".ssh");
        TreeMap<String, String> keyPairs = new TreeMap<String, String>();
        if (sshDir.isDirectory() && sshDir.exists() && (files = sshDir.listFiles()) != null) {
            for (File file : files) {
                String privateName;
                String publicName = file.getName();
                if (!file.isFile() || !publicName.endsWith(".pub") || !new File(sshDir, privateName = Strings.stripSuffix((String)publicName, (String)".pub")).isFile()) continue;
                keyPairs.put(privateName, publicName);
            }
        }
        if (keyPairs.isEmpty()) {
            this.log.warn("No SSH key pairs could be found in %s to choose from!", new Object[]{sshDir});
            this.log.warn("You may want to clone the git repository over https:// instead to avoid ssh key pairs?", new Object[0]);
        } else if (keyPairs.size() == 0) {
            String privateName = (String)keyPairs.firstKey();
            this.importSshKeys(secretData, sshDir, privateName, (String)keyPairs.get(privateName));
        } else {
            ArrayList privateKeys = new ArrayList(keyPairs.keySet());
            String privateKey = null;
            try {
                privateKey = this.prompter.prompt("Which public / private key pair do you wish to use for SSH authentication with host: " + host, privateKeys);
            }
            catch (PrompterException e) {
                this.log.warn("Failed to get user input: %s", new Object[]{e});
            }
            if (Strings.isNotBlank((String)privateKey)) {
                String publicKey = (String)keyPairs.get(privateKey);
                if (Strings.isNullOrBlank((String)publicKey)) {
                    this.log.warn("Invalid answer: %s when available values are: %s", new Object[]{privateKey, privateKeys});
                } else {
                    this.importSshKeys(secretData, sshDir, privateKey, publicKey);
                }
            }
        }
    }

    protected void importSshKeys(Map<String, String> secretData, File sshDir, String privateKeyFileName, String publicKeyFileName) throws MojoExecutionException {
        String privKey = this.loadKey(sshDir, privateKeyFileName);
        String pubKey = this.loadKey(sshDir, publicKeyFileName);
        secretData.put(PROPERTY_PRIVATE_KEY, privKey);
        secretData.put(PROPERTY_PUBLIC_KEY, pubKey);
        this.gitSecretUpdated = true;
    }

    private String loadKey(File dir, String name) throws MojoExecutionException {
        File file = new File(dir, name);
        if (!file.isFile() || !file.exists()) {
            throw new MojoExecutionException("SSH key file " + file + " is not a file!");
        }
        String key = null;
        try {
            key = IOHelpers.readFully((File)file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load SSH key file " + file + ": " + e, (Exception)e);
        }
        if (Strings.isNullOrBlank((String)key)) {
            throw new MojoExecutionException("Empty SSH key file " + file);
        }
        return Base64Encoder.encode((String)key);
    }

    protected UserDetails createGogsUserDetails(KubernetesClient kubernetes, String namespace) throws MojoExecutionException {
        String gogsURL = this.getGogsURL(kubernetes, namespace);
        this.log.debug("Got gogs URL: " + gogsURL, new Object[0]);
        if (Strings.isNullOrBlank((String)gogsURL)) {
            throw new MojoExecutionException("Could not find the external URL to service gogs in namespace " + namespace + ". Are you sure you are running gogs in this kubernetes namespace?");
        }
        String gogsSecretName = this.getGogsSecretName(namespace);
        Secret gogsSecret = null;
        if (Strings.isNullOrBlank((String)this.gitUserName) || Strings.isNullOrBlank((String)this.gitPassword)) {
            gogsSecret = this.findOrCreateGitSecret(kubernetes, gogsSecretName, GOGS_REPO_HOST);
        }
        if (Strings.isNullOrBlank((String)this.gitUserName)) {
            this.gitUserName = this.getGogsSecretField(kubernetes, gogsSecret, GOGS_REPO_HOST, "username");
        }
        if (Strings.isNullOrBlank((String)this.gitPassword)) {
            this.gitPassword = this.getGogsSecretField(kubernetes, gogsSecret, GOGS_REPO_HOST, "password");
        }
        if (Strings.isNullOrBlank((String)this.gitEmail)) {
            this.gitEmail = this.findEmailFromDotGitConfig();
        }
        this.createOrUpdateSecret(kubernetes, gogsSecret);
        ConfigMap configMap = this.getSecretGitConfigMap(kubernetes, namespace, this.secretNamespace);
        this.updateSecretGitConfigMap(kubernetes, this.secretNamespace, configMap, GOGS_REPO_HOST, gogsSecretName);
        this.log.info("git username: " + this.gitUserName + " password: " + this.hidePassword(this.gitPassword) + " email: " + this.gitEmail, new Object[0]);
        return new UserDetails(gogsURL, gogsURL, this.gitUserName, this.gitPassword, this.gitEmail);
    }

    private void createOrUpdateSecret(KubernetesClient kubernetes, Secret secret) {
        if (this.gitSecretUpdated) {
            String name = KubernetesHelper.getName((HasMetadata)secret);
            if (Strings.isNotBlank((String)secret.getMetadata().getResourceVersion())) {
                this.log.info("Updating Secret " + ImportMojo.getQualifiedName((HasMetadata)secret, this.secretNamespace), new Object[0]);
                ((ClientResource)((ClientNonNamespaceOperation)kubernetes.secrets().inNamespace(this.secretNamespace)).withName(name)).replace((Object)secret);
            } else {
                this.log.info("Creating Secret " + ImportMojo.getQualifiedName((HasMetadata)secret, this.secretNamespace), new Object[0]);
                ((ClientResource)((ClientNonNamespaceOperation)kubernetes.secrets().inNamespace(this.secretNamespace)).withName(name)).create((Object[])new Secret[]{secret});
            }
        }
    }

    private String getGogsSecretField(KubernetesClient kubernetes, Secret gogsSecret, String gitRepoHost, String propertyName) throws MojoExecutionException {
        String value;
        HashMap<String, String> data = gogsSecret.getData();
        if (data == null) {
            data = new HashMap<String, String>();
            gogsSecret.setData(data);
        }
        if (Strings.isNullOrBlank((String)(value = (String)data.get(propertyName))) || this.retryPassword) {
            try {
                value = propertyName.equals("password") ? this.prompter.promptForPassword("Please enter your password/access token for git repo " + gitRepoHost) : this.prompter.prompt("Please enter your username for git repo " + gitRepoHost);
            }
            catch (PrompterException e) {
                throw new MojoExecutionException("Failed to input required data: " + (Object)((Object)e), (Exception)((Object)e));
            }
            data.put(propertyName, Base64Encoder.encode((String)value));
            this.gitSecretUpdated = true;
            return value;
        }
        return Base64Encoder.decode((String)value);
    }

    private String hidePassword(String password) {
        if (Strings.isNullOrBlank((String)password)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int size = password.length();
        for (int i = 0; i < size; ++i) {
            buffer.append("*");
        }
        return buffer.toString();
    }

    private String findEmailFromDotGitConfig() {
        Properties user;
        Map map = null;
        try {
            map = GitUtils.parseGitConfig();
        }
        catch (IOException e) {
            this.log.warn("Failed to parse ~/.gitconfig file. %s", new Object[]{e});
        }
        if (map != null && (user = (Properties)map.get("user")) != null) {
            return user.getProperty("email");
        }
        return null;
    }

    private Secret findOrCreateGitSecret(KubernetesClient kubernetes, String secretName, String repositoryHost) {
        String secretNamespace = this.getSecretNamespace();
        this.ensureNamespaceExists(kubernetes, secretNamespace);
        Secret gogsSecret = (Secret)((ClientResource)((ClientNonNamespaceOperation)kubernetes.secrets().inNamespace(secretNamespace)).withName(secretName)).get();
        if (gogsSecret == null) {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("provider", "fabric8");
            labels.put("repository", repositoryHost);
            labels.put("scm", "git");
            gogsSecret = ((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(secretName)).withLabels(labels)).endMetadata()).withData(new HashMap())).build();
        }
        return gogsSecret;
    }

    private void ensureNamespaceExists(KubernetesClient kubernetes, String name) {
        Namespace namespace = (Namespace)((ClientResource)kubernetes.namespaces().withName(name)).get();
        if (namespace == null) {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("provider", "fabric8");
            labels.put("kind", "secrets");
            namespace = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(name)).withLabels(labels)).endMetadata()).build();
            if (KubernetesHelper.isOpenShift((KubernetesClient)kubernetes)) {
                ProjectRequest projectRequest = ((ProjectRequestBuilder)new ProjectRequestBuilder().withMetadata(namespace.getMetadata())).build();
                OpenShiftClient openShiftClient = this.asOpenShiftClient(kubernetes);
                this.log.info("Creating ProjectRequest " + name + " with labels: " + labels, new Object[0]);
                openShiftClient.projectrequests().create((Object[])new ProjectRequest[]{projectRequest});
            } else {
                this.log.info("Creating Namespace " + name + " with labels: " + labels, new Object[0]);
                ((ClientResource)kubernetes.namespaces().withName(name)).create((Object[])new Namespace[]{namespace});
            }
        }
    }

    private OpenShiftClient asOpenShiftClient(KubernetesClient kubernetes) {
        return (OpenShiftClient)kubernetes.adapt(OpenShiftClient.class);
    }

    protected BuildConfig findBuildConfigForGitRepo(OpenShiftClient openShiftClient, String namespace, String gitRepoUrl, String gitRef) throws MojoExecutionException {
        List items;
        BuildConfigList buildConfigList = (BuildConfigList)((ClientNonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).list();
        if (buildConfigList != null && (items = buildConfigList.getItems()) != null) {
            for (BuildConfig item : items) {
                GitBuildSource git;
                BuildSource source;
                BuildConfigSpec spec = item.getSpec();
                if (spec == null || (source = spec.getSource()) == null || (git = source.getGit()) == null) continue;
                String uri = git.getUri();
                String ref = git.getRef();
                if (!Objects.equal((Object)gitRepoUrl, (Object)uri)) continue;
                if (Strings.isNullOrBlank((String)gitRef) && Strings.isNullOrBlank((String)ref)) {
                    return item;
                }
                if (!Objects.equal((Object)gitRef, (Object)ref)) continue;
                return item;
            }
        }
        return null;
    }

    public String getSecretNamespace() {
        if (Strings.isNullOrBlank((String)this.secretNamespace)) {
            this.secretNamespace = "user-secrets-source-" + Configs.currentUserName();
        }
        return this.secretNamespace;
    }

    public String getGogsSecretName(String currentNamespace) {
        if (Strings.isNullOrBlank((String)this.gogsSecretName)) {
            this.gogsSecretName = this.createGitSecretName(currentNamespace, GOGS_REPO_HOST);
        }
        return this.gogsSecretName;
    }

    private String createGitSecretName(String namespace, String host) {
        return namespace + "-" + host + "-git";
    }

    protected void logBuildConfigLink(KubernetesClient kubernetes, String namespace, BuildConfig buildConfig, Logger log) {
        String url = BuildConfigHelper.getBuildConfigConsoleURL((KubernetesClient)kubernetes, (String)namespace, (BuildConfig)buildConfig);
        if (url != null) {
            log.info("You can view the project dashboard at: " + url, new Object[0]);
            File jenkinsfile = new File(this.basedir, "Jenkinsfile");
            if (!jenkinsfile.exists() || !jenkinsfile.isFile()) {
                log.info("To configure a CD Pipeline go to: " + URLUtils.pathJoin((String[])new String[]{url, "/forge/command/devops-edit"}), new Object[0]);
            }
        }
    }

    private String getGogsURL(KubernetesClient kubernetes, String namespace) throws MojoExecutionException {
        Endpoints endpoints = (Endpoints)((ClientResource)((ClientNonNamespaceOperation)kubernetes.endpoints().inNamespace(namespace)).withName(GOGS_REPO_HOST)).get();
        int runningEndpoints = 0;
        if (endpoints != null) {
            List subsets = endpoints.getSubsets();
            for (EndpointSubset subset : subsets) {
                List addresses = subset.getAddresses();
                if (addresses == null) continue;
                runningEndpoints += addresses.size();
            }
        }
        if (runningEndpoints == 0) {
            this.log.warn("No running endpoints for service %s in namespace %s. Please run the `gogs` or the `cd-pipeline` application in the fabric8 console.", new Object[]{GOGS_REPO_HOST, namespace});
            throw new MojoExecutionException("No service gogs running in namespace " + namespace);
        }
        this.log.info("Running %s endpoints of %s in namespace %s", new Object[]{runningEndpoints, GOGS_REPO_HOST, namespace});
        return KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)GOGS_REPO_HOST, (String)namespace, (String)"http", (boolean)true);
    }

    protected String getEntityMessage(Response response) throws IOException {
        Object entity = response.getEntity();
        String message = "";
        if (entity != null) {
            if (entity instanceof InputStream) {
                InputStream is = (InputStream)entity;
                entity = IOHelpers.readFully((InputStream)is);
            } else if (entity instanceof Reader) {
                Reader r = (Reader)entity;
                entity = IOHelpers.readFully((Reader)r);
            }
            message = " " + entity;
        }
        return message;
    }
}

