/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.maven.core.config.MetaDataConfig;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class MetadataVisitor<T>
extends TypedVisitor<T> {
    private final EnricherManager enricherManager;
    private static ThreadLocal<ProcessorConfig> configHolder = new ThreadLocal();
    private final Map<String, String> labelsFromConfig;
    private final Map<String, String> annotationFromConfig;

    private MetadataVisitor(ResourceConfig resourceConfig, EnricherManager enricherManager) {
        this.enricherManager = enricherManager;
        if (resourceConfig != null) {
            this.labelsFromConfig = this.getMapFromConfiguration(resourceConfig.getLabels(), this.getKind());
            this.annotationFromConfig = this.getMapFromConfiguration(resourceConfig.getAnnotations(), this.getKind());
        } else {
            this.labelsFromConfig = new HashMap<String, String>();
            this.annotationFromConfig = new HashMap<String, String>();
        }
    }

    public static void setProcessorConfig(ProcessorConfig config) {
        configHolder.set(config);
    }

    public static void clearProcessorConfig() {
        configHolder.set(null);
    }

    private ProcessorConfig getProcessorConfig() {
        ProcessorConfig config = configHolder.get();
        if (config == null) {
            throw new IllegalArgumentException("No ProcessorConfig set");
        }
        return config;
    }

    public void visit(T item) {
        ProcessorConfig config = this.getProcessorConfig();
        ObjectMeta metadata = this.getOrCreateMetadata(item);
        this.updateLabels(metadata);
        this.updateAnnotations(metadata);
    }

    private void updateLabels(ObjectMeta metadata) {
        this.overlayMap(metadata.getLabels(), this.labelsFromConfig);
        this.overlayMap(metadata.getLabels(), this.enricherManager.extractLabels(this.getProcessorConfig(), this.getKind()));
    }

    private void updateAnnotations(ObjectMeta metadata) {
        this.overlayMap(metadata.getAnnotations(), this.annotationFromConfig);
        this.overlayMap(metadata.getAnnotations(), this.enricherManager.extractAnnotations(this.getProcessorConfig(), this.getKind()));
    }

    private Map<String, String> getMapFromConfiguration(MetaDataConfig config, Kind kind) {
        if (config == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> ret = kind == Kind.SERVICE ? this.propertiesToMap(config.getService()) : (kind == Kind.DEPLOYMENT || kind == Kind.DEPLOYMENT_CONFIG ? this.propertiesToMap(config.getDeployment()) : (kind == Kind.REPLICATION_CONTROLLER || kind == Kind.REPLICA_SET ? this.propertiesToMap(config.getReplicaSet()) : (kind == Kind.POD_SPEC ? this.propertiesToMap(config.getPod()) : new HashMap<String, String>())));
        if (config.getAll() != null) {
            ret.putAll(this.propertiesToMap(config.getAll()));
        }
        return ret;
    }

    private Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                propertyMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return propertyMap;
    }

    private void overlayMap(Map<String, String> targetMap, Map<String, String> enrichMap) {
        targetMap = this.ensureMap(targetMap);
        enrichMap = this.ensureMap(enrichMap);
        for (Map.Entry<String, String> entry : enrichMap.entrySet()) {
            if (targetMap.containsKey(entry.getKey())) continue;
            targetMap.put(entry.getKey(), entry.getValue());
        }
    }

    protected abstract Kind getKind();

    protected abstract ObjectMeta getOrCreateMetadata(T var1);

    private Map<String, String> ensureMap(Map<String, String> labels) {
        return labels != null ? labels : new HashMap();
    }

    public static class DaemonSetBuilderVisitor
    extends MetadataVisitor<DaemonSetBuilder> {
        public DaemonSetBuilderVisitor(ResourceConfig resourceConfig, EnricherManager enricher) {
            super(resourceConfig, enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.DAEMON_SET;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(DaemonSetBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((DaemonSetBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }

    public static class DeploymentBuilderVisitor
    extends MetadataVisitor<DeploymentBuilder> {
        public DeploymentBuilderVisitor(ResourceConfig resourceConfig, EnricherManager enricher) {
            super(resourceConfig, enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.DEPLOYMENT;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(DeploymentBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((DeploymentBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }

    public static class ReplicationControllerBuilderVisitor
    extends MetadataVisitor<ReplicationControllerBuilder> {
        public ReplicationControllerBuilderVisitor(ResourceConfig resourceConfig, EnricherManager enricher) {
            super(resourceConfig, enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.REPLICATION_CONTROLLER;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ReplicationControllerBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((ReplicationControllerBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }

    public static class ReplicaSet
    extends MetadataVisitor<ReplicaSetBuilder> {
        public ReplicaSet(ResourceConfig resourceConfig, EnricherManager enricher) {
            super(resourceConfig, enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.REPLICA_SET;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ReplicaSetBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((ReplicaSetBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }

    public static class ServiceBuilderVisitor
    extends MetadataVisitor<ServiceBuilder> {
        public ServiceBuilderVisitor(ResourceConfig resourceConfig, EnricherManager enricher) {
            super(resourceConfig, enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.SERVICE;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ServiceBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((ServiceBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }

    public static class PodTemplateSpecBuilderVisitor
    extends MetadataVisitor<PodTemplateSpecBuilder> {
        public PodTemplateSpecBuilderVisitor(ResourceConfig resourceConfig, EnricherManager enricher) {
            super(resourceConfig, enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.POD_SPEC;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(PodTemplateSpecBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((PodTemplateSpecBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }
}

