/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.BuildRecreateMode;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.openshift.ImageStreamService;
import io.fabric8.maven.core.openshift.OpenShiftBuildService;
import io.fabric8.maven.core.util.GoalFinder;
import io.fabric8.maven.core.util.Gofabric8Util;
import io.fabric8.maven.core.util.OpenShiftDependencyResources;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.docker.BuildMojoNoFork;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.DockerConnectionDetector;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildMojo
extends BuildMojoNoFork {
    @Parameter
    private ProcessorConfig generator;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ResourceConfig resources;
    @Parameter(property="fabric8.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.skip.build.pom", defaultValue="true")
    private boolean skipBuildPom;
    @Parameter(property="fabric8.mode")
    private PlatformMode mode = PlatformMode.DEFAULT;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.s2i.buildNameSuffix", defaultValue="-s2i")
    private String s2iBuildNameSuffix;
    @Parameter(property="fabric8.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="fabric8.build.recreate", defaultValue="none")
    private String buildRecreate;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Component
    protected GoalFinder goalFinder;
    private ClusterAccess clusterAccess;
    private PlatformMode platformMode;
    private OpenShiftDependencyResources openshiftDependencyResources;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        this.clusterAccess = new ClusterAccess(this.namespace);
        super.execute();
    }

    protected boolean isDockerAccessRequired() {
        return this.platformMode == PlatformMode.kubernetes;
    }

    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.project != null && this.skipBuildPom && Objects.equals("pom", this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"Disabling docker build for pom packaging");
            return;
        }
        if (this.getResolvedImages().size() == 0) {
            this.log.warn("No image build configuration found or detected", new Object[0]);
        }
        super.executeInternal(hub);
    }

    protected List<DockerConnectionDetector.DockerHostProvider> getDockerHostProviders() {
        return Gofabric8Util.extractDockerHostProvider((Logger)this.log);
    }

    protected void buildAndTag(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, DockerAccessException {
        block4: {
            try {
                if (this.platformMode == PlatformMode.kubernetes) {
                    super.buildAndTag(hub, imageConfig);
                    break block4;
                }
                if (this.platformMode == PlatformMode.openshift) {
                    this.executeOpenShiftBuild(hub, imageConfig);
                    break block4;
                }
                throw new MojoExecutionException("Unknown platform mode " + this.mode + " for image " + imageConfig.getDescription());
            }
            catch (IOException e) {
                throw new MojoExecutionException("I/O Error executing build for image " + imageConfig.getDescription() + ":" + e, (Exception)e);
            }
        }
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        Properties properties;
        this.platformMode = this.clusterAccess.resolvePlatformMode(this.mode, this.log);
        if (this.platformMode == PlatformMode.openshift) {
            this.log.info("Using [[B]]OpenShift[[B]] build with strategy [[B]]%s[[B]]", new Object[]{this.buildStrategy.getLabel()});
        } else {
            this.log.info("Building Docker image in [[B]]Kubernetes[[B]] mode", new Object[0]);
        }
        if (this.platformMode.equals((Object)PlatformMode.openshift) && !(properties = this.project.getProperties()).contains("fabric8.internal.effective.platform.mode")) {
            properties.setProperty("fabric8.internal.effective.platform.mode", this.platformMode.toString());
        }
        try {
            GeneratorContext ctx = new GeneratorContext.Builder().config(this.extractGeneratorConfig()).project(this.project).session(this.session).goalFinder(this.goalFinder).goalName("fabric8:build").logger(this.log).mode(this.platformMode).strategy(this.buildStrategy).useProjectClasspath(this.useProjectClasspath).build();
            return GeneratorManager.generate(configs, ctx, false);
        }
        catch (MojoExecutionException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + (Object)((Object)e), e);
        }
    }

    protected String getLogPrefix() {
        return "F8: ";
    }

    private ProcessorConfig extractGeneratorConfig() {
        try {
            return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.resourceDir, (ProcessorConfig)this.generator);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + e, e);
        }
    }

    private void executeOpenShiftBuild(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, IOException {
        MojoParameters params = this.createMojoParameters();
        ImageName imageName = new ImageName(imageConfig.getName());
        File dockerTar = hub.getArchiveService().createDockerBuildArchive(imageConfig, params);
        OpenShiftClient client = this.getOpenShiftClient();
        KubernetesListBuilder builder = new KubernetesListBuilder();
        String buildName = this.updateOrCreateBuildConfig(client, builder, imageConfig);
        this.checkOrCreateImageStream(client, builder, this.getImageStreamName(imageName));
        this.applyResourceObjects(client, builder);
        OpenShiftBuildService buildService = new OpenShiftBuildService(client, this.log);
        Build build = buildService.startBuild(client, dockerTar, buildName);
        buildService.waitForOpenShiftBuildToComplete(client, build);
        this.saveImageStreamToFile(imageName, client);
    }

    private void saveImageStreamToFile(ImageName imageName, OpenShiftClient client) throws MojoExecutionException {
        File imageStreamFile = ResourceFileType.yaml.addExtension(new File(this.project.getBuild().getDirectory(), imageName.getSimpleName() + "-is"));
        ImageStreamService imageStreamHandler = new ImageStreamService(client, this.log);
        imageStreamHandler.saveImageStreamResource(imageName, imageStreamFile);
    }

    private String getS2IBuildName(ImageName imageName) {
        return imageName.getSimpleName() + this.s2iBuildNameSuffix;
    }

    private String getImageStreamName(ImageName name) {
        return name.getSimpleName();
    }

    private OpenShiftClient getOpenShiftClient() throws MojoExecutionException {
        OpenShiftClient client = this.clusterAccess.createOpenShiftClient();
        if (!KubernetesHelper.isOpenShift((KubernetesClient)client)) {
            throw new MojoExecutionException("Cannot create OpenShift Docker build with a non-OpenShift cluster at " + client.getMasterUrl());
        }
        return client;
    }

    private void applyResourceObjects(OpenShiftClient client, KubernetesListBuilder builder) throws IOException {
        this.enrich(builder);
        if (builder.getItems().size() > 0) {
            KubernetesList k8sList = builder.build();
            client.lists().create((Object[])new KubernetesList[]{k8sList});
        }
    }

    private void enrich(KubernetesListBuilder builder) throws IOException {
        ProcessorConfig enricherConfig = ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.resourceDir, (ProcessorConfig)this.enricher);
        this.openshiftDependencyResources = new OpenShiftDependencyResources(this.log);
        EnricherContext.Builder ctxBuilder = new EnricherContext.Builder().project(this.project).session(this.session).goalFinder(this.goalFinder).config(enricherConfig).images(this.getResolvedImages()).log(this.log).openshiftDependencyResources(this.openshiftDependencyResources).useProjectClasspath(this.useProjectClasspath);
        if (this.resources != null && this.resources.getNamespace() != null) {
            ctxBuilder.namespace(this.resources.getNamespace());
        }
        EnricherManager enricherManager = new EnricherManager(this.resources, ctxBuilder.build());
        enricherManager.enrich(builder);
    }

    private void checkOrCreateImageStream(OpenShiftClient client, KubernetesListBuilder builder, String imageStreamName) {
        boolean hasImageStream;
        boolean bl = hasImageStream = ((ClientResource)client.imageStreams().withName(imageStreamName)).get() != null;
        if (hasImageStream && this.getBuildRecreateMode().isImageStream()) {
            ((ClientResource)client.imageStreams().withName(imageStreamName)).delete();
            hasImageStream = false;
        }
        if (!hasImageStream) {
            this.log.info("Creating ImageStream %s", new Object[]{imageStreamName});
            ((BaseKubernetesListFluent.ImageStreamItemsNested)((ImageStreamFluent.MetadataNested)builder.addNewImageStreamItem().withNewMetadata().withName(imageStreamName)).endMetadata()).endImageStreamItem();
        } else {
            this.log.info("Adding to ImageStream %s", new Object[]{imageStreamName});
        }
    }

    private BuildRecreateMode getBuildRecreateMode() {
        return BuildRecreateMode.fromParameter((String)this.buildRecreate);
    }

    private String updateOrCreateBuildConfig(OpenShiftClient client, KubernetesListBuilder builder, ImageConfiguration imageConfig) {
        ImageName imageName = new ImageName(imageConfig.getName());
        String buildName = this.getS2IBuildName(imageName);
        String imageStreamName = this.getImageStreamName(imageName);
        String outputImageStreamTag = imageStreamName + ":" + (imageName.getTag() != null ? imageName.getTag() : "latest");
        BuildStrategy buildStrategyResource = this.createBuildStrategy(imageConfig, this.buildStrategy);
        BuildOutput buildOutput = ((BuildOutputBuilder)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)new BuildOutputBuilder().withNewTo().withKind("ImageStreamTag")).withName(outputImageStreamTag)).endTo()).build();
        BuildConfig buildConfig = (BuildConfig)((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).get();
        if (buildConfig != null) {
            BuildConfigSpec spec = this.getBuildConfigSpec(buildConfig);
            this.validateSourceType(buildName, spec);
            if (this.getBuildRecreateMode().isBuildConfig()) {
                ((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).delete();
                return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
            }
            return this.updateBuildConfig(client, buildName, buildStrategyResource, buildOutput, spec);
        }
        return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
    }

    private String createBuildConfig(KubernetesListBuilder builder, String buildName, BuildStrategy buildStrategyResource, BuildOutput buildOutput) {
        this.log.info("Creating BuildConfig %s for %s build", new Object[]{buildName, buildStrategyResource.getType()});
        ((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.MetadataNested)builder.addNewBuildConfigItem().withNewMetadata().withName(buildName)).endMetadata()).withNewSpec().withNewSource().withType("Binary")).endSource()).withStrategy(buildStrategyResource)).withOutput(buildOutput)).endSpec()).endBuildConfigItem();
        return buildName;
    }

    private String updateBuildConfig(OpenShiftClient client, String buildName, BuildStrategy buildStrategy, BuildOutput buildOutput, BuildConfigSpec spec) {
        if (!Objects.equals(buildStrategy, spec.getStrategy()) || !Objects.equals(buildOutput, spec.getOutput())) {
            ((DoneableBuildConfig)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((DoneableBuildConfig)((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).edit()).editSpec().withStrategy(buildStrategy)).withOutput(buildOutput)).endSpec()).done();
            this.log.info("Updating BuildConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        } else {
            this.log.info("Using BuildConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        }
        return buildName;
    }

    private BuildConfigSpec getBuildConfigSpec(BuildConfig buildConfig) {
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec == null) {
            spec = new BuildConfigSpec();
            buildConfig.setSpec(spec);
        }
        return spec;
    }

    private void validateSourceType(String buildName, BuildConfigSpec spec) {
        String sourceType;
        BuildSource source = spec.getSource();
        if (source != null && !Objects.equals("Binary", sourceType = source.getType())) {
            this.log.warn("BuildConfig %s is not of type: 'Binary' but is '%s' !", new Object[]{buildName, sourceType});
        }
    }

    private BuildStrategy createBuildStrategy(ImageConfiguration imageConfig, OpenShiftBuildStrategy osBuildStrategy) {
        if (osBuildStrategy == OpenShiftBuildStrategy.docker) {
            return ((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Docker")).build();
        }
        if (osBuildStrategy == OpenShiftBuildStrategy.s2i) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            Map fromExt = buildConfig.getFromExt();
            String fromName = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.name, buildConfig.getFrom());
            String fromNamespace = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.namespace, "");
            String fromKind = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.kind, "DockerImage");
            if ("ImageStreamTag".equals(fromKind) && fromNamespace == null) {
                fromNamespace = "openshift";
            }
            if (fromNamespace.isEmpty()) {
                fromNamespace = null;
            }
            return ((BuildStrategyBuilder)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Source")).withNewSourceStrategy().withNewFrom().withKind(fromKind)).withName(fromName)).withNamespace(fromNamespace)).endFrom()).endSourceStrategy()).build();
        }
        throw new IllegalArgumentException("Unsupported BuildStrategy " + osBuildStrategy);
    }

    private String getMapValueWithDefault(Map<String, String> map, OpenShiftBuildStrategy.SourceStrategy strategy, String defaultValue) {
        return this.getMapValueWithDefault(map, strategy.key(), defaultValue);
    }

    private String getMapValueWithDefault(Map<String, String> map, String field, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        String value = map.get(field);
        return value != null ? value : defaultValue;
    }
}

