/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecFluent;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import java.util.Map;

public abstract class SelectorVisitor<T>
extends TypedVisitor<T> {
    final EnricherManager enricherManager;
    private static ThreadLocal<ProcessorConfig> configHolder = new ThreadLocal();

    SelectorVisitor(EnricherManager enricherManager) {
        this.enricherManager = enricherManager;
    }

    static void setProcessorConfig(ProcessorConfig config) {
        configHolder.set(config);
    }

    static void clearProcessorConfig() {
        configHolder.set(null);
    }

    protected static ProcessorConfig getConfig() {
        ProcessorConfig ret = configHolder.get();
        if (ret == null) {
            throw new IllegalArgumentException("Internal: No ProcessorConfig set");
        }
        return ret;
    }

    static class ReplicaSetSpecBuilderVisitor
    extends SelectorVisitor<ReplicaSetSpecBuilder> {
        ReplicaSetSpecBuilderVisitor(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(ReplicaSetSpecBuilder item) {
            item.withSelector(this.createLabelSelector(this.enricherManager.extractSelector(ReplicaSetSpecBuilderVisitor.getConfig(), Kind.REPLICA_SET)));
        }

        private LabelSelector createLabelSelector(Map<String, String> labelSelector) {
            return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(labelSelector)).build();
        }
    }

    static class ReplicationControllerSpecBuilderVisitor
    extends SelectorVisitor<ReplicationControllerSpecBuilder> {
        ReplicationControllerSpecBuilderVisitor(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(ReplicationControllerSpecBuilder item) {
            item.getSelector().putAll(this.enricherManager.extractSelector(ReplicationControllerSpecBuilderVisitor.getConfig(), Kind.REPLICATION_CONTROLLER));
        }
    }

    static class DaemonSetSpecBuilderVisitor
    extends SelectorVisitor<DaemonSetSpecBuilder> {
        DaemonSetSpecBuilderVisitor(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(DaemonSetSpecBuilder item) {
            Map selectorMatchLabels = KubernetesResourceUtil.removeVersionSelector(this.enricherManager.extractSelector(DaemonSetSpecBuilderVisitor.getConfig(), Kind.DAEMON_SET));
            LabelSelector selector = item.buildSelector();
            if (selector == null) {
                ((DaemonSetSpecFluent.SelectorNested)item.withNewSelector().addToMatchLabels(selectorMatchLabels)).endSelector();
            } else {
                selector.getMatchLabels().putAll(selectorMatchLabels);
            }
        }
    }

    static class StatefulSetSpecBuilderVisitor
    extends SelectorVisitor<StatefulSetSpecBuilder> {
        StatefulSetSpecBuilderVisitor(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(StatefulSetSpecBuilder item) {
            Map selectorMatchLabels = KubernetesResourceUtil.removeVersionSelector(this.enricherManager.extractSelector(StatefulSetSpecBuilderVisitor.getConfig(), Kind.STATEFUL_SET));
            LabelSelector selector = item.buildSelector();
            if (selector == null) {
                ((StatefulSetSpecFluent.SelectorNested)item.withNewSelector().addToMatchLabels(selectorMatchLabels)).endSelector();
            } else {
                selector.getMatchLabels().putAll(selectorMatchLabels);
            }
        }
    }

    static class DeploymentSpecBuilderVisitor
    extends SelectorVisitor<DeploymentSpecBuilder> {
        DeploymentSpecBuilderVisitor(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(DeploymentSpecBuilder item) {
            Map selectorMatchLabels = KubernetesResourceUtil.removeVersionSelector(this.enricherManager.extractSelector(DeploymentSpecBuilderVisitor.getConfig(), Kind.REPLICATION_CONTROLLER));
            LabelSelector selector = item.getSelector();
            if (selector == null) {
                ((DeploymentSpecFluent.SelectorNested)item.withNewSelector().addToMatchLabels(selectorMatchLabels)).endSelector();
            } else {
                selector.getMatchLabels().putAll(selectorMatchLabels);
            }
        }
    }

    static class ServiceSpecBuilderVisitor
    extends SelectorVisitor<ServiceSpecBuilder> {
        ServiceSpecBuilderVisitor(EnricherManager enricherManager) {
            super(enricherManager);
        }

        public void visit(ServiceSpecBuilder item) {
            item.getSelector().putAll(this.enricherManager.extractSelector(ServiceSpecBuilderVisitor.getConfig(), Kind.SERVICE));
        }
    }
}

