/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.RouteTargetReferenceBuilder;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="apply", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class ApplyMojo
extends AbstractFabric8Mojo {
    public static final String DEFAULT_KUBERNETES_MANIFEST = "${basedir}/target/classes/META-INF/fabric8/kubernetes.yml";
    public static final String DEFAULT_OPENSHIFT_MANIFEST = "${basedir}/target/classes/META-INF/fabric8/openshift.yml";
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.domain")
    protected String routeDomain;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.failOnError", defaultValue="true")
    protected boolean failOnError;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.recreate", defaultValue="false")
    protected boolean recreate;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/kubernetes.yml")
    private File kubernetesManifest;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.create", defaultValue="true")
    private boolean createNewResources;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.rolling", defaultValue="false")
    private boolean rollingUpgrades;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.failOnNoKubernetesJson", defaultValue="false")
    private boolean failOnNoKubernetesJson;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.servicesOnly", defaultValue="false")
    private boolean servicesOnly;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.ignoreServices", defaultValue="false")
    private boolean ignoreServices;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.processTemplatesLocally", defaultValue="false")
    private boolean processTemplatesLocally;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.deletePods", defaultValue="true")
    private boolean deletePodsOnReplicationControllerUpdate;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.ignoreRunningOAuthClients", defaultValue="true")
    private boolean ignoreRunningOAuthClients;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.createExternalUrls", defaultValue="false")
    private boolean createExternalUrls;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.jsonLogDir", defaultValue="${basedir}/target/fabric8/applyJson")
    private File jsonLogDir;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.namespace")
    private String namespace;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.serviceUrl.waitSeconds", defaultValue="5")
    protected long serviceUrlWaitTimeSeconds;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.s2i.buildNameSuffix", defaultValue="-s2i")
    protected String s2iBuildNameSuffix;
    private ClusterAccess clusterAccess;

    private Route createRouteForService(String routeDomainPostfix, String namespace, Service service) {
        Route route = null;
        String id = KubernetesHelper.getName((HasMetadata)service);
        if (Strings.isNotBlank((String)id) && this.hasExactlyOneService(service, id)) {
            String json;
            route = new Route();
            String routeId = id;
            KubernetesHelper.setName((HasMetadata)route, (String)namespace, (String)routeId);
            RouteSpec routeSpec = new RouteSpec();
            RouteTargetReference objectRef = ((RouteTargetReferenceBuilder)new RouteTargetReferenceBuilder().withName(id)).build();
            routeSpec.setTo(objectRef);
            if (!Strings.isNullOrBlank((String)routeDomainPostfix)) {
                String host = Strings.stripSuffix((String)Strings.stripSuffix((String)id, (String)"-service"), (String)".");
                routeSpec.setHost(host + "." + Strings.stripPrefix((String)routeDomainPostfix, (String)"."));
            } else {
                routeSpec.setHost("");
            }
            route.setSpec(routeSpec);
            try {
                json = KubernetesHelper.toJson((Object)route);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + route;
            }
            this.log.debug("Created route: " + json, new Object[0]);
        }
        return route;
    }

    private Ingress createIngressForService(String routeDomainPostfix, String namespace, Service service) {
        Ingress ingress = null;
        String serviceName = KubernetesHelper.getName((HasMetadata)service);
        ServiceSpec serviceSpec = service.getSpec();
        if (serviceSpec != null && Strings.isNotBlank((String)serviceName) && this.shouldCreateExternalURLForService(service, serviceName)) {
            String json;
            String ingressId = serviceName;
            String host = "";
            if (Strings.isNotBlank((String)routeDomainPostfix)) {
                host = serviceName + "." + namespace + "." + Strings.stripPrefix((String)routeDomainPostfix, (String)".");
            }
            ArrayList<HTTPIngressPath> paths = new ArrayList<HTTPIngressPath>();
            List ports = serviceSpec.getPorts();
            if (ports != null) {
                for (ServicePort port : ports) {
                    Integer portNumber = port.getPort();
                    if (portNumber == null) continue;
                    HTTPIngressPath path = ((HTTPIngressPathBuilder)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)new HTTPIngressPathBuilder().withNewBackend().withServiceName(serviceName)).withServicePort(KubernetesHelper.createIntOrString((int)portNumber))).endBackend()).build();
                    paths.add(path);
                }
            }
            if (paths.isEmpty()) {
                return ingress;
            }
            ingress = ((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((IngressSpecFluent.RulesNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(ingressId)).withNamespace(namespace)).endMetadata()).withNewSpec().addNewRule().withHost(host)).withNewHttp().withPaths(paths)).endHttp()).endRule()).endSpec()).build();
            try {
                json = KubernetesHelper.toJson((Object)ingress);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + ingress;
            }
            this.log.debug("Created ingress: " + json, new Object[0]);
        }
        return ingress;
    }

    private boolean shouldCreateExternalURLForService(Service service, String id) {
        if ("kubernetes".equals(id) || "kubernetes-ro".equals(id)) {
            return false;
        }
        Set ports = KubernetesHelper.getPorts((Service)service);
        this.log.debug("Service " + id + " has ports: " + ports, new Object[0]);
        if (ports.size() == 1) {
            String type = null;
            ServiceSpec spec = service.getSpec();
            if (spec != null && Objects.equals(type = spec.getType(), "LoadBalancer")) {
                return true;
            }
            this.log.info("Not generating route for service " + id + " type is not LoadBalancer: " + type, new Object[0]);
            return false;
        }
        this.log.info("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports, new Object[0]);
        return false;
    }

    private boolean hasExactlyOneService(Service service, String id) {
        Set ports = KubernetesHelper.getPorts((Service)service);
        if (ports.size() != 1) {
            this.log.info("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports, new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        this.clusterAccess = new ClusterAccess(this.namespace);
        try {
            KubernetesClient kubernetes = this.clusterAccess.createDefaultClient(this.log);
            URL masterUrl = kubernetes.getMasterUrl();
            File manifest = KubernetesHelper.isOpenShift((KubernetesClient)kubernetes) ? this.openshiftManifest : this.kubernetesManifest;
            if (!Files.isFile((File)manifest)) {
                if (this.failOnNoKubernetesJson) {
                    throw new MojoFailureException("No such generated manifest file: " + manifest);
                }
                this.log.warn("No such generated manifest file %s for this project so ignoring", new Object[]{manifest});
                return;
            }
            String clusterKind = "Kubernetes";
            if (KubernetesHelper.isOpenShift((KubernetesClient)kubernetes)) {
                clusterKind = "OpenShift";
            }
            KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
            this.log.info("Using %s at %s in namespace %s with manifest %s ", new Object[]{clusterKind, masterUrl, this.clusterAccess.getNamespace(), manifest});
            Controller controller = this.createController();
            controller.setAllowCreate(this.createNewResources);
            controller.setServicesOnlyMode(this.servicesOnly);
            controller.setIgnoreServiceMode(this.ignoreServices);
            controller.setLogJsonDir(this.jsonLogDir);
            controller.setBasedir(this.getRootProjectFolder());
            controller.setIgnoreRunningOAuthClients(this.ignoreRunningOAuthClients);
            controller.setProcessTemplatesLocally(this.processTemplatesLocally);
            controller.setDeletePodsOnReplicationControllerUpdate(this.deletePodsOnReplicationControllerUpdate);
            controller.setRollingUpgrade(this.rollingUpgrades);
            controller.setRollingUpgradePreserveScale(this.isRollingUpgradePreserveScale());
            boolean openShift = KubernetesHelper.isOpenShift((KubernetesClient)kubernetes);
            if (openShift) {
                this.getLog().info((CharSequence)"OpenShift platform detected");
            } else {
                this.disableOpenShiftFeatures(controller);
            }
            String namespace = this.clusterAccess.getNamespace();
            controller.applyNamespace(namespace);
            controller.setNamespace(namespace);
            Set entities = KubernetesResourceUtil.loadResources((File)manifest);
            if (this.createExternalUrls) {
                if (controller.getOpenShiftClientOrNull() != null) {
                    this.createRoutes(controller, entities);
                } else {
                    this.createIngress(controller, kubernetes, entities);
                }
            }
            this.applyEntities(controller, kubernetes, namespace, manifest.getName(), entities);
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (Logger)this.log);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void applyEntities(Controller controller, KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        for (HasMetadata entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                controller.applyPod(pod, fileName);
                continue;
            }
            if (entity instanceof Service) {
                Service service = (Service)entity;
                controller.applyService(service, fileName);
                continue;
            }
            if (entity instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)entity;
                controller.applyReplicationController(replicationController, fileName);
                continue;
            }
            if (entity == null) continue;
            controller.apply((Object)entity, fileName);
        }
        File file = null;
        try {
            file = this.getKubeCtlExecutable(controller);
        }
        catch (MojoExecutionException e) {
            this.log.warn("%s", new Object[]{e.getMessage()});
        }
        if (file != null) {
            this.log.info("[[B]]HINT:[[B]] Use the command `%s get pods -w` to watch your pods start up", new Object[]{file.getName()});
        }
        Logger serviceLogger = this.createExternalProcessLogger("[[G]][SVC][[G]] ");
        long serviceUrlWaitTimeSeconds = this.serviceUrlWaitTimeSeconds;
        for (HasMetadata entity : entities) {
            if (!(entity instanceof Service)) continue;
            Service service = (Service)entity;
            String name = KubernetesHelper.getName((HasMetadata)service);
            ClientResource serviceResource = (ClientResource)((ClientNonNamespaceOperation)kubernetes.services().inNamespace(namespace)).withName(name);
            String url = null;
            int i = 0;
            while ((long)i < serviceUrlWaitTimeSeconds) {
                Service s;
                if (i > 0) {
                    Thread.sleep(1000L);
                }
                if ((s = (Service)serviceResource.get()) != null && Strings.isNotBlank((String)(url = this.getExternalServiceURL(s))) || !this.isExposeService(service)) break;
                ++i;
            }
            serviceUrlWaitTimeSeconds = 1L;
            if (!Strings.isNotBlank(url) || !url.startsWith("http")) continue;
            serviceLogger.info("" + name + ": " + url, new Object[0]);
        }
    }

    protected String getExternalServiceURL(Service service) {
        return (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)service).get("fabric8.io/exposeUrl");
    }

    protected boolean isExposeService(Service service) {
        String expose = (String)KubernetesHelper.getLabels((HasMetadata)service).get("expose");
        return expose != null && expose.toLowerCase().equals("true");
    }

    public boolean isRollingUpgrades() {
        return this.rollingUpgrades;
    }

    public boolean isRollingUpgradePreserveScale() {
        return false;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected void disableOpenShiftFeatures(Controller controller) {
        this.processTemplatesLocally = true;
        controller.setSupportOAuthClients(false);
        controller.setProcessTemplatesLocally(true);
    }

    protected static Object applyTemplates(Template template, KubernetesClient kubernetes, Controller controller, String namespace, String fileName, MavenProject project, Logger log) throws Exception {
        KubernetesHelper.setNamespace((HasMetadata)template, (String)namespace);
        ApplyMojo.overrideTemplateParameters(template, project, log);
        return controller.applyTemplate(template, fileName);
    }

    protected static void overrideTemplateParameters(Template template, MavenProject project, Logger log) {
        List parameters = template.getParameters();
        if (parameters != null && project != null) {
            Properties properties = ApplyMojo.getProjectAndFabric8Properties(project);
            boolean missingProperty = false;
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                String name = "fabric8.apply." + parameterName;
                String propertyValue = properties.getProperty(name);
                if (propertyValue != null) {
                    log.info("Overriding template parameter " + name + " with value: " + propertyValue, new Object[0]);
                    parameter.setValue(propertyValue);
                    continue;
                }
                missingProperty = true;
                log.info("No property defined for template parameter: " + name, new Object[0]);
            }
            if (missingProperty) {
                log.debug("Current properties " + new TreeSet<Object>(properties.keySet()), new Object[0]);
            }
        }
    }

    protected static Properties getProjectAndFabric8Properties(MavenProject project) {
        Properties properties = project.getProperties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    protected void createRoutes(Controller controller, Collection<HasMetadata> collection) {
        String routeDomainPostfix = this.routeDomain;
        Log log = this.getLog();
        String namespace = this.clusterAccess.getNamespace();
        try {
            OpenShiftClient openshiftClient = controller.getOpenShiftClientOrNull();
            if (openshiftClient == null) {
                return;
            }
            RouteList routes = (RouteList)((ClientNonNamespaceOperation)openshiftClient.routes().inNamespace(namespace)).list();
            if (routes != null) {
                routes.getItems();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Cannot load OpenShift Routes; maybe not connected to an OpenShift platform? " + e), (Throwable)e);
            return;
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        for (HasMetadata object : collection) {
            Service service;
            Route route;
            if (!(object instanceof Service) || (route = this.createRouteForService(routeDomainPostfix, namespace, service = (Service)object)) == null) continue;
            routes.add(route);
        }
        collection.addAll(routes);
    }

    protected void createIngress(Controller controller, KubernetesClient kubernetesClient, Collection<HasMetadata> collection) {
        Object ingresses;
        String routeDomainPostfix = this.routeDomain;
        Log log = this.getLog();
        String namespace = this.clusterAccess.getNamespace();
        List ingressList = null;
        try {
            ingresses = (IngressList)((ClientNonNamespaceOperation)kubernetesClient.extensions().ingresses().inNamespace(namespace)).list();
            if (ingresses != null) {
                ingressList = ingresses.getItems();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Cannot load Ingress instances. Must be an older version of Kubernetes? Error: " + e), (Throwable)e);
            return;
        }
        ingresses = new ArrayList();
        for (HasMetadata object : collection) {
            if (!(object instanceof Service)) continue;
            Service service = (Service)object;
            if (!this.serviceHasIngressRule(ingressList, service)) {
                Ingress ingress = this.createIngressForService(routeDomainPostfix, namespace, service);
                if (ingress != null) {
                    ingresses.add(ingress);
                    log.info((CharSequence)("Created ingress for " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
                    continue;
                }
                log.debug((CharSequence)("No ingress required for " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
                continue;
            }
            log.info((CharSequence)("Already has ingress for service " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
        }
        collection.addAll((Collection<HasMetadata>)ingresses);
    }

    private boolean serviceHasIngressRule(List<Ingress> ingresses, Service service) {
        List rules;
        Ingress ingress;
        IngressSpec spec;
        String serviceName = KubernetesHelper.getName((HasMetadata)service);
        Iterator<Ingress> iterator = ingresses.iterator();
        while (iterator.hasNext() && (spec = (ingress = iterator.next()).getSpec()) != null && (rules = spec.getRules()) != null) {
            List paths;
            IngressRule rule;
            HTTPIngressRuleValue http;
            Iterator iterator2 = rules.iterator();
            while (iterator2.hasNext() && (http = (rule = (IngressRule)iterator2.next()).getHttp()) != null && (paths = http.getPaths()) != null) {
                HTTPIngressPath path;
                IngressBackend backend;
                Iterator iterator3 = paths.iterator();
                while (iterator3.hasNext() && (backend = (path = (HTTPIngressPath)iterator3.next()).getBackend()) != null) {
                    if (!Objects.equals(serviceName, backend.getServiceName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Controller createController() {
        Controller controller = new Controller(this.clusterAccess.createDefaultClient(this.log));
        controller.setThrowExceptionOnError(this.failOnError);
        controller.setRecreateMode(this.recreate);
        this.getLog().debug((CharSequence)("Using recreate mode: " + this.recreate));
        return controller;
    }

    public String getRouteDomain() {
        return this.routeDomain;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isRecreate() {
        return this.recreate;
    }

    protected File getRootProjectFolder() {
        File answer = null;
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            File basedir = project.getBasedir();
            if (basedir == null) continue;
            answer = basedir;
        }
        return answer;
    }

    protected MavenProject getRootProject() {
        MavenProject parent;
        MavenProject project = this.getProject();
        while (project != null && (parent = project.getParent()) != null) {
            project = parent;
        }
        return project;
    }

    protected File getKubeCtlExecutable(Controller controller) throws MojoExecutionException {
        String missingCommandMessage;
        OpenShiftClient openShiftClient = controller.getOpenShiftClientOrNull();
        String command = openShiftClient != null ? "oc" : "kubectl";
        File file = ProcessUtil.findExecutable((Logger)this.log, (String)command);
        if (file == null && command.equals("oc")) {
            file = ProcessUtil.findExecutable((Logger)this.log, (String)command);
            missingCommandMessage = "commands oc or kubectl";
        } else {
            missingCommandMessage = "command " + command;
        }
        if (file == null) {
            throw new MojoExecutionException("Could not find " + missingCommandMessage + ". Please try running `mvn fabric8:install` to install the necessary binaries and ensure they get added to your $PATH");
        }
        return file;
    }
}

