/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.generator;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.PluginServiceFactory;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.generator.api.Generator;
import io.fabric8.maven.generator.api.GeneratorContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class GeneratorManager {
    public static List<ImageConfiguration> generate(List<ImageConfiguration> imageConfigs, GeneratorContext genCtx, boolean prePackagePhase) throws MojoExecutionException {
        List ret = imageConfigs;
        PluginServiceFactory pluginFactory = genCtx.isUseProjectClasspath() ? new PluginServiceFactory((Object)genCtx, new ClassLoader[]{ClassUtil.createProjectClassLoader((MavenProject)genCtx.getProject(), (Logger)genCtx.getLogger())}) : new PluginServiceFactory((Object)genCtx, new ClassLoader[0]);
        List generators = pluginFactory.createServiceObjects(new String[]{"META-INF/fabric8/generator-default", "META-INF/fabric8/fabric8-generator-default", "META-INF/fabric8/generator", "META-INF/fabric8-generator"});
        ProcessorConfig config = genCtx.getConfig();
        Logger log = genCtx.getLogger();
        generators = config.order(generators, "generator");
        ArrayList<Generator> usableGenerators = new ArrayList<Generator>();
        log.verbose("Generators:", new Object[0]);
        for (Generator generator : generators) {
            if (!config.use(generator.getName())) continue;
            log.verbose(" - %s", new Object[]{generator.getName()});
            usableGenerators.add(generator);
        }
        for (Generator generator : usableGenerators) {
            if (!generator.isApplicable(ret)) continue;
            log.info("Running generator %s", new Object[]{generator.getName()});
            ret = generator.customize(ret, prePackagePhase);
        }
        return ret;
    }
}

