/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Scaleable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetDeleteRecreateApplicable;
import io.fabric8.kubernetes.internal.HasMetadataComparator;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.RouteTargetReferenceBuilder;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="apply", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class ApplyMojo
extends AbstractFabric8Mojo {
    public static final String DEFAULT_KUBERNETES_MANIFEST = "${basedir}/target/classes/META-INF/fabric8/kubernetes.yml";
    public static final String DEFAULT_OPENSHIFT_MANIFEST = "${basedir}/target/classes/META-INF/fabric8/openshift.yml";
    @Parameter(property="fabric8.domain")
    protected String routeDomain;
    @Parameter(property="fabric8.deploy.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="fabric8.recreate", defaultValue="false")
    protected boolean recreate;
    @Parameter(property="fabric8.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/kubernetes.yml")
    private File kubernetesManifest;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter(property="fabric8.deploy.create", defaultValue="true")
    private boolean createNewResources;
    @Parameter(property="fabric8.rolling", defaultValue="false")
    private boolean rollingUpgrades;
    @Parameter(property="fabric8.deploy.failOnNoKubernetesJson", defaultValue="false")
    private boolean failOnNoKubernetesJson;
    @Parameter(property="fabric8.deploy.servicesOnly", defaultValue="false")
    private boolean servicesOnly;
    @Parameter(property="fabric8.deploy.ignoreServices", defaultValue="false")
    private boolean ignoreServices;
    @Parameter(property="fabric8.deploy.processTemplatesLocally", defaultValue="false")
    private boolean processTemplatesLocally;
    @Parameter(property="fabric8.deploy.deletePods", defaultValue="true")
    private boolean deletePodsOnReplicationControllerUpdate;
    @Parameter(property="fabric8.deploy.ignoreRunningOAuthClients", defaultValue="true")
    private boolean ignoreRunningOAuthClients;
    @Parameter(property="fabric8.deploy.createExternalUrls", defaultValue="false")
    private boolean createExternalUrls;
    @Parameter(property="fabric8.deploy.jsonLogDir", defaultValue="${basedir}/target/fabric8/applyJson")
    private File jsonLogDir;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.serviceUrl.waitSeconds", defaultValue="5")
    protected long serviceUrlWaitTimeSeconds;
    @Parameter(property="fabric8.s2i.buildNameSuffix", defaultValue="-s2i")
    private String s2iBuildNameSuffix;
    private ClusterAccess clusterAccess;

    public static Route createRouteForService(String routeDomainPostfix, String namespace, Service service, Log log) {
        Route route = null;
        String id = KubernetesHelper.getName((HasMetadata)service);
        if (Strings.isNotBlank((String)id) && ApplyMojo.shouldCreateExternalURLForService(log, service, id)) {
            String json;
            route = new Route();
            String routeId = id;
            KubernetesHelper.setName((HasMetadata)route, (String)namespace, (String)routeId);
            RouteSpec routeSpec = new RouteSpec();
            RouteTargetReference objectRef = ((RouteTargetReferenceBuilder)new RouteTargetReferenceBuilder().withName(id)).build();
            routeSpec.setTo(objectRef);
            if (!Strings.isNullOrBlank((String)routeDomainPostfix)) {
                String host = Strings.stripSuffix((String)Strings.stripSuffix((String)id, (String)"-service"), (String)".");
                routeSpec.setHost(host + "." + Strings.stripPrefix((String)routeDomainPostfix, (String)"."));
            } else {
                routeSpec.setHost("");
            }
            route.setSpec(routeSpec);
            try {
                json = KubernetesHelper.toJson((Object)route);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + route;
            }
            log.debug((CharSequence)("Created route: " + json));
        }
        return route;
    }

    public static Ingress createIngressForService(String routeDomainPostfix, String namespace, Service service, Log log) {
        Ingress ingress = null;
        String serviceName = KubernetesHelper.getName((HasMetadata)service);
        ServiceSpec serviceSpec = service.getSpec();
        if (serviceSpec != null && Strings.isNotBlank((String)serviceName) && ApplyMojo.shouldCreateExternalURLForService(log, service, serviceName)) {
            String json;
            String ingressId = serviceName;
            String host = "";
            if (Strings.isNotBlank((String)routeDomainPostfix)) {
                host = serviceName + "." + namespace + "." + Strings.stripPrefix((String)routeDomainPostfix, (String)".");
            }
            ArrayList<HTTPIngressPath> paths = new ArrayList<HTTPIngressPath>();
            List ports = serviceSpec.getPorts();
            if (ports != null) {
                for (ServicePort port : ports) {
                    Integer portNumber = port.getPort();
                    if (portNumber == null) continue;
                    HTTPIngressPath path = ((HTTPIngressPathBuilder)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)new HTTPIngressPathBuilder().withNewBackend().withServiceName(serviceName)).withServicePort(KubernetesHelper.createIntOrString((int)portNumber))).endBackend()).build();
                    paths.add(path);
                }
            }
            if (paths.isEmpty()) {
                return ingress;
            }
            ingress = ((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((IngressSpecFluent.RulesNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(ingressId)).withNamespace(namespace)).endMetadata()).withNewSpec().addNewRule().withHost(host)).withNewHttp().withPaths(paths)).endHttp()).endRule()).endSpec()).build();
            try {
                json = KubernetesHelper.toJson((Object)ingress);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + ingress;
            }
            log.debug((CharSequence)("Created ingress: " + json));
        }
        return ingress;
    }

    protected static boolean shouldCreateExternalURLForService(Log log, Service service, String id) {
        if ("kubernetes".equals(id) || "kubernetes-ro".equals(id)) {
            return false;
        }
        Set ports = KubernetesHelper.getPorts((Service)service);
        log.debug((CharSequence)("Service " + id + " has ports: " + ports));
        if (ports.size() == 1) {
            String type = null;
            ServiceSpec spec = service.getSpec();
            if (spec != null && Objects.equals(type = spec.getType(), "LoadBalancer")) {
                return true;
            }
            log.info((CharSequence)("Not generating route for service " + id + " type is not LoadBalancer: " + type));
            return false;
        }
        log.info((CharSequence)("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports));
        return false;
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        this.clusterAccess = new ClusterAccess(this.namespace);
        try {
            KubernetesClient kubernetes = this.clusterAccess.createDefaultClient(this.log);
            URL masterUrl = kubernetes.getMasterUrl();
            File manifest = KubernetesHelper.isOpenShift((KubernetesClient)kubernetes) ? this.openshiftManifest : this.kubernetesManifest;
            if (!Files.isFile((File)manifest)) {
                if (this.failOnNoKubernetesJson) {
                    throw new MojoFailureException("No such generated manifest file: " + manifest);
                }
                this.log.warn("No such generated manifest file %s for this project so ignoring", new Object[]{manifest});
                return;
            }
            String clusterKind = "Kubernetes";
            if (KubernetesHelper.isOpenShift((KubernetesClient)kubernetes)) {
                clusterKind = "OpenShift";
            }
            KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
            this.log.info("Using %s at %s in namespace %s with manifest %s ", new Object[]{clusterKind, masterUrl, this.clusterAccess.getNamespace(), manifest});
            Controller controller = this.createController();
            controller.setAllowCreate(this.createNewResources);
            controller.setServicesOnlyMode(this.servicesOnly);
            controller.setIgnoreServiceMode(this.ignoreServices);
            controller.setLogJsonDir(this.jsonLogDir);
            controller.setBasedir(this.getRootProjectFolder());
            controller.setIgnoreRunningOAuthClients(this.ignoreRunningOAuthClients);
            controller.setProcessTemplatesLocally(this.processTemplatesLocally);
            controller.setDeletePodsOnReplicationControllerUpdate(this.deletePodsOnReplicationControllerUpdate);
            controller.setRollingUpgrade(this.rollingUpgrades);
            controller.setRollingUpgradePreserveScale(this.isRollingUpgradePreserveScale());
            boolean openShift = KubernetesHelper.isOpenShift((KubernetesClient)kubernetes);
            if (openShift) {
                this.getLog().info((CharSequence)"OpenShift platform detected");
            } else {
                this.disableOpenShiftFeatures(controller);
            }
            String namespace = this.clusterAccess.getNamespace();
            controller.applyNamespace(namespace);
            controller.setNamespace(namespace);
            Set<HasMetadata> entities = ApplyMojo.loadResources(kubernetes, controller, namespace, manifest, this.getProject(), this.log);
            if (this.createExternalUrls) {
                if (controller.getOpenShiftClientOrNull() != null) {
                    this.createRoutes(controller, entities);
                } else {
                    this.createIngress(controller, kubernetes, entities);
                }
            }
            this.applyEntities(controller, kubernetes, namespace, manifest.getName(), entities);
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (Logger)this.log);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public static Set<HasMetadata> loadResources(KubernetesClient kubernetes, Controller controller, String namespace, File manifest, MavenProject project, Logger log) throws Exception {
        String fileName = manifest.getName();
        Object dto = KubernetesHelper.loadYaml((File)manifest, KubernetesResource.class);
        if (dto == null) {
            throw new MojoFailureException("Cannot load kubernetes YAML: " + manifest);
        }
        if (dto instanceof Template) {
            Template template = (Template)dto;
            boolean failOnMissingParameterValue = false;
            dto = Templates.processTemplatesLocally((Template)template, (boolean)failOnMissingParameterValue);
        }
        LinkedHashSet resources = new LinkedHashSet();
        TreeSet<HasMetadata> entities = new TreeSet<HasMetadata>((Comparator<HasMetadata>)new HasMetadataComparator());
        for (KubernetesResource resource : resources) {
            entities.addAll(KubernetesHelper.toItemList((Object)resource));
        }
        entities.addAll(KubernetesHelper.toItemList((Object)dto));
        return entities;
    }

    protected void applyEntities(Controller controller, KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        for (HasMetadata entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                controller.applyPod(pod, fileName);
                continue;
            }
            if (entity instanceof Service) {
                Service service = (Service)entity;
                controller.applyService(service, fileName);
                continue;
            }
            if (entity instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)entity;
                controller.applyReplicationController(replicationController, fileName);
                continue;
            }
            if (entity == null) continue;
            controller.apply((Object)entity, fileName);
        }
        File file = null;
        try {
            file = this.getKubeCtlExecutable(controller);
        }
        catch (MojoExecutionException e) {
            this.log.warn("%s", new Object[]{e.getMessage()});
        }
        if (file != null) {
            this.log.info("[[B]]HINT:[[B]] Use the command `%s get pods -w` to watch your pods start up", new Object[]{file.getName()});
        }
        Logger serviceLogger = this.createExternalProcessLogger("[[G]][SVC][[G]] ");
        long serviceUrlWaitTimeSeconds = this.serviceUrlWaitTimeSeconds;
        for (HasMetadata entity : entities) {
            if (!(entity instanceof Service)) continue;
            Service service = (Service)entity;
            String name = KubernetesHelper.getName((HasMetadata)service);
            ClientResource serviceResource = (ClientResource)((ClientNonNamespaceOperation)kubernetes.services().inNamespace(namespace)).withName(name);
            String url = null;
            int i = 0;
            while ((long)i < serviceUrlWaitTimeSeconds) {
                Service s;
                if (i > 0) {
                    Thread.sleep(1000L);
                }
                if ((s = (Service)serviceResource.get()) != null && Strings.isNotBlank((String)(url = this.getExternalServiceURL(s))) || !this.isExposeService(service)) break;
                ++i;
            }
            serviceUrlWaitTimeSeconds = 1L;
            if (!Strings.isNotBlank(url) || !url.startsWith("http")) continue;
            serviceLogger.info("" + name + ": " + url, new Object[0]);
        }
    }

    protected String getExternalServiceURL(Service service) {
        return (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)service).get("fabric8.io/exposeUrl");
    }

    protected boolean isExposeService(Service service) {
        String expose = (String)KubernetesHelper.getLabels((HasMetadata)service).get("expose");
        return expose != null && expose.toLowerCase().equals("true");
    }

    public boolean isRollingUpgrades() {
        return this.rollingUpgrades;
    }

    public boolean isRollingUpgradePreserveScale() {
        return false;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected void disableOpenShiftFeatures(Controller controller) {
        this.processTemplatesLocally = true;
        controller.setSupportOAuthClients(false);
        controller.setProcessTemplatesLocally(true);
    }

    protected static Object applyTemplates(Template template, KubernetesClient kubernetes, Controller controller, String namespace, String fileName, MavenProject project, Logger log) throws Exception {
        KubernetesHelper.setNamespace((HasMetadata)template, (String)namespace);
        ApplyMojo.overrideTemplateParameters(template, project, log);
        return controller.applyTemplate(template, fileName);
    }

    protected static void overrideTemplateParameters(Template template, MavenProject project, Logger log) {
        List parameters = template.getParameters();
        if (parameters != null && project != null) {
            Properties properties = ApplyMojo.getProjectAndFabric8Properties(project);
            boolean missingProperty = false;
            for (io.fabric8.openshift.api.model.Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                String name = "fabric8.apply." + parameterName;
                String propertyValue = properties.getProperty(name);
                if (propertyValue != null) {
                    log.info("Overriding template parameter " + name + " with value: " + propertyValue, new Object[0]);
                    parameter.setValue(propertyValue);
                    continue;
                }
                missingProperty = true;
                log.info("No property defined for template parameter: " + name, new Object[0]);
            }
            if (missingProperty) {
                log.debug("Current properties " + new TreeSet<Object>(properties.keySet()), new Object[0]);
            }
        }
    }

    protected static Properties getProjectAndFabric8Properties(MavenProject project) {
        Properties properties = project.getProperties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    protected void createRoutes(Controller controller, Collection<HasMetadata> collection) {
        String routeDomainPostfix = this.routeDomain;
        Log log = this.getLog();
        String namespace = this.clusterAccess.getNamespace();
        try {
            OpenShiftClient openshiftClient = controller.getOpenShiftClientOrNull();
            if (openshiftClient == null) {
                return;
            }
            RouteList routes = (RouteList)((ClientNonNamespaceOperation)openshiftClient.routes().inNamespace(namespace)).list();
            if (routes != null) {
                routes.getItems();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Cannot load OpenShift Routes; maybe not connected to an OpenShift platform? " + e), (Throwable)e);
            return;
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        for (HasMetadata object : collection) {
            Service service;
            Route route;
            if (!(object instanceof Service) || (route = ApplyMojo.createRouteForService(routeDomainPostfix, namespace, service = (Service)object, log)) == null) continue;
            routes.add(route);
        }
        collection.addAll(routes);
    }

    protected void createIngress(Controller controller, KubernetesClient kubernetesClient, Collection<HasMetadata> collection) {
        Object ingresses;
        String routeDomainPostfix = this.routeDomain;
        Log log = this.getLog();
        String namespace = this.clusterAccess.getNamespace();
        List ingressList = null;
        try {
            ingresses = (IngressList)((ClientNonNamespaceOperation)kubernetesClient.extensions().ingresses().inNamespace(namespace)).list();
            if (ingresses != null) {
                ingressList = ingresses.getItems();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Cannot load Ingress instances. Must be an older version of Kubernetes? Error: " + e), (Throwable)e);
            return;
        }
        ingresses = new ArrayList();
        for (HasMetadata object : collection) {
            if (!(object instanceof Service)) continue;
            Service service = (Service)object;
            if (!this.serviceHasIngressRule(ingressList, service)) {
                Ingress ingress = ApplyMojo.createIngressForService(routeDomainPostfix, namespace, service, log);
                if (ingress != null) {
                    ingresses.add(ingress);
                    log.info((CharSequence)("Created ingress for " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
                    continue;
                }
                log.debug((CharSequence)("No ingress required for " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
                continue;
            }
            log.info((CharSequence)("Already has ingress for service " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
        }
        collection.addAll((Collection<HasMetadata>)ingresses);
    }

    private boolean serviceHasIngressRule(List<Ingress> ingresses, Service service) {
        List rules;
        Ingress ingress;
        IngressSpec spec;
        String serviceName = KubernetesHelper.getName((HasMetadata)service);
        Iterator<Ingress> iterator = ingresses.iterator();
        while (iterator.hasNext() && (spec = (ingress = iterator.next()).getSpec()) != null && (rules = spec.getRules()) != null) {
            List paths;
            IngressRule rule;
            HTTPIngressRuleValue http;
            Iterator iterator2 = rules.iterator();
            while (iterator2.hasNext() && (http = (rule = (IngressRule)iterator2.next()).getHttp()) != null && (paths = http.getPaths()) != null) {
                HTTPIngressPath path;
                IngressBackend backend;
                Iterator iterator3 = paths.iterator();
                while (iterator3.hasNext() && (backend = (path = (HTTPIngressPath)iterator3.next()).getBackend()) != null) {
                    if (!Objects.equals(serviceName, backend.getServiceName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Controller createController() {
        Controller controller = new Controller(this.clusterAccess.createDefaultClient(this.log));
        controller.setThrowExceptionOnError(this.failOnError);
        controller.setRecreateMode(this.recreate);
        this.getLog().debug((CharSequence)("Using recreate mode: " + this.recreate));
        return controller;
    }

    public String getRouteDomain() {
        return this.routeDomain;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isRecreate() {
        return this.recreate;
    }

    protected File getRootProjectFolder() {
        File answer = null;
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            File basedir = project.getBasedir();
            if (basedir == null) continue;
            answer = basedir;
        }
        return answer;
    }

    protected MavenProject getRootProject() {
        MavenProject parent;
        MavenProject project = this.getProject();
        while (project != null && (parent = project.getParent()) != null) {
            project = parent;
        }
        return project;
    }

    protected void deleteEntities(KubernetesClient kubernetes, String namespace, Set<HasMetadata> entities) {
        ArrayList<HasMetadata> list = new ArrayList<HasMetadata>(entities);
        OpenShiftClient openshiftClient = new Controller(kubernetes).getOpenShiftClientOrNull();
        if (openshiftClient != null) {
            for (HasMetadata entity : list) {
                if (!"ImageStream".equals(KubernetesHelper.getKind((HasMetadata)entity))) continue;
                ImageName imageName = new ImageName(entity.getMetadata().getName());
                String buildName = this.getS2IBuildName(imageName);
                this.log.info("Deleting resource BuildConfig " + namespace + "/" + buildName, new Object[0]);
                ((ClientBuildConfigResource)((ClientNonNamespaceOperation)openshiftClient.buildConfigs().inNamespace(namespace)).withName(buildName)).delete();
            }
        }
        Collections.reverse(list);
        for (HasMetadata entity : list) {
            this.log.info("Deleting resource " + KubernetesHelper.getKind((HasMetadata)entity) + " " + namespace + "/" + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            ((Deletable)((VisitFromServerGetDeleteRecreateApplicable)kubernetes.resource(entity).inNamespace(namespace)).cascading(true)).delete();
        }
    }

    private String getS2IBuildName(ImageName imageName) {
        return imageName.getSimpleName() + this.s2iBuildNameSuffix;
    }

    protected void resizeApp(KubernetesClient kubernetes, String namespace, Set<HasMetadata> entities, int replicas) {
        for (HasMetadata entity : entities) {
            String name = KubernetesHelper.getName((HasMetadata)entity);
            Scaleable scalable = null;
            if (entity instanceof Deployment) {
                scalable = (Scaleable)((ClientNonNamespaceOperation)kubernetes.extensions().deployments().inNamespace(namespace)).withName(name);
            } else if (entity instanceof ReplicaSet) {
                scalable = (Scaleable)((ClientNonNamespaceOperation)kubernetes.extensions().replicaSets().inNamespace(namespace)).withName(name);
            } else if (entity instanceof ReplicationController) {
                scalable = (Scaleable)((ClientNonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name);
            } else if (entity instanceof DeploymentConfig) {
                OpenShiftClient openshiftClient = new Controller(kubernetes).getOpenShiftClientOrNull();
                if (openshiftClient == null) {
                    this.log.warn("Ignoring DeploymentConfig %s as not connected to an OpenShift cluster", new Object[]{name});
                    continue;
                }
                scalable = (Scaleable)((ClientNonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).withName(name);
            }
            if (scalable == null) continue;
            this.log.info("Scaling " + KubernetesHelper.getKind((HasMetadata)entity) + " " + namespace + "/" + name + " to replicas: " + replicas, new Object[0]);
            scalable.scale(replicas, true);
        }
    }

    protected LabelSelector getPodLabelSelector(HasMetadata entity) {
        ReplicationController resource;
        ReplicationControllerSpec spec;
        LabelSelector selector = null;
        if (entity instanceof Deployment) {
            Deployment resource2 = (Deployment)entity;
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec2 != null) {
                selector = spec2.getSelector();
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource3 = (ReplicaSet)entity;
            ReplicaSetSpec spec3 = resource3.getSpec();
            if (spec3 != null) {
                selector = spec3.getSelector();
            }
        } else if (entity instanceof DeploymentConfig) {
            DeploymentConfig resource4 = (DeploymentConfig)entity;
            DeploymentConfigSpec spec4 = resource4.getSpec();
            if (spec4 != null) {
                selector = this.toLabelSelector(spec4.getSelector());
            }
        } else if (entity instanceof ReplicationController && (spec = (resource = (ReplicationController)entity).getSpec()) != null) {
            selector = this.toLabelSelector(spec.getSelector());
        }
        return selector;
    }

    private LabelSelector toLabelSelector(Map<String, String> matchLabels) {
        if (matchLabels != null && !matchLabels.isEmpty()) {
            return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(matchLabels)).build();
        }
        return null;
    }

    protected FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> withSelector(ClientNonNamespaceOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>> pods, LabelSelector selector) {
        List matchExpressions;
        FilterWatchListDeletable answer = pods;
        Map matchLabels = selector.getMatchLabels();
        if (matchLabels != null && !matchLabels.isEmpty()) {
            answer = (FilterWatchListDeletable)answer.withLabels(matchLabels);
        }
        if ((matchExpressions = selector.getMatchExpressions()) != null) {
            block8: for (LabelSelectorRequirement expression : matchExpressions) {
                String operator;
                String key = expression.getKey();
                List values = expression.getValues();
                if (Strings.isNullOrBlank((String)key)) {
                    this.log.warn("Ignoring empty key in selector expression %s", new Object[]{expression});
                    continue;
                }
                if (values == null && values.isEmpty()) {
                    this.log.warn("Ignoring empty values in selector expression %s", new Object[]{expression});
                    continue;
                }
                String[] valuesArray = values.toArray(new String[values.size()]);
                switch (operator = expression.getOperator()) {
                    case "In": {
                        answer = (FilterWatchListDeletable)answer.withLabelIn(key, valuesArray);
                        continue block8;
                    }
                    case "NotIn": {
                        answer = (FilterWatchListDeletable)answer.withLabelNotIn(key, valuesArray);
                        continue block8;
                    }
                }
                this.log.warn("Ignoring unknown operator %s in selector expression %s", new Object[]{operator, expression});
            }
        }
        return answer;
    }

    protected File getKubeCtlExecutable(Controller controller) throws MojoExecutionException {
        String missingCommandMessage;
        OpenShiftClient openShiftClient = controller.getOpenShiftClientOrNull();
        String command = openShiftClient != null ? "oc" : "kubectl";
        File file = ProcessUtil.findExecutable((Logger)this.log, (String)command);
        if (file == null && command.equals("oc")) {
            file = ProcessUtil.findExecutable((Logger)this.log, (String)command);
            missingCommandMessage = "commands oc or kubectl";
        } else {
            missingCommandMessage = "command " + command;
        }
        if (file == null) {
            throw new MojoExecutionException("Could not find " + missingCommandMessage + ". Please try running `mvn fabric8:install` to install the necessary binaries and ensure they get added to your $PATH");
        }
        return file;
    }

    protected String getPodCondition(Pod pod) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return "";
        }
        List conditions = podStatus.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return "";
        }
        for (PodCondition condition : conditions) {
            String statusText;
            String type = condition.getType();
            if (!Strings.isNotBlank((String)type) || !"ready".equalsIgnoreCase(type) || !Strings.isNotBlank((String)(statusText = condition.getStatus())) || !Boolean.parseBoolean(statusText)) continue;
            return type;
        }
        return "";
    }

    protected String getPodStatusDescription(Pod pod) {
        return KubernetesHelper.getPodStatusText((Pod)pod) + " " + this.getPodCondition(pod);
    }

    protected String getPodStatusMessagePostfix(Watcher.Action action) {
        String message = "";
        switch (action) {
            case DELETED: {
                message = ": Pod Deleted";
                break;
            }
            case ERROR: {
                message = ": Error";
            }
        }
        return message;
    }
}

