/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.Profile;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.ServiceConfig;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.OpenShiftDependencyResources;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.core.util.ResourceVersioning;
import io.fabric8.maven.core.util.ValidationUtil;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.util.InitContainerHandler;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.plugin.converter.DeploymentConfigOpenShiftConverter;
import io.fabric8.maven.plugin.converter.DeploymentOpenShiftConverter;
import io.fabric8.maven.plugin.converter.KubernetesToOpenShiftConverter;
import io.fabric8.maven.plugin.converter.NamespaceOpenShiftConverter;
import io.fabric8.maven.plugin.converter.ReplicSetOpenShiftConverter;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.maven.plugin.mojo.build.AbstractResourceMojo;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Files;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;

@Mojo(name="resource", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractResourceMojo {
    public static final String TARGET_PLATFORM_ANNOTATION = "fabric8.io/target-platform";
    private static final String DOCKER_MAVEN_PLUGIN_KEY = "io.fabric8:docker-maven-plugin";
    private static final String DOCKER_IMAGE_USER = "docker.image.user";
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.helm.resourceDir", defaultValue="${basedir}/src/main/helm")
    private File helmresourceDir;
    @Parameter(property="fabric8.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="fabric8.workDir", defaultValue="${project.build.directory}/fabric8")
    private File workDir;
    @Parameter(property="fabric8.helm.workDir", defaultValue="${project.build.directory}/helm")
    private File helmWorkDir;
    @Parameter
    private ResourceConfig resources;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter(property="fabric8.mode")
    private PlatformMode mode = PlatformMode.DEFAULT;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ProcessorConfig generator;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    private HandlerHub handlerHub;
    private Map<String, KubernetesToOpenShiftConverter> openShiftConverters;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.resource.mode", defaultValue="yaml")
    private String resourceMode;
    @Parameter(property="fabric8.openshift.deployTimeoutSeconds", defaultValue="3600")
    private Long openshiftDeployTimeoutSeconds;
    private ClusterAccess clusterAccess;
    private PlatformMode platformMode;
    private OpenShiftDependencyResources openshiftDependencyResources;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        this.clusterAccess = new ClusterAccess(this.namespace);
        try {
            if (this.isHelmMode()) {
                File dir = this.initHelmResources();
                if (dir != null) {
                    this.resourceDir = dir;
                } else {
                    this.log.info("Helm mode was enabled but no Helm resource files were found, continuing with default mode.", new Object[0]);
                }
            }
            this.lateInit();
            this.resolvedImages = this.getResolvedImages(this.images, this.log);
            if (!(this.skip || this.isPomProject() && !this.hasFabric8Dir())) {
                KubernetesList resources = this.generateResources(this.resolvedImages);
                KubernetesList openShiftResources = this.convertToOpenShiftResources(resources);
                this.writeResources(openShiftResources, ResourceClassifier.OPENSHIFT);
                KubernetesList kubernetesResources = this.convertToKubernetesResources(resources, openShiftResources);
                this.writeResources(kubernetesResources, ResourceClassifier.KUBERNETES);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate fabric8 descriptor", (Exception)e);
        }
    }

    private void lateInit() throws MojoExecutionException {
        Properties properties;
        if (this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:watch") || this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:watch")) {
            properties = this.project.getProperties();
            properties.setProperty("fabric8.watch", "true");
        }
        this.platformMode = this.clusterAccess.resolvePlatformMode(this.mode, this.log);
        this.log.info("Running in [[B]]%s[[B]] mode", new Object[]{this.platformMode.getLabel()});
        if (this.isOpenShiftMode()) {
            properties = this.project.getProperties();
            if (!properties.contains(DOCKER_IMAGE_USER)) {
                String namespace = this.clusterAccess.getNamespace();
                this.log.info("Using docker image name of namespace: " + namespace, new Object[0]);
                properties.setProperty(DOCKER_IMAGE_USER, namespace);
            }
            if (!properties.contains("fabric8.internal.effective.platform.mode")) {
                properties.setProperty("fabric8.internal.effective.platform.mode", this.platformMode.toString());
            }
        }
        this.openShiftConverters = new HashMap<String, KubernetesToOpenShiftConverter>();
        this.openShiftConverters.put("ReplicaSet", new ReplicSetOpenShiftConverter());
        this.openShiftConverters.put("Deployment", new DeploymentOpenShiftConverter(this.platformMode, this.getOpenshiftDeployTimeoutSeconds()));
        this.openShiftConverters.put("DeploymentConfig", new DeploymentConfigOpenShiftConverter(this.getOpenshiftDeployTimeoutSeconds()));
        this.openShiftConverters.put("Namespace", new NamespaceOpenShiftConverter());
        this.handlerHub = new HandlerHub(this.project);
    }

    private boolean isOpenShiftMode() {
        return this.platformMode.equals((Object)PlatformMode.openshift);
    }

    private boolean isHelmMode() {
        return this.resourceMode.equals("helm");
    }

    private File initHelmResources() throws MojoExecutionException {
        if (this.helmresourceDir.isDirectory()) {
            String dir;
            String helmTypeProp;
            String chartName = this.getProperty("fabric8.helm.chart");
            if (chartName == null) {
                chartName = this.project.getArtifactId();
            }
            if ((helmTypeProp = this.getProperty("fabric8.helm.type")) == null) {
                helmTypeProp = "kubernetes";
            }
            if ((dir = this.getProperty("fabric8.helm.workDir")) == null) {
                dir = this.helmWorkDir + "/" + helmTypeProp + "/" + chartName;
            }
            File tempHelmOutDir = new File(dir);
            tempHelmOutDir.mkdirs();
            File tempHelmDir = new File(this.helmWorkDir, "helm/" + chartName);
            tempHelmDir.mkdirs();
            this.copyTemplates(this.helmresourceDir, tempHelmDir);
            try {
                String helmInstallCmd = "helm install --dry-run --debug " + tempHelmDir;
                Runtime run = Runtime.getRuntime();
                Process pr = run.exec(helmInstallCmd);
                this.log.info("Using helm templates from %s", new Object[]{this.helmresourceDir});
                int exitCode = 0;
                BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                BufferedReader buferror = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
                String line = "";
                this.parseOutput(buf, tempHelmOutDir);
                line = buferror.readLine();
                if (line != null) {
                    this.log.debug(line, new Object[0]);
                    throw new MojoExecutionException("There was some problem running Helm.");
                }
                exitCode = this.waitForProcess(pr);
                if (exitCode != 0) {
                    throw new MojoExecutionException("Helm command returned a non-zero exit code.");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to run Helm command: ", (Exception)e);
            }
            return tempHelmOutDir;
        }
        return null;
    }

    public void copyTemplates(File source, File target) throws MojoExecutionException {
        File[] files = source.listFiles();
        if (files != null) {
            for (File file : files) {
                if (Files.isDirectory((File)file)) {
                    File[] subfiles;
                    File tempHelmSubDir = new File(target, file.getName());
                    tempHelmSubDir.mkdirs();
                    for (File subfile : subfiles = file.listFiles()) {
                        String name = subfile.getName();
                        if (name.endsWith(".yml")) {
                            name = Strings.stripSuffix((String)name, (String)".yml") + ".yaml";
                        }
                        File targetFile = new File(tempHelmSubDir, name);
                        try {
                            this.mavenFileFilter.copyFile(subfile, targetFile, true, this.project, null, false, "utf8", this.session);
                        }
                        catch (MavenFilteringException exp) {
                            throw new MojoExecutionException(String.format("Cannot filter %s to %s", subfile, targetFile), (Exception)((Object)exp));
                        }
                    }
                    continue;
                }
                String name = file.getName();
                if (name.endsWith(".yml")) {
                    name = Strings.stripSuffix((String)name, (String)".yml") + ".yaml";
                }
                File targetFile = new File(target, name);
                try {
                    this.mavenFileFilter.copyFile(file, targetFile, true, this.project, null, false, "utf8", this.session);
                }
                catch (MavenFilteringException exp) {
                    throw new MojoExecutionException(String.format("Cannot filter %s to %s", file, targetFile), (Exception)((Object)exp));
                }
            }
        }
    }

    public void parseOutput(BufferedReader buf, File targetDir) throws MojoExecutionException {
        String line = "";
        boolean flag = false;
        try {
            while ((line = buf.readLine()) != null) {
                if (line.startsWith("MANIFEST:")) {
                    flag = true;
                }
                if (!flag || !line.startsWith("# Source:")) continue;
                String[] tempStr = line.split("/");
                File fileName = new File(targetDir, tempStr[tempStr.length - 1]);
                String innerline = "";
                StringBuilder fileContent = new StringBuilder();
                while ((innerline = buf.readLine()) != null && !innerline.startsWith("---")) {
                    if (innerline == "") continue;
                    fileContent = fileContent.append("\n" + innerline);
                }
                IOHelpers.writeFully((File)fileName, (String)fileContent.toString());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to run parse Output: ", (Exception)e);
        }
    }

    private int waitForProcess(Process pr) throws MojoExecutionException {
        int exitCode = 0;
        try {
            pr.waitFor();
            exitCode = pr.exitValue();
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Failed to run Helm command: ", (Exception)e);
        }
        return exitCode;
    }

    private KubernetesList convertToKubernetesResources(KubernetesList resources, KubernetesList openShiftResources) throws MojoExecutionException {
        KubernetesList kubernetesResources = this.removeOpenShiftObjects(resources);
        KubernetesList kubernetesList = this.processOpenshiftTemplateIfProvided(openShiftResources, kubernetesResources);
        return kubernetesList;
    }

    private KubernetesList processOpenshiftTemplateIfProvided(KubernetesList openShiftResources, KubernetesList kubernetesResources) throws MojoExecutionException {
        Template template = ResourceMojo.getSingletonTemplate(openShiftResources);
        if (template != null) {
            KubernetesList kubernetesTemplateList = this.createKubernetesTemplate(kubernetesResources, template);
            if (kubernetesTemplateList != null) {
                this.writeResources(kubernetesTemplateList, ResourceClassifier.KUBERNETES_TEMPLATE);
            }
            kubernetesResources = this.replaceTemplateExpressions(kubernetesResources, template);
        }
        return kubernetesResources;
    }

    private KubernetesList createKubernetesTemplate(KubernetesList kubernetesResources, Template template) {
        Template customTemplate = ResourceMojo.createTemplateWithObjects(kubernetesResources, template);
        if (customTemplate != null) {
            return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new HasMetadata[]{customTemplate})).build();
        }
        return null;
    }

    private KubernetesList replaceTemplateExpressions(KubernetesList kubernetesResources, Template template) throws MojoExecutionException {
        Template customTemplate = ResourceMojo.createTemplateWithObjects(kubernetesResources, template);
        if (customTemplate != null) {
            try {
                return Templates.processTemplatesLocally((Template)customTemplate, (boolean)false);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to replace template expressions in kubernetes manifest: " + e, (Exception)e);
            }
        }
        return kubernetesResources;
    }

    private static Template createTemplateWithObjects(KubernetesList kubernetesResources, Template template) {
        List parameters = template.getParameters();
        List items = kubernetesResources.getItems();
        Template tempTemplate = null;
        if (parameters != null && parameters.size() > 0 && items != null && items.size() > 0) {
            tempTemplate = new Template();
            tempTemplate.setMetadata(template.getMetadata());
            tempTemplate.setParameters(parameters);
            tempTemplate.setObjects(items);
        }
        return tempTemplate;
    }

    public Long getOpenshiftDeployTimeoutSeconds() {
        return this.openshiftDeployTimeoutSeconds;
    }

    public void setOpenshiftDeployTimeoutSeconds(Long openshiftDeployTimeoutSeconds) {
        this.openshiftDeployTimeoutSeconds = openshiftDeployTimeoutSeconds;
    }

    private KubernetesList removeOpenShiftObjects(KubernetesList list) {
        KubernetesListBuilder ret = new KubernetesListBuilder();
        ret.withMetadata(list.getMetadata());
        for (HasMetadata item : list.getItems()) {
            if (!this.isOpenshiftItem(item)) {
                ret.addToItems(new HasMetadata[]{item});
                continue;
            }
            this.log.verbose("kubernetes.yml: Removed OpenShift specific resource '%s' of type %s", new Object[]{KubernetesHelper.getName((HasMetadata)item), KubernetesHelper.getKind((HasMetadata)item)});
        }
        return ret.build();
    }

    private boolean isOpenshiftItem(HasMetadata item) {
        if (this.isTargetPlatformOpenShift(item)) {
            return true;
        }
        return item.getClass().getPackage().getName().contains("openshift");
    }

    private boolean isTargetPlatformOpenShift(HasMetadata item) {
        String targetPlatform = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)item).get(TARGET_PLATFORM_ANNOTATION);
        return targetPlatform != null && "openshift".equalsIgnoreCase(targetPlatform);
    }

    private boolean isTargetPlatformKubernetes(HasMetadata item) {
        String targetPlatform = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)item).get(TARGET_PLATFORM_ANNOTATION);
        return targetPlatform != null && "kubernetes".equalsIgnoreCase(targetPlatform);
    }

    private KubernetesList generateResources(List<ImageConfiguration> images) throws IOException, MojoExecutionException {
        this.openshiftDependencyResources = new OpenShiftDependencyResources(this.log);
        EnricherContext.Builder ctxBuilder = new EnricherContext.Builder().project(this.project).session(this.session).goalFinder(this.goalFinder).config(this.extractEnricherConfig()).resources(this.resources).images(this.resolvedImages).log(this.log).useProjectClasspath(this.useProjectClasspath).openshiftDependencyResources(this.openshiftDependencyResources);
        if (this.resources != null) {
            ctxBuilder.namespace(this.resources.getNamespace());
        }
        EnricherManager enricherManager = new EnricherManager(this.resources, ctxBuilder.build());
        KubernetesListBuilder builder = this.generateAppResources(images, enricherManager);
        this.addProfiledResourcesFromSubirectories(builder, this.resourceDir, enricherManager);
        return builder.build();
    }

    private void addProfiledResourcesFromSubirectories(KubernetesListBuilder builder, File resourceDir, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        File[] profileDirs = resourceDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (profileDirs != null) {
            for (File profileDir : profileDirs) {
                Profile profile = ProfileUtil.findProfile((String)profileDir.getName(), (File)resourceDir);
                if (profile == null) {
                    throw new MojoExecutionException(String.format("Invalid profile '%s' given as directory in %s. Please either define a profile of this name or move this directory away", profileDir.getName(), resourceDir));
                }
                ProcessorConfig enricherConfig = profile.getEnricherConfig();
                File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)profileDir);
                if (resourceFiles.length <= 0) continue;
                KubernetesListBuilder profileBuilder = this.readResourceFragments(resourceFiles);
                enricherManager.createDefaultResources(enricherConfig, profileBuilder);
                enricherManager.enrich(enricherConfig, profileBuilder);
                KubernetesList profileItems = profileBuilder.build();
                for (HasMetadata item : profileItems.getItems()) {
                    builder.addToItems(new HasMetadata[]{item});
                }
            }
        }
    }

    private KubernetesListBuilder generateAppResources(List<ImageConfiguration> images, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        try {
            KubernetesListBuilder builder;
            File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)this.resourceDir);
            if (resourceFiles != null && resourceFiles.length > 0) {
                this.log.info("Using resource templates from %s", new Object[]{this.resourceDir});
                builder = this.readResourceFragments(resourceFiles);
            } else {
                builder = new KubernetesListBuilder();
            }
            if (this.resources != null) {
                this.addConfiguredResources(builder, images);
            }
            enricherManager.createDefaultResources(builder);
            enricherManager.enrich(builder);
            return builder;
        }
        catch (ConstraintViolationException e) {
            String message = ValidationUtil.createValidationMessage((Set)e.getConstraintViolations());
            this.log.error("ConstraintViolationException: %s", new Object[]{message});
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
    }

    private KubernetesListBuilder readResourceFragments(File[] resourceFiles) throws IOException, MojoExecutionException {
        String defaultName = MavenUtil.createDefaultResourceName((MavenProject)this.project, (String[])new String[0]);
        KubernetesListBuilder builder = KubernetesResourceUtil.readResourceFragmentsFrom((ResourceVersioning)KubernetesResourceUtil.DEFAULT_RESOURCE_VERSIONING, (String)defaultName, (File[])this.mavenFilterFiles(resourceFiles));
        return builder;
    }

    private ProcessorConfig extractEnricherConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.resourceDir, (ProcessorConfig)this.enricher);
    }

    private ProcessorConfig extractGeneratorConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.resourceDir, (ProcessorConfig)this.generator);
    }

    private KubernetesList convertToOpenShiftResources(KubernetesList resources) throws MojoExecutionException {
        KubernetesListBuilder builder = new KubernetesListBuilder();
        builder.withMetadata(resources.getMetadata());
        List items = resources.getItems();
        ArrayList<HasMetadata> objects = new ArrayList<HasMetadata>();
        if (items != null) {
            for (HasMetadata item : items) {
                HasMetadata converted;
                String name;
                if (item instanceof Deployment && this.hasDeploymentConfigNamed(items, name = KubernetesHelper.getName((HasMetadata)item)) || (converted = this.convertKubernetesItemToOpenShift(item)) == null || this.isTargetPlatformKubernetes(item)) continue;
                objects.add(converted);
            }
        }
        this.openshiftDependencyResources.addMissingResources(objects);
        this.moveTemplatesToTopLevel(builder, objects);
        this.removeInitContainers(builder, "fmp-volume-permission");
        return builder.build();
    }

    private void removeInitContainers(KubernetesListBuilder builder, final String enricherName) {
        builder.accept((Visitor)new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder builder) {
                InitContainerHandler initContainerHandler = new InitContainerHandler(ResourceMojo.this.log);
                if (initContainerHandler.hasInitContainer(builder, enricherName)) {
                    ResourceMojo.this.log.verbose("Removing init container from openshift.yml for %s", new Object[]{enricherName});
                    initContainerHandler.removeInitContainer(builder, enricherName);
                }
            }
        });
    }

    private void moveTemplatesToTopLevel(KubernetesListBuilder builder, List<HasMetadata> objects) {
        Template template = this.extractAndRemoveTemplates(objects);
        if (template != null) {
            this.openshiftDependencyResources.addMissingParameters(template);
            builder.addToItems(new HasMetadata[]{template});
        } else {
            for (HasMetadata object : objects) {
                builder.addToItems(new HasMetadata[]{object});
            }
        }
    }

    private Template extractAndRemoveTemplates(List<HasMetadata> items) {
        Template extractedTemplate = null;
        for (HasMetadata item : new ArrayList<HasMetadata>(items)) {
            if (!(item instanceof Template) || KubernetesResourceUtil.isAppCatalogResource((HasMetadata)item)) continue;
            Template template = (Template)item;
            extractedTemplate = extractedTemplate == null ? template : Templates.combineTemplates((Template)extractedTemplate, (Template)template);
            items.remove(item);
        }
        if (extractedTemplate != null) {
            extractedTemplate.setObjects(items);
        }
        return extractedTemplate;
    }

    private boolean hasDeploymentConfigNamed(List<HasMetadata> items, String name) {
        for (HasMetadata item : items) {
            String dcName;
            if (!(item instanceof DeploymentConfig) || !Objects.equals(name, dcName = KubernetesHelper.getName((HasMetadata)item))) continue;
            return true;
        }
        return false;
    }

    private HasMetadata convertKubernetesItemToOpenShift(HasMetadata item) {
        if (item instanceof ConfigMap && "true".equals(this.getAnnotations(item).get("maven.fabric8.io/app-catalog"))) {
            return null;
        }
        HasMetadata dependencyResource = this.openshiftDependencyResources.convertKubernetesItemToOpenShift(item);
        if (dependencyResource != null) {
            return dependencyResource;
        }
        KubernetesToOpenShiftConverter converter = this.openShiftConverters.get(item.getKind());
        return converter != null ? converter.convert(item) : item;
    }

    private Map<String, String> getAnnotations(HasMetadata item) {
        ObjectMeta meta = item.getMetadata();
        if (meta == null) {
            return Collections.EMPTY_MAP;
        }
        Map annos = meta.getAnnotations();
        if (annos == null) {
            return Collections.EMPTY_MAP;
        }
        return annos;
    }

    private List<ImageConfiguration> getResolvedImages(List<ImageConfiguration> images, final Logger log) throws MojoExecutionException {
        List ret = ConfigHelper.resolveImages((Logger)log, images, (ConfigHelper.Resolver)new ConfigHelper.Resolver(){

            public List<ImageConfiguration> resolve(ImageConfiguration image) {
                return ResourceMojo.this.imageConfigResolver.resolve(image, ResourceMojo.this.project, ResourceMojo.this.session);
            }
        }, null, (ConfigHelper.Customizer)new ConfigHelper.Customizer(){

            public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
                try {
                    GeneratorContext ctx = new GeneratorContext.Builder().config(ResourceMojo.this.extractGeneratorConfig()).project(ResourceMojo.this.project).session(ResourceMojo.this.session).goalFinder(ResourceMojo.this.goalFinder).goalName("fabric8:resource").logger(log).mode(ResourceMojo.this.mode).strategy(ResourceMojo.this.buildStrategy).useProjectClasspath(ResourceMojo.this.useProjectClasspath).build();
                    return GeneratorManager.generate(configs, ctx, true);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot extract generator: " + e, e);
                }
            }
        });
        Date now = this.getBuildReferenceDate();
        this.storeReferenceDateInPluginContext(now);
        String minimalApiVersion = ConfigHelper.initAndValidate((List)ret, null, (ConfigHelper.NameFormatter)new ImageNameFormatter(this.project, now), (Logger)log);
        return ret;
    }

    private void storeReferenceDateInPluginContext(Date now) {
        Map pluginContext = this.getPluginContext();
        pluginContext.put("CONTEXT_KEY_BUILD_TIMESTAMP", now);
    }

    private Date getBuildReferenceDate() throws MojoExecutionException {
        if (this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:build") || this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:deploy") || this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:run")) {
            return new Date();
        }
        File tsFile = new File(this.project.getBuild().getDirectory(), "docker/build.timestamp");
        if (!tsFile.exists()) {
            return new Date();
        }
        try {
            return EnvUtil.loadTimestamp((File)tsFile);
        }
        catch (MojoExecutionException e) {
            throw new MojoExecutionException("Cannot read timestamp from " + tsFile, (Exception)((Object)e));
        }
    }

    private void addConfiguredResources(KubernetesListBuilder builder, List<ImageConfiguration> images) {
        this.log.verbose("Adding resources from plugin configuration", new Object[0]);
        this.addServices(builder, this.resources.getServices());
        this.addController(builder, images);
    }

    private void addController(KubernetesListBuilder builder, List<ImageConfiguration> images) {
        ReplicationControllerHandler rcHandler = this.handlerHub.getReplicationControllerHandler();
        if (this.resources.getControllerName() != null) {
            builder.addToReplicationControllerItems(new ReplicationController[]{rcHandler.getReplicationController(this.resources, images)});
        }
    }

    private File[] mavenFilterFiles(File[] resourceFiles) throws MojoExecutionException {
        if (!this.workDir.exists() && !this.workDir.mkdirs()) {
            throw new MojoExecutionException("Cannot create working dir " + this.workDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(this.workDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new MojoExecutionException(String.format("Cannot filter %s to %s", resource, targetFile), (Exception)((Object)exp));
            }
        }
        return ret;
    }

    private void addServices(KubernetesListBuilder builder, List<ServiceConfig> serviceConfig) {
        if (serviceConfig != null) {
            ServiceHandler serviceHandler = this.handlerHub.getServiceHandler();
            builder.addToServiceItems(this.toArray(serviceHandler.getServices(serviceConfig)));
        }
    }

    private Service[] toArray(List<Service> services) {
        if (services == null) {
            return new Service[0];
        }
        if (services instanceof ArrayList) {
            return ((ArrayList)services).toArray(new Service[services.size()]);
        }
        Service[] ret = new Service[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            ret[i] = services.get(i);
        }
        return ret;
    }

    private boolean hasFabric8Dir() {
        return this.resourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }
}

