/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.converter;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.maven.plugin.converter.KubernetesToOpenShiftConverter;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;

public class DeploymentConfigOpenShiftConverter
implements KubernetesToOpenShiftConverter {
    private final Long openshiftDeployTimeoutSeconds;

    public DeploymentConfigOpenShiftConverter(Long openshiftDeployTimeoutSeconds) {
        this.openshiftDeployTimeoutSeconds = openshiftDeployTimeoutSeconds;
    }

    @Override
    public HasMetadata convert(HasMetadata item) {
        if (item instanceof DeploymentConfig) {
            DeploymentConfig resource = (DeploymentConfig)item;
            if (this.openshiftDeployTimeoutSeconds != null && this.openshiftDeployTimeoutSeconds > 0L) {
                DeploymentConfigBuilder builder = new DeploymentConfigBuilder(resource);
                DeploymentConfigFluent.SpecNested specBuilder = resource.getSpec() != null ? builder.editSpec() : builder.withNewSpec();
                ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RollingParamsNested)((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Rolling")).withNewRollingParams().withTimeoutSeconds(this.openshiftDeployTimeoutSeconds)).endRollingParams()).endStrategy();
                specBuilder.endSpec();
                return builder.build();
            }
        }
        return item;
    }
}

