/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.infra;

import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.IoUtil;
import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public abstract class AbstractInstallMojo
extends AbstractFabric8Mojo {
    protected static final String GOFABRIC8 = "gofabric8";
    protected static final String KOMPOSE = "kompose";
    private static final String GOFABRIC8_VERSION_URL = "https://raw.githubusercontent.com/fabric8io/gofabric8/master/version/VERSION";
    private static final String KOMPOSE_VERSION_URL = "https://raw.githubusercontent.com/kubernetes/kompose/master/build/VERSION";
    public static final String VERSION_ARGUMENT = "version";
    public static final String BATCH_ARGUMENT = "--batch";
    private static String GOFABRIC_DOWNLOAD_URL_FORMAT = "https://github.com/fabric8io/gofabric8/releases/download/v%s/gofabric8-%s-%s";
    private static String KOMPOSE_DOWNLOAD_URL_FORMAT = "https://github.com/kubernetes/kompose/releases/download/v%s/kompose-%s-%s";
    @Parameter(property="fabric8.cluster.kind")
    protected String clusterKind;
    @Parameter(property="fabric8.mode")
    protected PlatformMode mode;
    @Parameter(property="fabric8.dir", defaultValue="${user.home}/.fabric8/bin")
    private File fabric8BinDir;
    @Parameter(property="kompose.dir", defaultValue="${user.home}/.kompose/bin")
    private File komposeBinDir;
    @Component
    private Prompter prompter;
    @Parameter(property="fabric8.install.batch.mode", defaultValue="false")
    private boolean installBatchMode;

    protected File installGofabric8IfNotAvailable() throws MojoExecutionException {
        File gofabric8 = ProcessUtil.findExecutable((Logger)this.log, (String)GOFABRIC8);
        if (gofabric8 == null) {
            gofabric8 = this.installAndConfigureBinary(this.fabric8BinDir, GOFABRIC8, GOFABRIC8_VERSION_URL, GOFABRIC_DOWNLOAD_URL_FORMAT);
        } else {
            this.log.info("Found %s", new Object[]{gofabric8});
        }
        this.executeGoFabric8Command(gofabric8, VERSION_ARGUMENT);
        return gofabric8;
    }

    protected File installKomposeIfNotAvailable() throws MojoExecutionException {
        File kompose = ProcessUtil.findExecutable((Logger)this.log, (String)KOMPOSE);
        if (kompose == null) {
            kompose = this.installAndConfigureBinary(this.komposeBinDir, KOMPOSE, KOMPOSE_VERSION_URL, KOMPOSE_DOWNLOAD_URL_FORMAT);
        } else {
            this.log.info("Found %s", new Object[]{kompose});
        }
        this.executeCommand(kompose, KOMPOSE, VERSION_ARGUMENT);
        return kompose;
    }

    private File installAndConfigureBinary(File binDirectory, String binName, String binVersionUrl, String binDownloadUrlFormat) throws MojoExecutionException {
        File binaryFile = null;
        this.validateDir(binDirectory);
        String fileName = binName;
        if (Platform.windows.equals((Object)this.getPlatform())) {
            fileName = fileName + ".exe";
        }
        if (!((binaryFile = new File(binDirectory, fileName)).exists() && binaryFile.isFile() && binaryFile.canExecute())) {
            this.downloadExecutable(binVersionUrl, binDownloadUrlFormat, binDirectory, binaryFile, binName);
        }
        if (!ProcessUtil.folderIsOnPath((Logger)this.log, (File)binDirectory)) {
            this.updateStartupScriptInstructions(binDirectory, binName);
        }
        return binaryFile;
    }

    private void updateStartupScriptInstructions(File binDir, String fileName) throws MojoExecutionException {
        String absolutePath = binDir.getAbsolutePath();
        String indent = "  ";
        this.log.warn("The %s bin folder %s is not on the PATH.", new Object[]{fileName, binDir.getAbsolutePath()});
        this.log.warn("To easily start fabric8 CLI tools like [[B]]%s[[B]] directly, please adapt your environment:", new Object[]{fileName});
        if (Platform.windows.name().equals(this.getPlatform().name())) {
            this.log.info("Please add the following to PATH environment variable:", new Object[0]);
            this.log.info("%s[[C]]set PATH=%%PATH%%;%s[[C]]", new Object[]{indent, absolutePath});
        } else {
            String setPathCmd = "export PATH=$PATH:" + absolutePath;
            this.log.info("Please add the following to your ~/.bashrc:", new Object[0]);
            this.log.info("%s[[C]]%s[[C]]", new Object[]{indent, setPathCmd});
            File rcFile = this.getStartupScript();
            if (rcFile != null) {
                this.updateStartupScript(rcFile, setPathCmd);
            }
        }
    }

    private void updateStartupScript(File rcFile, String setPathCmd) throws MojoExecutionException {
        if (!this.installBatchMode) {
            try {
                String answer = this.prompter.prompt("Would you like to add the path setting to your ~/" + rcFile.getName() + " now? (Y/n)");
                if (answer != null && answer.trim().isEmpty() || answer.trim().toUpperCase().startsWith("Y")) {
                    this.addToStartupScript(rcFile, setPathCmd);
                    this.log.info("Updated %s. Please type the following command to update your current shell:", new Object[]{rcFile});
                    this.log.info("     [[C]]source ~/%s[[C]]", new Object[]{rcFile.getName()});
                }
            }
            catch (PrompterException e) {
                this.log.warn("Failed to ask user prompt: %s", new Object[]{e});
            }
        } else {
            this.log.warn("Cannot update startup script when running in batch mode", new Object[0]);
        }
    }

    private File getStartupScript() {
        File homeDir = new File(System.getProperty("user.home", "."));
        for (String fileName : new String[]{".bashrc", ".zshrc", ".profile", ".bash_profile"}) {
            File testFile = new File(homeDir, fileName);
            if (!testFile.exists() || !testFile.isFile()) continue;
            return testFile;
        }
        return null;
    }

    private void addToStartupScript(File rcFile, String text) throws MojoExecutionException {
        try (FileWriter writer = new FileWriter(rcFile, true);){
            writer.append("\n");
            writer.append("# Added by fabric8-maven-plugin at " + new Date() + "\n");
            writer.append(text + "\n");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to append to " + rcFile + ": " + e, (Exception)e);
        }
    }

    private void validateDir(File dir) throws MojoExecutionException {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new MojoExecutionException(String.format("Failed to create directory %s. Do you have permission on this folder?", dir));
            }
        } else if (!dir.isDirectory()) {
            throw new MojoExecutionException(String.format("%s exists but is not a directory", dir));
        }
    }

    protected void downloadExecutable(String versionUrl, String downloadUrl, File downloadDir, File destFile, String fileName) throws MojoExecutionException {
        File tempFile = this.downloadToTempFile(versionUrl, downloadUrl, downloadDir, fileName);
        this.moveFile(tempFile, destFile, fileName);
    }

    private File downloadToTempFile(String versionUrl, String downloadUrlFormat, File downloadDir, String fileName) throws MojoExecutionException {
        File destFile = this.createDownloadFile(downloadDir, fileName);
        URL downloadUrl = this.getDownloadUrl(versionUrl, downloadUrlFormat, fileName);
        IoUtil.download((Logger)this.log, (URL)downloadUrl, (File)destFile);
        return destFile;
    }

    private File createDownloadFile(File downloadLocation, String fileName) throws MojoExecutionException {
        try {
            File downloadDir = Files.createTempDirectory(downloadLocation.toPath(), "download", new FileAttribute[0]).toFile();
            downloadDir.deleteOnExit();
            File ret = new File(downloadDir, fileName);
            ret.deleteOnExit();
            this.log.debug("Downloading %s to temporary file %s", new Object[]{fileName, ret});
            return ret;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create a temporary file for the download");
        }
    }

    private URL getDownloadUrl(String versionUrl, String downloadUrl, String fileName) throws MojoExecutionException {
        String version = this.getBinaryFileVersion(versionUrl);
        String platform = this.getPlatform().name();
        String arch = this.getArchitecture().name();
        String releaseUrl = String.format(downloadUrl, version, platform, arch);
        if (platform.equalsIgnoreCase("windows")) {
            releaseUrl = releaseUrl + ".exe";
        }
        this.log.info("Downloading %s:", new Object[]{fileName});
        this.log.info("   Version:      [[B]]%s[[B]]", new Object[]{version});
        this.log.info("   Platform:     [[B]]%s[[B]]", new Object[]{platform});
        this.log.info("   Architecture: [[B]]%s[[B]]", new Object[]{arch});
        try {
            return new URL(releaseUrl);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to create URL from " + releaseUrl + ": " + e, (Exception)e);
        }
    }

    private void moveFile(File tempFile, File destFile, String fileName) throws MojoExecutionException {
        if (!tempFile.renameTo(destFile)) {
            try {
                IOHelpers.copy((InputStream)new FileInputStream(tempFile), (OutputStream)new FileOutputStream(destFile));
                this.log.info("Downloaded %s to %s", new Object[]{fileName, destFile});
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy temporary file " + tempFile + " to " + destFile + ": " + e, (Exception)e);
            }
        }
        if (!destFile.setExecutable(true)) {
            throw new MojoExecutionException("Cannot make " + destFile + " executable");
        }
    }

    private String getBinaryFileVersion(String versionUrl) throws MojoExecutionException {
        try {
            String version = IOHelpers.readFully((URL)new URL(versionUrl));
            return version;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load version from " + versionUrl + ". " + e, (Exception)e);
        }
    }

    private Architecture getArchitecture() {
        String osArch = System.getProperty("os.arch");
        if (osArch != null && osArch.toLowerCase().contains("arm")) {
            return Architecture.arm;
        }
        return Architecture.amd64;
    }

    protected Platform getPlatform() {
        String osName = System.getProperty("os.name");
        if (osName.contains("OS X") || osName.contains("Mac ")) {
            return Platform.darwin;
        }
        if (osName.contains("Windows")) {
            return Platform.windows;
        }
        return Platform.linux;
    }

    protected void executeGoFabric8Command(File command, String ... args) throws MojoExecutionException {
        this.executeCommand(command, GOFABRIC8, (String[])ArrayUtils.addAll((Object[])args, (Object[])new String[]{BATCH_ARGUMENT}));
    }

    protected void executeCommand(File command, String binName, String ... args) throws MojoExecutionException {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        String argLine = Strings.join(argList, (String)" ");
        this.log.info("Running %s %s", new Object[]{command, argLine});
        String message = command.getName() + " " + argLine;
        try {
            int result = ProcessUtil.runCommand((Logger)this.createExternalProcessLogger("[[B]]" + binName + "[[B]] "), (File)command, argList);
            if (result != 0) {
                throw new MojoExecutionException("Failed to execute " + message + " result was: " + result);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to execute %s : %s", command, e.getMessage()), (Exception)e);
        }
    }

    protected boolean isMinishift() {
        if (Strings.isNotBlank((String)this.clusterKind)) {
            String text = this.clusterKind.toLowerCase().trim();
            return text.equals("minishift") || text.equals("openshift");
        }
        return this.mode != null && this.mode == PlatformMode.openshift;
    }

    private static enum Architecture {
        amd64,
        arm;

    }

    private static enum Platform {
        linux,
        darwin,
        windows;

    }
}

