/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.infra;

import io.fabric8.maven.plugin.mojo.infra.AbstractInstallMojo;
import io.fabric8.utils.Strings;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="cluster-start", requiresProject=false)
public class ClusterStartMojo
extends AbstractInstallMojo {
    @Parameter(property="fabric8.cluster.app", defaultValue="console")
    private String clusterApp;
    @Parameter(property="fabric8.cluster.cpus")
    private String clusterCPUs;
    @Parameter(property="fabric8.cluster.memory")
    private String clusterMemory;
    @Parameter(property="fabric8.cluster.driver")
    private String clusterDriver;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        File gofabric8 = this.installGofabric8IfNotAvailable();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("start");
        if (this.isMinishift()) {
            arguments.add("--minishift");
        } else if (Strings.isNotBlank((String)this.clusterKind)) {
            arguments.add("--" + this.clusterKind);
        }
        if (!this.clusterApp.equals("fabric8") && !this.clusterApp.equals("platform")) {
            arguments.add("--" + this.clusterApp);
        }
        if (Strings.isNotBlank((String)this.clusterDriver)) {
            arguments.add("--vm-driver");
            arguments.add(this.clusterDriver);
        }
        if (Strings.isNotBlank((String)this.clusterCPUs)) {
            arguments.add("--cpus");
            arguments.add(this.clusterCPUs);
        }
        if (Strings.isNotBlank((String)this.clusterMemory)) {
            arguments.add("--memory");
            arguments.add(this.clusterMemory);
        }
        this.executeGoFabric8Command(gofabric8, arguments.toArray(new String[arguments.size()]));
    }
}

