/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.maven.core.config.HelmConfig;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Files;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.tar.TarArchiver;

@Mojo(name="helm", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class HelmMojo
extends AbstractFabric8Mojo {
    protected static final String FAILED_TO_LOAD_KUBERNETES_YAML = "Failed to load kubernetes YAML ";
    protected static final String YAML_EXTENSION = ".yaml";
    @org.apache.maven.plugins.annotations.Parameter
    private HelmConfig helm;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/kubernetes.yml")
    private File kubernetesManifest;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.kubernetesTemplate", defaultValue="${basedir}/target/classes/META-INF/fabric8/k8s-template.yml")
    private File kubernetesTemplate;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=Archiver.class, hint="tar")
    private TarArchiver archiver;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        String chartName = this.getChartName();
        for (HelmConfig.HelmType type : this.getHelmTypes()) {
            this.generateHelmChartDirectory(chartName, type);
        }
    }

    protected void generateHelmChartDirectory(String chartName, HelmConfig.HelmType type) throws MojoExecutionException {
        File outputDir = this.prepareOutputDir(type);
        File sourceDir = this.checkSourceDir(chartName, type);
        if (sourceDir == null) {
            return;
        }
        this.log.info("Creating Helm Chart \"%s\" for %s", new Object[]{chartName, type.getDescription()});
        this.log.verbose("SourceDir: %s", new Object[]{sourceDir});
        this.log.verbose("OutputDir: %s", new Object[]{outputDir});
        File templatesDir = this.copyResourceFilesToTemplatesDir(outputDir, sourceDir);
        this.createChartYaml(chartName, outputDir);
        this.copyTextFile(outputDir, "README");
        this.copyTextFile(outputDir, "LICENSE");
        Template template = this.findTemplate();
        if (template != null) {
            this.createTemplateParameters(outputDir, template, templatesDir);
        }
        File destinationFile = new File(this.project.getBuild().getDirectory(), chartName + "-" + this.project.getVersion() + "-" + type.getClassifier() + "." + this.getChartFileExtension());
        MavenUtil.createArchive((File)outputDir.getParentFile(), (File)destinationFile, (TarArchiver)this.archiver);
        this.projectHelper.attachArtifact(this.project, this.getChartFileExtension(), type.getClassifier(), destinationFile);
    }

    private String getChartName() {
        String ret = this.getProperty("fabric8.helm.chart");
        if (ret != null) {
            return ret;
        }
        if (this.helm != null) {
            ret = this.helm.getChart();
        }
        return ret != null ? ret : this.project.getArtifactId();
    }

    private String getChartFileExtension() {
        String ret = this.getProperty("fabric8.helm.chartExtension");
        if (ret != null) {
            return ret;
        }
        if (this.helm != null) {
            ret = this.helm.getChartExtension();
        }
        return ret != null ? ret : "tar.gz";
    }

    private File prepareOutputDir(HelmConfig.HelmType type) {
        File dirF;
        String dir = this.getProperty("fabric8.helm.outputDir");
        if (dir == null) {
            dir = String.format("%s/fabric8/helm/%s/%s", this.project.getBuild().getDirectory(), type.getOutputDir(), this.getChartName());
        }
        if (Files.isDirectory((File)(dirF = new File(dir)))) {
            Files.recursiveDelete((File)dirF);
        }
        return dirF;
    }

    private File checkSourceDir(String chartName, HelmConfig.HelmType type) {
        File dirF;
        String dir = this.getProperty("fabric8.helm.sourceDir");
        if (dir == null) {
            dir = this.project.getBuild().getOutputDirectory() + "/META-INF/fabric8/" + type.getSourceDir();
        }
        if (!(dirF = new File(dir)).isDirectory() || !dirF.exists()) {
            this.log.warn("Chart source directory %s does not exist so cannot make chart %s. Probably you need run 'mvn fabric8:resource' before.", new Object[]{dirF, chartName});
            return null;
        }
        if (!this.containsYamlFiles(dirF)) {
            this.log.warn("Chart source directory %s does not contain any YAML manifest to make chart %s. Probably you need run 'mvn fabric8:resource' before.", new Object[]{dirF, chartName});
            return null;
        }
        return dirF;
    }

    private List<HelmConfig.HelmType> getHelmTypes() {
        List types;
        String helmTypeProp = this.getProperty("fabric8.helm.type");
        if (!Strings.isNullOrBlank((String)helmTypeProp)) {
            List propTypes = Strings.splitAsList((String)helmTypeProp, (String)",");
            ArrayList<HelmConfig.HelmType> ret = new ArrayList<HelmConfig.HelmType>();
            for (String prop : propTypes) {
                ret.add(HelmConfig.HelmType.valueOf((String)prop.trim().toLowerCase()));
            }
            return ret;
        }
        if (this.helm != null && (types = this.helm.getType()) != null && types.size() > 0) {
            return types;
        }
        return Arrays.asList(HelmConfig.HelmType.kubernetes);
    }

    private void createChartYaml(String chartName, File outputDir) throws MojoExecutionException {
        Chart chart = this.helm != null ? new Chart(chartName, this.project, this.helm.getKeywords(), this.helm.getEngine()) : new Chart(chartName, this.project);
        String iconUrl = this.findIconURL();
        this.getLog().debug((CharSequence)("Found icon: " + iconUrl));
        if (Strings.isNotBlank((String)iconUrl)) {
            chart.setIcon(iconUrl);
        }
        File outputChartFile = new File(outputDir, "Chart.yaml");
        try {
            HelmMojo.saveYaml(chart, outputChartFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save chart " + outputChartFile + ": " + e, (Exception)e);
        }
    }

    protected static void saveYaml(Object object, File file) throws IOException {
        KubernetesResourceUtil.writeResourceFile((Object)object, (File)file, (ResourceFileType)ResourceFileType.yaml);
    }

    private void createTemplateParameters(File outputDir, Template template, File templatesDir) throws MojoExecutionException {
        JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
        ObjectNode values = nodeFactory.objectNode();
        List parameters = template.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        ArrayList<HelmParameter> helmParameters = new ArrayList<HelmParameter>();
        for (Parameter parameter : parameters) {
            HelmParameter helmParameter = new HelmParameter(parameter);
            helmParameter.addToValue(values);
            helmParameters.add(helmParameter);
        }
        File outputChartFile = new File(outputDir, "values.yaml");
        try {
            HelmMojo.saveYaml(values, outputChartFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save chart values " + outputChartFile + ": " + e, (Exception)e);
        }
        File[] files = templatesDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String extension;
                if (!file.isFile() || !(extension = Files.getExtension((String)file.getName()).toLowerCase()).equals("yaml") && !extension.equals("yml")) continue;
                this.convertTemplateParameterExpressionsWithHelmExpressions(file, helmParameters);
            }
        }
    }

    private void convertTemplateParameterExpressionsWithHelmExpressions(File file, List<HelmParameter> helmParameters) throws MojoExecutionException {
        String text = null;
        try {
            text = IOHelpers.readFully((File)file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load " + file + " so we can replacing template expressions " + e, (Exception)e);
        }
        String original = text;
        for (HelmParameter helmParameter : helmParameters) {
            text = helmParameter.convertTemplateParameterToHelmExpression(text);
        }
        if (!original.equals(text)) {
            try {
                IOHelpers.writeFully((File)file, (String)text);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to save " + file + " after replacing template expressions " + e, (Exception)e);
            }
        }
    }

    private String findIconURL() throws MojoExecutionException {
        String answer = null;
        if (this.kubernetesManifest != null && this.kubernetesManifest.isFile()) {
            KubernetesList list;
            List items;
            Object dto = null;
            try {
                dto = KubernetesHelper.loadYaml((File)this.kubernetesManifest, KubernetesResource.class);
            }
            catch (IOException e) {
                throw new MojoExecutionException(FAILED_TO_LOAD_KUBERNETES_YAML + this.kubernetesManifest + ". " + e, (Exception)e);
            }
            if (dto instanceof HasMetadata) {
                answer = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)((HasMetadata)dto)).get("fabric8.io/iconUrl");
            }
            if (Strings.isNullOrBlank(answer) && dto instanceof KubernetesList && (items = (list = (KubernetesList)dto).getItems()) != null) {
                HasMetadata item;
                Iterator iterator = items.iterator();
                while (iterator.hasNext() && !Strings.isNotBlank((String)(answer = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)(item = (HasMetadata)iterator.next())).get("fabric8.io/iconUrl")))) {
                }
            }
        } else {
            this.getLog().warn((CharSequence)("No kubernetes manifest file has been generated yet by the fabric8:resource goal at: " + this.kubernetesManifest));
        }
        return answer;
    }

    private Template findTemplate() throws MojoExecutionException {
        if (this.kubernetesTemplate != null && this.kubernetesTemplate.isFile()) {
            KubernetesList list;
            List items;
            Object dto = null;
            try {
                dto = KubernetesHelper.loadYaml((File)this.kubernetesTemplate, KubernetesResource.class);
            }
            catch (IOException e) {
                throw new MojoExecutionException(FAILED_TO_LOAD_KUBERNETES_YAML + this.kubernetesTemplate + ". " + e, (Exception)e);
            }
            if (dto instanceof Template) {
                return (Template)dto;
            }
            if (dto instanceof KubernetesList && (items = (list = (KubernetesList)dto).getItems()) != null) {
                for (HasMetadata item : items) {
                    if (!(item instanceof Template)) continue;
                    return (Template)item;
                }
            }
        }
        return null;
    }

    private File copyResourceFilesToTemplatesDir(File outputDir, File sourceDir) throws MojoExecutionException {
        File templatesDir = new File(outputDir, "templates");
        templatesDir.mkdirs();
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (File file : files) {
                Object dto;
                try {
                    dto = KubernetesHelper.loadYaml((File)file, KubernetesResource.class);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(FAILED_TO_LOAD_KUBERNETES_YAML + file + ". " + e, (Exception)e);
                }
                if (dto instanceof Template) {
                    Template template = (Template)dto;
                    this.copyTemplateResourcesToTemplatesDir(templatesDir, template);
                    continue;
                }
                String name = file.getName();
                if (name.endsWith(".yml")) {
                    name = Strings.stripSuffix((String)name, (String)".yml") + YAML_EXTENSION;
                }
                File targetFile = new File(templatesDir, name);
                try {
                    String text = IOHelpers.readFully((File)file);
                    text = HelmMojo.escapeYamlTemplate(text);
                    IOHelpers.writeFully((File)targetFile, (String)text);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy manifest files from " + file + " to " + targetFile + ": " + e, (Exception)e);
                }
            }
        }
        return templatesDir;
    }

    private void copyTemplateResourcesToTemplatesDir(File templatesDir, Template template) throws MojoExecutionException {
        List objects = template.getObjects();
        if (objects != null) {
            for (HasMetadata object : objects) {
                String name = KubernetesResourceUtil.getNameWithSuffix((String)KubernetesHelper.getName((HasMetadata)object), (String)KubernetesHelper.getKind((HasMetadata)object)) + YAML_EXTENSION;
                File outFile = new File(templatesDir, name);
                try {
                    HelmMojo.saveYaml(object, outFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to save template " + outFile + ": " + e, (Exception)e);
                }
            }
        }
    }

    public static String escapeYamlTemplate(String template) {
        StringBuffer answer = new StringBuffer();
        int count = 0;
        char last = '\u0000';
        int size = template.length();
        for (int i = 0; i < size; ++i) {
            char ch = template.charAt(i);
            if (ch == '{' || ch == '}') {
                if (count == 0) {
                    last = ch;
                    count = 1;
                    continue;
                }
                if (ch == last) {
                    answer.append(ch == '{' ? "{{\"{{\"}}" : "{{\"}}\"}}");
                } else {
                    answer.append(last);
                    answer.append(ch);
                }
                count = 0;
                last = '\u0000';
                continue;
            }
            if (count > 0) {
                answer.append(last);
            }
            answer.append(ch);
            count = 0;
            last = '\u0000';
        }
        if (count > 0) {
            answer.append(last);
        }
        return answer.toString();
    }

    private boolean containsYamlFiles(File sourceDir) {
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String lower = file.getName().toLowerCase();
                if (!lower.endsWith(YAML_EXTENSION) && !lower.endsWith(".yml")) continue;
                return true;
            }
        }
        return false;
    }

    private void copyTextFile(File outputDir, final String srcFile) throws MojoExecutionException {
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lower = name.toLowerCase(Locale.ENGLISH);
                    return lower.equals(srcFile.toLowerCase()) || lower.startsWith(srcFile.toLowerCase() + ".");
                }
            };
            this.copyFirstFile(this.project.getBasedir(), filter, outputDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save " + srcFile + ": " + e, (Exception)e);
        }
    }

    protected void copyFirstFile(File sourceDir, FilenameFilter filter, File outDir) throws IOException {
        File[] files = sourceDir.listFiles(filter);
        if (files != null && files.length > 0) {
            File sourceFile = files[0];
            Files.copy((File)sourceFile, (File)new File(outDir, sourceFile.getName()));
        }
        if (files != null && files.length > 1) {
            this.log.warn("Found %d of %s files. Using first one %s", new Object[]{files.length, files[0].getName(), files[0]});
        }
    }

    public static class HelmParameter {
        private final Parameter parameter;
        private final String helmName;

        public HelmParameter(Parameter parameter) {
            this.parameter = parameter;
            this.helmName = parameter.getName().toLowerCase();
        }

        public void addToValue(ObjectNode values) {
            String value = this.parameter.getValue();
            if (value != null) {
                values.put(this.helmName, value);
            }
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        public String getHelmName() {
            return this.helmName;
        }

        public String convertTemplateParameterToHelmExpression(String text) {
            Boolean flag;
            String name = this.parameter.getName();
            String from = "${" + name + "}";
            String answer = text;
            String defaultExpression = "";
            String required = "";
            String value = this.parameter.getValue();
            if (value != null) {
                defaultExpression = " | default \"" + value + "\"";
            }
            if ((flag = this.parameter.getRequired()) != null && flag.booleanValue()) {
                required = "required \"A valid .Values." + this.helmName + " entry required!\" ";
            }
            String to = "{{ " + required + ".Values." + this.helmName + defaultExpression + " }}";
            answer = Strings.replaceAllWithoutRegex((String)answer, (String)from, (String)to);
            from = "$" + name;
            return Strings.replaceAllWithoutRegex((String)answer, (String)from, (String)to);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Chart {
        @JsonProperty
        private String name;
        @JsonProperty
        private String home;
        @JsonProperty
        private List<String> sources;
        @JsonProperty
        private String version;
        @JsonProperty
        private String description;
        @JsonProperty
        private List<String> keywords;
        @JsonProperty
        private List<Maintainer> maintainers;
        @JsonProperty
        private String engine;
        @JsonProperty
        private String icon;

        public Chart() {
        }

        public Chart(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public Chart(String name, MavenProject project) {
            this(name, project, null, null);
        }

        public Chart(String name, MavenProject project, List<String> keywords, String engine) {
            this.name = name;
            this.keywords = keywords;
            this.engine = engine;
            this.name = name;
            if (project != null) {
                List developers;
                String url;
                this.version = project.getVersion();
                this.description = project.getDescription();
                this.home = project.getUrl();
                this.keywords = keywords;
                this.engine = engine;
                Scm scm = project.getScm();
                if (scm != null && (url = scm.getUrl()) != null) {
                    ArrayList<String> sources1 = new ArrayList<String>();
                    sources1.add(url);
                    this.sources = sources1;
                }
                if ((developers = project.getDevelopers()) != null) {
                    ArrayList<Maintainer> maintainers1 = new ArrayList<Maintainer>();
                    for (Developer developer : developers) {
                        String email = developer.getEmail();
                        String devName = developer.getName();
                        if (!Strings.isNotBlank((String)devName) && !Strings.isNotBlank((String)email)) continue;
                        Maintainer maintainer = new Maintainer(devName, email);
                        maintainers1.add(maintainer);
                    }
                    this.maintainers = maintainers1;
                }
            }
        }

        public String toString() {
            return "Chart{name='" + this.name + '\'' + ", home='" + this.home + '\'' + ", version='" + this.version + '\'' + '}';
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHome() {
            return this.home;
        }

        public void setHome(String home) {
            this.home = home;
        }

        public List<String> getSources() {
            return this.sources;
        }

        public void setSources(List<String> sources) {
            this.sources = sources;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getKeywords() {
            return this.keywords;
        }

        public void setKeywords(List<String> keywords) {
            this.keywords = keywords;
        }

        public List<Maintainer> getMaintainers() {
            return this.maintainers;
        }

        public void setMaintainers(List<Maintainer> maintainers) {
            this.maintainers = maintainers;
        }

        public String getEngine() {
            return this.engine;
        }

        public void setEngine(String engine) {
            this.engine = engine;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public static class Maintainer {
            @JsonProperty
            private String name;
            @JsonProperty
            private String email;

            public Maintainer() {
            }

            public Maintainer(String name, String email) {
                this.name = name;
                this.email = email;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getEmail() {
                return this.email;
            }

            public void setEmail(String email) {
                this.email = email;
            }
        }
    }
}

