/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo;

import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.Logger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public abstract class AbstractFabric8Mojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(property="fabric8.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="fabric8.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="fabric8.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    protected Logger log;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        this.log = this.createLogger(" ");
        this.executeInternal();
    }

    public abstract void executeInternal() throws MojoExecutionException, MojoFailureException;

    protected String getProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = this.project.getProperties().getProperty(key);
        }
        return value;
    }

    protected Logger createExternalProcessLogger(String prefix) {
        return this.createLogger(prefix + "[[s]]");
    }

    protected Logger createLogger(String prefix) {
        return new AnsiLogger(this.getLog(), this.useColor, this.verbose, this.settings.getInteractiveMode() == false, "F8:" + prefix);
    }
}

