/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.BuildRecreateMode;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.service.Fabric8ServiceHub;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.OpenShiftDependencyResources;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="build", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildMojo
extends io.fabric8.maven.docker.BuildMojo {
    @Parameter
    private ProcessorConfig generator;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ResourceConfig resources;
    @Parameter(property="fabric8.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.skip.build.pom")
    private Boolean skipBuildPom;
    @Parameter(property="fabric8.mode")
    private PlatformMode mode = PlatformMode.DEFAULT;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.s2i.buildNameSuffix", defaultValue="-s2i")
    private String s2iBuildNameSuffix;
    @Parameter(property="fabric8.build.pullSecret", defaultValue="pullsecret-fabric8")
    private String openshiftPullSecret;
    @Parameter(property="fabric8.s2i.imageStreamLookupPolicyLocal", defaultValue="true")
    private boolean s2iImageStreamLookupPolicyLocal = true;
    @Parameter(property="fabric8.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="fabric8.build.recreate", defaultValue="none")
    private String buildRecreate;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    protected RepositorySystem repositorySystem;
    private ClusterAccess clusterAccess;
    Fabric8ServiceHub fabric8ServiceHub;
    private PlatformMode platformMode;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipBuild) {
            return;
        }
        this.clusterAccess = new ClusterAccess(this.namespace);
        super.execute();
    }

    protected boolean isDockerAccessRequired() {
        return this.platformMode == PlatformMode.kubernetes;
    }

    protected void executeInternal(ServiceHub hub) throws MojoExecutionException {
        try {
            if (this.shouldSkipBecauseOfPomPackaging()) {
                this.getLog().info((CharSequence)"Disabling docker build for pom packaging");
                return;
            }
            if (this.getResolvedImages().size() == 0) {
                this.log.warn("No image build configuration found or detected", new Object[0]);
            }
            this.fabric8ServiceHub = new Fabric8ServiceHub.Builder().log(this.log).clusterAccess(this.clusterAccess).platformMode(this.mode).dockerServiceHub(hub).buildServiceConfig(this.getBuildServiceConfig()).repositorySystem(this.repositorySystem).mavenProject(this.project).build();
            super.executeInternal(hub);
            this.fabric8ServiceHub.getBuildService().postProcess(this.getBuildServiceConfig());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private boolean shouldSkipBecauseOfPomPackaging() {
        if (!Objects.equals("pom", this.project.getPackaging())) {
            return false;
        }
        if (this.skipBuildPom != null) {
            return this.skipBuildPom;
        }
        for (ImageConfiguration image : this.getResolvedImages()) {
            if (image.getBuildConfiguration() == null) continue;
            return false;
        }
        return true;
    }

    protected void buildAndTag(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, DockerAccessException {
        try {
            EnvUtil.storeTimestamp((File)this.getBuildTimestampFile(), (Date)this.getBuildTimestamp());
            this.fabric8ServiceHub.getBuildService().build(imageConfig);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to execute the build", ex);
        }
    }

    protected BuildService.BuildServiceConfig getBuildServiceConfig() throws MojoExecutionException {
        return new BuildService.BuildServiceConfig.Builder().dockerBuildContext(this.getBuildContext()).dockerMojoParameters(this.createMojoParameters()).buildRecreateMode(BuildRecreateMode.fromParameter((String)this.buildRecreate)).openshiftBuildStrategy(this.buildStrategy).openshiftPullSecret(this.openshiftPullSecret).s2iBuildNameSuffix(this.s2iBuildNameSuffix).s2iImageStreamLookupPolicyLocal(this.s2iImageStreamLookupPolicyLocal).imagePullManager(this.getImagePullManager(this.imagePullPolicy, this.autoPull)).buildDirectory(this.project.getBuild().getDirectory()).attacher((classifier, destFile) -> {
            if (destFile.exists()) {
                this.projectHelper.attachArtifact(this.project, "yml", classifier, destFile);
            }
        }).enricherTask(builder -> new EnricherManager(this.resources, this.getEnricherContext(), MavenUtil.getCompileClasspathElementsIfRequested((MavenProject)this.project, (boolean)this.useProjectClasspath)).enrich((KubernetesListBuilder)builder)).build();
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        Properties properties;
        this.platformMode = this.clusterAccess.resolvePlatformMode(this.mode, this.log);
        if (this.platformMode == PlatformMode.openshift) {
            this.log.info("Using [[B]]OpenShift[[B]] build with strategy [[B]]%s[[B]]", new Object[]{this.buildStrategy.getLabel()});
        } else {
            this.log.info("Building Docker image in [[B]]Kubernetes[[B]] mode", new Object[0]);
        }
        if (this.platformMode.equals((Object)PlatformMode.openshift) && !(properties = this.project.getProperties()).contains("fabric8.internal.effective.platform.mode")) {
            properties.setProperty("fabric8.internal.effective.platform.mode", this.platformMode.toString());
        }
        try {
            return GeneratorManager.generate(configs, this.getGeneratorContext(), false);
        }
        catch (MojoExecutionException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + (Object)((Object)e), e);
        }
    }

    protected String getLogPrefix() {
        return "F8: ";
    }

    private GeneratorContext getGeneratorContext() {
        return new GeneratorContext.Builder().config(this.extractGeneratorConfig()).project(this.project).logger(this.log).platformMode(this.platformMode).strategy(this.buildStrategy).useProjectClasspath(this.useProjectClasspath).artifactResolver(this.getFabric8ServiceHub().getArtifactResolverService()).build();
    }

    private Fabric8ServiceHub getFabric8ServiceHub() {
        return new Fabric8ServiceHub.Builder().log(this.log).clusterAccess(this.clusterAccess).platformMode(this.mode).repositorySystem(this.repositorySystem).mavenProject(this.project).build();
    }

    private ProcessorConfig extractGeneratorConfig() {
        try {
            return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.resourceDir, (ProcessorConfig)this.generator);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + e, e);
        }
    }

    public EnricherContext getEnricherContext() {
        return new MavenEnricherContext.Builder().project(this.project).session(this.session).config(this.extractEnricherConfig()).images(this.getResolvedImages()).resources(this.resources).log(this.log).openshiftDependencyResources(new OpenShiftDependencyResources(this.log)).build();
    }

    private ProcessorConfig extractEnricherConfig() {
        try {
            return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.resourceDir, (ProcessorConfig)this.enricher);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract enricher config: " + e, e);
        }
    }
}

