/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.ConfigMapEntry;
import io.fabric8.maven.core.config.MappingConfig;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.Profile;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.SecretConfig;
import io.fabric8.maven.core.config.ServiceConfig;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.model.GroupArtifactVersion;
import io.fabric8.maven.core.service.ComposeService;
import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.core.util.Base64Util;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.OpenShiftDependencyResources;
import io.fabric8.maven.core.util.OpenShiftOverrideResources;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.core.util.ResourceUtil;
import io.fabric8.maven.core.util.ResourceVersioning;
import io.fabric8.maven.core.util.SecretConstants;
import io.fabric8.maven.core.util.ValidationUtil;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.core.util.validator.ResourceValidator;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.api.util.InitContainerHandler;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.plugin.converter.DeploymentConfigOpenShiftConverter;
import io.fabric8.maven.plugin.converter.DeploymentOpenShiftConverter;
import io.fabric8.maven.plugin.converter.KubernetesToOpenShiftConverter;
import io.fabric8.maven.plugin.converter.NamespaceOpenShiftConverter;
import io.fabric8.maven.plugin.converter.ReplicSetOpenShiftConverter;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="resource", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractFabric8Mojo {
    private static final String DOCKER_MAVEN_PLUGIN_KEY = "io.fabric8:docker-maven-plugin";
    private static final String DOCKER_IMAGE_USER = "docker.image.user";
    @Parameter(property="fabric8.targetDir", defaultValue="${project.build.outputDirectory}/META-INF/fabric8")
    protected File targetDir;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.resourceDirOpenShiftOverride", defaultValue="${basedir}/src/main/fabric8-openshift-override")
    private File resourceDirOpenShiftOverride;
    @Parameter(property="fabric8.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="fabric8.workDir", defaultValue="${project.build.directory}/fabric8")
    private File workDir;
    @Parameter(property="fabric8.workDirOpenShiftOverride", defaultValue="${project.build.directory}/fabric8-openshift-override")
    private File workDirOpenShiftOverride;
    @Parameter(property="compose.resourceDir", defaultValue="${basedir}/src/main/fabric8-compose")
    private File composeResourceDir;
    @Parameter
    private String composeFile;
    @Parameter
    private ResourceConfig resources;
    @Parameter(property="fabric8.skipResourceValidation", defaultValue="false")
    private Boolean skipResourceValidation;
    @Parameter(property="fabric8.failOnValidationError", defaultValue="false")
    private Boolean failOnValidationError;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter(property="fabric8.mode")
    private PlatformMode mode = PlatformMode.DEFAULT;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.build.switchToDeployment", defaultValue="false")
    private Boolean switchToDeployment;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ProcessorConfig generator;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    @Parameter
    private List<MappingConfig> mappings;
    private HandlerHub handlerHub;
    private Map<String, KubernetesToOpenShiftConverter> openShiftConverters;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.openshift.deployTimeoutSeconds", defaultValue="3600")
    private Long openshiftDeployTimeoutSeconds;
    @Parameter(property="fabric8.openshift.trimImageInContainerSpec", defaultValue="false")
    private Boolean trimImageInContainerSpec;
    @Parameter(property="fabric8.openshift.generateRoute", defaultValue="true")
    private Boolean generateRoute;
    @Parameter(property="fabric8.openshift.enableAutomaticTrigger", defaultValue="true")
    private Boolean enableAutomaticTrigger;
    @Parameter(property="kompose.dir", defaultValue="${user.home}/.kompose/bin")
    private File komposeBinDir;
    private ClusterAccess clusterAccess;
    private PlatformMode platformMode;
    private OpenShiftDependencyResources openshiftDependencyResources;
    private OpenShiftOverrideResources openShiftOverrideResources;
    @Parameter(property="fabric8.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @Component
    private MavenProjectHelper projectHelper;

    protected static Template getSingletonTemplate(KubernetesList resources) {
        HasMetadata singleEntity;
        List items;
        if (resources != null && (items = resources.getItems()) != null && items.size() == 1 && (singleEntity = (HasMetadata)items.get(0)) instanceof Template) {
            return (Template)singleEntity;
        }
        return null;
    }

    public static File writeResourcesIndividualAndComposite(KubernetesList resources, File resourceFileBase, ResourceFileType resourceFileType, Logger log, Boolean generateRoute) throws MojoExecutionException {
        ArrayList<HasMetadata> newItemList = new ArrayList<HasMetadata>();
        if (!generateRoute.booleanValue()) {
            for (HasMetadata item : resources.getItems()) {
                if (item.getKind().equalsIgnoreCase("Route")) continue;
                newItemList.add(item);
            }
            resources.setItems(newItemList);
        }
        KubernetesList entity = resources;
        Template template = ResourceMojo.getSingletonTemplate(resources);
        if (template != null) {
            entity = template;
        }
        File file = ResourceMojo.writeResource(resourceFileBase, entity, resourceFileType);
        ResourceMojo.writeIndividualResources(resources, resourceFileBase, resourceFileType, log, generateRoute);
        return file;
    }

    private static void writeIndividualResources(KubernetesList resources, File targetDir, ResourceFileType resourceFileType, Logger log, Boolean generateRoute) throws MojoExecutionException {
        for (HasMetadata item : resources.getItems()) {
            String name = KubernetesHelper.getName((HasMetadata)item);
            if (StringUtils.isBlank((CharSequence)name)) {
                log.error("No name for generated item %s", new Object[]{item});
                continue;
            }
            String itemFile = KubernetesResourceUtil.getNameWithSuffix((String)name, (String)item.getKind());
            if (item.getKind().equalsIgnoreCase("Route") && !generateRoute.booleanValue()) continue;
            File itemTarget = new File(targetDir, itemFile);
            ResourceMojo.writeResource(itemTarget, item, resourceFileType);
        }
    }

    private static File writeResource(File resourceFileBase, Object entity, ResourceFileType resourceFileType) throws MojoExecutionException {
        try {
            return ResourceUtil.save((File)resourceFileBase, (Object)entity, (ResourceFileType)resourceFileType);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write resource to " + resourceFileBase + ". " + e, (Exception)e);
        }
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        this.clusterAccess = new ClusterAccess(this.namespace);
        this.updateKindFilenameMappings();
        try {
            this.lateInit();
            this.resolvedImages = this.getResolvedImages(this.images, this.log);
            if (!(this.skip || this.isPomProject() && !this.hasFabric8Dir())) {
                KubernetesList resources = this.generateResources(this.resolvedImages);
                KubernetesList openShiftResources = this.convertToOpenShiftResources(resources);
                this.writeResources(openShiftResources, ResourceClassifier.OPENSHIFT, this.generateRoute);
                File openShiftResourceDir = new File(this.targetDir, ResourceClassifier.OPENSHIFT.getValue());
                this.validateIfRequired(openShiftResourceDir, ResourceClassifier.OPENSHIFT);
                KubernetesList kubernetesResources = this.convertToKubernetesResources(resources, openShiftResources);
                this.writeResources(kubernetesResources, ResourceClassifier.KUBERNETES, this.generateRoute);
                File kubernetesResourceDir = new File(this.targetDir, ResourceClassifier.KUBERNETES.getValue());
                this.validateIfRequired(kubernetesResourceDir, ResourceClassifier.KUBERNETES);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate fabric8 descriptor", (Exception)e);
        }
    }

    private void updateKindFilenameMappings() {
        if (this.mappings != null) {
            HashMap<String, List<String>> mappingKindFilename = new HashMap<String, List<String>>();
            for (MappingConfig mappingConfig : this.mappings) {
                if (mappingConfig.isValid()) {
                    mappingKindFilename.put(mappingConfig.getKind(), Arrays.asList(mappingConfig.getFilenamesAsArray()));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Invalid mapping for Kind %s and Filename Types %s", mappingConfig.getKind(), mappingConfig.getFilenameTypes()));
            }
            KubernetesResourceUtil.updateKindFilenameMapper(mappingKindFilename);
        }
    }

    private void validateIfRequired(File resourceDir, ResourceClassifier classifier) throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.skipResourceValidation.booleanValue()) {
                new ResourceValidator(resourceDir, classifier, this.log).validate();
            }
        }
        catch (ConstraintViolationException e) {
            if (this.failOnValidationError.booleanValue()) {
                this.log.error("[[R]]" + e.getMessage() + "[[R]]", new Object[0]);
                this.log.error("[[R]]use \"mvn -Dfabric8.skipResourceValidation=true\" option to skip the validation[[R]]", new Object[0]);
                throw new MojoFailureException("Failed to generate fabric8 descriptor");
            }
            this.log.warn("[[Y]]" + e.getMessage() + "[[Y]]", new Object[0]);
        }
        catch (Throwable e) {
            if (this.failOnValidationError.booleanValue()) {
                throw new MojoExecutionException("Failed to validate resources", e);
            }
            this.log.warn("Failed to validate resources: %s", new Object[]{e.getMessage()});
        }
    }

    private void lateInit() {
        this.platformMode = this.clusterAccess.resolvePlatformMode(this.mode, this.log);
        this.log.info("Running in [[B]]%s[[B]] mode", new Object[]{this.platformMode.getLabel()});
        if (this.isOpenShiftMode()) {
            Properties properties = this.project.getProperties();
            if (!properties.contains(DOCKER_IMAGE_USER)) {
                String namespace = this.clusterAccess.getNamespace();
                this.log.info("Using docker image name of namespace: " + namespace, new Object[0]);
                properties.setProperty(DOCKER_IMAGE_USER, namespace);
            }
            if (!properties.contains("fabric8.internal.effective.platform.mode")) {
                properties.setProperty("fabric8.internal.effective.platform.mode", this.platformMode.toString());
            }
        }
        this.openShiftConverters = new HashMap<String, KubernetesToOpenShiftConverter>();
        this.openShiftConverters.put("ReplicaSet", new ReplicSetOpenShiftConverter());
        this.openShiftConverters.put("Deployment", new DeploymentOpenShiftConverter(this.platformMode, this.getOpenshiftDeployTimeoutSeconds()));
        this.openShiftConverters.put("DeploymentConfig", new DeploymentConfigOpenShiftConverter(this.getOpenshiftDeployTimeoutSeconds()));
        this.openShiftConverters.put("Namespace", new NamespaceOpenShiftConverter());
        this.handlerHub = new HandlerHub(new GroupArtifactVersion(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()), this.project.getProperties());
    }

    private boolean isOpenShiftMode() {
        return this.platformMode.equals((Object)PlatformMode.openshift);
    }

    private KubernetesList convertToKubernetesResources(KubernetesList resources, KubernetesList openShiftResources) throws MojoExecutionException {
        KubernetesList kubernetesResources = this.removeOpenShiftObjects(resources);
        KubernetesList kubernetesList = this.processOpenshiftTemplateIfProvided(openShiftResources, kubernetesResources);
        return kubernetesList;
    }

    private KubernetesList processOpenshiftTemplateIfProvided(KubernetesList openShiftResources, KubernetesList kubernetesResources) throws MojoExecutionException {
        Template template = ResourceMojo.getSingletonTemplate(openShiftResources);
        if (template != null) {
            KubernetesList kubernetesTemplateList = this.createKubernetesTemplate(kubernetesResources, template);
            if (kubernetesTemplateList != null) {
                this.writeResources(kubernetesTemplateList, ResourceClassifier.KUBERNETES_TEMPLATE, this.generateRoute);
            }
            kubernetesResources = this.replaceTemplateExpressions(kubernetesResources, template);
        }
        return kubernetesResources;
    }

    private KubernetesList createKubernetesTemplate(KubernetesList kubernetesResources, Template template) {
        Template customTemplate = ResourceMojo.createTemplateWithObjects(kubernetesResources, template);
        if (customTemplate != null) {
            return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new HasMetadata[]{customTemplate})).build();
        }
        return null;
    }

    private KubernetesList replaceTemplateExpressions(KubernetesList kubernetesResources, Template template) throws MojoExecutionException {
        Template customTemplate = ResourceMojo.createTemplateWithObjects(kubernetesResources, template);
        if (customTemplate != null) {
            try {
                return OpenshiftHelper.processTemplatesLocally((Template)customTemplate, (boolean)false);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to replace template expressions in kubernetes manifest: " + e, (Exception)e);
            }
        }
        return kubernetesResources;
    }

    private static Template createTemplateWithObjects(KubernetesList kubernetesResources, Template template) {
        List parameters = template.getParameters();
        List items = kubernetesResources.getItems();
        Template tempTemplate = null;
        if (parameters != null && parameters.size() > 0 && items != null && items.size() > 0) {
            tempTemplate = new Template();
            tempTemplate.setMetadata(template.getMetadata());
            tempTemplate.setParameters(parameters);
            tempTemplate.setObjects(items);
        }
        return tempTemplate;
    }

    public Long getOpenshiftDeployTimeoutSeconds() {
        return this.openshiftDeployTimeoutSeconds;
    }

    public void setOpenshiftDeployTimeoutSeconds(Long openshiftDeployTimeoutSeconds) {
        this.openshiftDeployTimeoutSeconds = openshiftDeployTimeoutSeconds;
    }

    private KubernetesList removeOpenShiftObjects(KubernetesList list) {
        KubernetesListBuilder ret = new KubernetesListBuilder();
        ret.withMetadata(list.getMetadata());
        for (HasMetadata item : list.getItems()) {
            if (!this.isOpenshiftItem(item)) {
                ret.addToItems(new HasMetadata[]{item});
                continue;
            }
            this.log.verbose("kubernetes.yml: Removed OpenShift specific resource '%s' of type %s", new Object[]{KubernetesHelper.getName((HasMetadata)item), KubernetesHelper.getKind((HasMetadata)item)});
        }
        return ret.build();
    }

    private boolean isOpenshiftItem(HasMetadata item) {
        if (this.isTargetPlatformOpenShift(item)) {
            return true;
        }
        return item.getClass().getPackage().getName().contains("openshift");
    }

    private boolean isTargetPlatformOpenShift(HasMetadata item) {
        String targetPlatform = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)item).get(Fabric8Annotations.TARGET_PLATFORM.value());
        return targetPlatform != null && "openshift".equalsIgnoreCase(targetPlatform);
    }

    private boolean isTargetPlatformKubernetes(HasMetadata item) {
        String targetPlatform = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)item).get(Fabric8Annotations.TARGET_PLATFORM.value());
        return targetPlatform != null && "kubernetes".equalsIgnoreCase(targetPlatform);
    }

    private KubernetesList generateResources(List<ImageConfiguration> images) throws IOException, MojoExecutionException {
        this.openshiftDependencyResources = new OpenShiftDependencyResources(this.log);
        this.loadOpenShiftOverrideResources();
        MavenEnricherContext.Builder ctxBuilder = new MavenEnricherContext.Builder().project(this.project).session(this.session).config(this.extractEnricherConfig()).resources(this.resources).images(this.resolvedImages).log(this.log).openshiftDependencyResources(this.openshiftDependencyResources);
        EnricherManager enricherManager = new EnricherManager(this.resources, (EnricherContext)ctxBuilder.build(), MavenUtil.getCompileClasspathElementsIfRequested((MavenProject)this.project, (boolean)this.useProjectClasspath));
        KubernetesListBuilder builder = this.generateAppResources(images, enricherManager);
        this.addProfiledResourcesFromSubirectories(builder, this.resourceDir, enricherManager);
        return builder.build();
    }

    private void loadOpenShiftOverrideResources() throws MojoExecutionException, IOException {
        File[] resourceFiles;
        this.openShiftOverrideResources = new OpenShiftOverrideResources(this.log);
        if (this.resourceDirOpenShiftOverride.isDirectory() && this.resourceDirOpenShiftOverride.exists() && (resourceFiles = KubernetesResourceUtil.listResourceFragments((File)this.resourceDirOpenShiftOverride)).length > 0) {
            String defaultName = MavenUtil.createDefaultResourceName((String)this.project.getGroupId(), (String[])new String[]{this.project.getArtifactId()});
            KubernetesListBuilder builder = KubernetesResourceUtil.readResourceFragmentsFrom((ResourceVersioning)KubernetesResourceUtil.DEFAULT_RESOURCE_VERSIONING, (String)defaultName, (File[])this.mavenFilterFiles(resourceFiles, this.workDirOpenShiftOverride));
            KubernetesList list = builder.build();
            for (HasMetadata item : list.getItems()) {
                this.openShiftOverrideResources.addOpenShiftOverride(item);
            }
        }
    }

    private void addProfiledResourcesFromSubirectories(KubernetesListBuilder builder, File resourceDir, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        File[] profileDirs = resourceDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (profileDirs != null) {
            for (File profileDir : profileDirs) {
                Profile profile = ProfileUtil.findProfile((String)profileDir.getName(), (File)resourceDir);
                if (profile == null) {
                    throw new MojoExecutionException(String.format("Invalid profile '%s' given as directory in %s. Please either define a profile of this name or move this directory away", profileDir.getName(), resourceDir));
                }
                ProcessorConfig enricherConfig = profile.getEnricherConfig();
                File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)profileDir);
                if (resourceFiles.length <= 0) continue;
                KubernetesListBuilder profileBuilder = this.readResourceFragments(resourceFiles);
                enricherManager.createDefaultResources(enricherConfig, profileBuilder);
                enricherManager.enrich(enricherConfig, profileBuilder);
                KubernetesList profileItems = profileBuilder.build();
                for (HasMetadata item : profileItems.getItems()) {
                    builder.addToItems(new HasMetadata[]{item});
                }
            }
        }
    }

    private KubernetesListBuilder generateAppResources(List<ImageConfiguration> images, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        Path composeFilePath = this.checkComposeConfig();
        ComposeService composeUtil = new ComposeService(this.komposeBinDir, composeFilePath, this.log);
        try {
            KubernetesListBuilder builder;
            Object[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)this.resourceDir);
            Object[] composeResourceFiles = composeUtil.convertToKubeFragments();
            File[] allResources = (File[])ArrayUtils.addAll((Object[])resourceFiles, (Object[])composeResourceFiles);
            if (allResources != null && allResources.length > 0) {
                if (resourceFiles != null && resourceFiles.length > 0) {
                    this.log.info("using resource templates from %s", new Object[]{this.resourceDir});
                }
                if (composeResourceFiles != null && composeResourceFiles.length > 0) {
                    this.log.info("using resource templates generated from compose file", new Object[0]);
                }
                builder = this.readResourceFragments(allResources);
            } else {
                builder = new KubernetesListBuilder();
            }
            if (this.resources != null) {
                this.addConfiguredResources(builder, images);
            }
            enricherManager.createDefaultResources(builder);
            enricherManager.enrich(builder);
            KubernetesListBuilder kubernetesListBuilder = builder;
            return kubernetesListBuilder;
        }
        catch (ConstraintViolationException e) {
            String message = ValidationUtil.createValidationMessage((Set)e.getConstraintViolations());
            this.log.error("ConstraintViolationException: %s", new Object[]{message});
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
        catch (Fabric8ServiceException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            composeUtil.cleanComposeResources();
        }
    }

    private Path checkComposeConfig() {
        return this.composeConfigPresent() ? this.buildComposeFilePath() : this.lookDefaultComposeConfig();
    }

    private boolean composeConfigPresent() {
        return this.composeFile != null && this.composeFile.trim().length() > 0;
    }

    private Path buildComposeFilePath() {
        return Paths.get(this.project.getBasedir() + "/" + this.composeFile, new String[0]);
    }

    private Path lookDefaultComposeConfig() {
        File[] composeFiles = this.listDefaultComposeFile();
        return this.defaultComposeFilePresent(composeFiles) ? this.getFirstComposeFile(composeFiles) : null;
    }

    private File[] listDefaultComposeFile() {
        File[] composeFiles = null;
        if (this.composeResourceDir != null && this.composeResourceDir.exists()) {
            composeFiles = this.composeResourceDir.listFiles();
        }
        return composeFiles;
    }

    private boolean defaultComposeFilePresent(File[] composeFiles) {
        return composeFiles != null && composeFiles.length > 0;
    }

    private Path getFirstComposeFile(File[] composeFile) {
        return composeFile[0].toPath();
    }

    private KubernetesListBuilder readResourceFragments(File[] resourceFiles) throws IOException, MojoExecutionException {
        String defaultName = MavenUtil.createDefaultResourceName((String)this.project.getArtifactId(), (String[])new String[0]);
        KubernetesListBuilder builder = KubernetesResourceUtil.readResourceFragmentsFrom((ResourceVersioning)KubernetesResourceUtil.DEFAULT_RESOURCE_VERSIONING, (String)defaultName, (File[])this.mavenFilterFiles(resourceFiles, this.workDir));
        return builder;
    }

    private ProcessorConfig extractEnricherConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.resourceDir, (ProcessorConfig)this.enricher);
    }

    private ProcessorConfig extractGeneratorConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.resourceDir, (ProcessorConfig)this.generator);
    }

    private KubernetesList convertToOpenShiftResources(KubernetesList resources) throws MojoExecutionException {
        KubernetesListBuilder builder = new KubernetesListBuilder();
        builder.withMetadata(resources.getMetadata());
        List items = resources.getItems();
        ArrayList<HasMetadata> objects = new ArrayList<HasMetadata>();
        if (items != null) {
            this.switchToDeployment = this.switchToDeployment != false && this.isImageStreamNotUsed();
            for (HasMetadata item : items) {
                String name;
                if (item instanceof Deployment && this.hasDeploymentConfigNamed(items, name = KubernetesHelper.getName((HasMetadata)item))) continue;
                item = this.openShiftOverrideResources.overrideResource(item);
                if (this.switchToDeployment.booleanValue() && item instanceof Deployment) {
                    objects.add(item);
                    this.log.info("filtering out this item, use Kubernetes Deployment instead.", new Object[0]);
                    continue;
                }
                HasMetadata converted = this.convertKubernetesItemToOpenShift(item);
                if (converted == null || this.isTargetPlatformKubernetes(item)) continue;
                objects.add(converted);
            }
        }
        this.openshiftDependencyResources.addMissingResources(objects);
        this.moveTemplatesToTopLevel(builder, objects);
        this.removeInitContainers(builder, "fmp-volume-permission");
        return builder.build();
    }

    private boolean isImageStreamNotUsed() {
        return !PlatformMode.isOpenShiftMode((Properties)this.project.getProperties());
    }

    private void removeInitContainers(KubernetesListBuilder builder, final String enricherName) {
        builder.accept((Visitor)new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder builder) {
                InitContainerHandler initContainerHandler = new InitContainerHandler(ResourceMojo.this.log);
                if (initContainerHandler.hasInitContainer(builder, enricherName)) {
                    ResourceMojo.this.log.verbose("Removing init container from openshift.yml for %s", new Object[]{enricherName});
                    initContainerHandler.removeInitContainer(builder, enricherName);
                }
            }
        });
    }

    private void moveTemplatesToTopLevel(KubernetesListBuilder builder, List<HasMetadata> objects) {
        Template template = this.extractAndRemoveTemplates(objects);
        if (template != null) {
            this.openshiftDependencyResources.addMissingParameters(template);
            builder.addToItems(new HasMetadata[]{template});
        } else {
            for (HasMetadata object : objects) {
                builder.addToItems(new HasMetadata[]{object});
            }
        }
    }

    private Template extractAndRemoveTemplates(List<HasMetadata> items) {
        Template extractedTemplate = null;
        for (HasMetadata item : new ArrayList<HasMetadata>(items)) {
            if (!(item instanceof Template) || KubernetesResourceUtil.isAppCatalogResource((HasMetadata)item)) continue;
            Template template = (Template)item;
            extractedTemplate = extractedTemplate == null ? template : OpenshiftHelper.combineTemplates((Template)extractedTemplate, (Template)template);
            items.remove(item);
        }
        if (extractedTemplate != null) {
            extractedTemplate.setObjects(items);
        }
        return extractedTemplate;
    }

    private boolean hasDeploymentConfigNamed(List<HasMetadata> items, String name) {
        for (HasMetadata item : items) {
            String dcName;
            if (!(item instanceof DeploymentConfig) || !Objects.equals(name, dcName = KubernetesHelper.getName((HasMetadata)item))) continue;
            return true;
        }
        return false;
    }

    private HasMetadata convertKubernetesItemToOpenShift(HasMetadata item) {
        HasMetadata dependencyResource;
        if (item instanceof ConfigMap && "true".equals(this.getAnnotations(item).get("maven.fabric8.io/app-catalog"))) {
            return null;
        }
        if (!this.isOpenshiftItem(item) && (dependencyResource = this.openshiftDependencyResources.convertKubernetesItemToOpenShift(item)) != null) {
            return dependencyResource;
        }
        KubernetesToOpenShiftConverter converter = this.openShiftConverters.get(item.getKind());
        return converter != null ? converter.convert(item, this.trimImageInContainerSpec, this.enableAutomaticTrigger) : item;
    }

    private Map<String, String> getAnnotations(HasMetadata item) {
        ObjectMeta meta = item.getMetadata();
        if (meta == null) {
            return Collections.EMPTY_MAP;
        }
        Map annos = meta.getAnnotations();
        if (annos == null) {
            return Collections.EMPTY_MAP;
        }
        return annos;
    }

    private List<ImageConfiguration> getResolvedImages(List<ImageConfiguration> images, final Logger log) throws MojoExecutionException {
        List ret = ConfigHelper.resolveImages((Logger)log, images, (ConfigHelper.Resolver)new ConfigHelper.Resolver(){

            public List<ImageConfiguration> resolve(ImageConfiguration image) {
                return ResourceMojo.this.imageConfigResolver.resolve(image, ResourceMojo.this.project, ResourceMojo.this.session);
            }
        }, null, (ConfigHelper.Customizer)new ConfigHelper.Customizer(){

            public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
                try {
                    GeneratorContext ctx = new GeneratorContext.Builder().config(ResourceMojo.this.extractGeneratorConfig()).project(ResourceMojo.this.project).logger(log).platformMode(ResourceMojo.this.mode).strategy(ResourceMojo.this.buildStrategy).useProjectClasspath(ResourceMojo.this.useProjectClasspath).build();
                    return GeneratorManager.generate(configs, ctx, true);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot extract generator: " + e, e);
                }
            }
        });
        Date now = this.getBuildReferenceDate();
        this.storeReferenceDateInPluginContext(now);
        String minimalApiVersion = ConfigHelper.initAndValidate((List)ret, null, (ConfigHelper.NameFormatter)new ImageNameFormatter(this.project, now), (Logger)log);
        return ret;
    }

    private void storeReferenceDateInPluginContext(Date now) {
        Map pluginContext = this.getPluginContext();
        pluginContext.put("CONTEXT_KEY_BUILD_TIMESTAMP", now);
    }

    private Date getBuildReferenceDate() throws MojoExecutionException {
        File tsFile = new File(this.project.getBuild().getDirectory(), "docker/build.timestamp");
        if (!tsFile.exists()) {
            return new Date();
        }
        try {
            return EnvUtil.loadTimestamp((File)tsFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read timestamp from " + tsFile, (Exception)e);
        }
    }

    private void addConfiguredResources(KubernetesListBuilder builder, List<ImageConfiguration> images) {
        this.log.verbose("Adding resources from plugin configuration", new Object[0]);
        this.addSecrets(builder);
        this.addServices(builder, this.resources.getServices());
        this.addController(builder, images);
        this.addConfigMapFromConfigurations(builder, this.resources.getConfigMap());
    }

    void addConfigMapFromConfigurations(KubernetesListBuilder builder, io.fabric8.maven.core.config.ConfigMap configMap) {
        try {
            Map<String, String> configMapFromConfiguration = this.createConfigMapFromConfiguration(configMap);
            if (!configMapFromConfiguration.isEmpty()) {
                ConfigMapBuilder element = new ConfigMapBuilder();
                ((ConfigMapFluent.MetadataNested)element.withNewMetadata().withName("xmlconfig")).endMetadata();
                element.addToData(configMapFromConfiguration);
                builder.addToConfigMapItems(new ConfigMap[]{element.build()});
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Map<String, String> createConfigMapFromConfiguration(io.fabric8.maven.core.config.ConfigMap configMap) throws IOException {
        HashMap<String, String> configMapData = new HashMap<String, String>();
        if (configMap != null) {
            for (ConfigMapEntry configMapEntry : configMap.getEntries()) {
                String name = configMapEntry.getName();
                String value = configMapEntry.getValue();
                if (name != null && value != null) {
                    configMapData.put(name, value);
                    continue;
                }
                String file = configMapEntry.getFile();
                if (file == null) continue;
                if (name == null) {
                    name = Paths.get(file, new String[0]).getFileName().toString();
                }
                configMapData.put(name, this.readContent(file));
            }
        }
        return configMapData;
    }

    private String readContent(String location) throws IOException {
        return new String(Files.readAllBytes(Paths.get(location, new String[0])));
    }

    private void addSecrets(KubernetesListBuilder builder) {
        this.log.verbose("Adding secrets resources from plugin configuration", new Object[0]);
        List secrets = this.resources.getSecrets();
        if (secrets == null || secrets.isEmpty()) {
            return;
        }
        for (int i = 0; i < secrets.size(); ++i) {
            SecretConfig secretConfig = (SecretConfig)secrets.get(i);
            if (StringUtils.isBlank((CharSequence)secretConfig.getName())) {
                this.log.warn("Secret name is empty. You should provide a proper name for the secret", new Object[0]);
                continue;
            }
            HashMap<String, String> data = new HashMap<String, String>();
            String type = "";
            ObjectMeta metadata = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withNamespace(secretConfig.getNamespace())).withName(secretConfig.getName())).build();
            if (secretConfig.getDockerServerId() != null) {
                String dockerSecret = this.getDockerJsonConfigString(this.settings, secretConfig.getDockerServerId());
                if (StringUtils.isBlank((CharSequence)dockerSecret)) {
                    this.log.warn("Docker secret with id " + secretConfig.getDockerServerId() + " cannot be found in maven settings", new Object[0]);
                    continue;
                }
                data.put(SecretConstants.DOCKER_DATA_KEY, Base64Util.encodeToString((String)dockerSecret));
                type = SecretConstants.DOCKER_CONFIG_TYPE;
            }
            if (StringUtils.isBlank((CharSequence)type) || data.isEmpty()) {
                this.log.warn("No data can be found for docker secret with id " + secretConfig.getDockerServerId(), new Object[0]);
                continue;
            }
            Secret secret = ((SecretBuilder)((SecretBuilder)((SecretBuilder)new SecretBuilder().withData(data)).withMetadata(metadata)).withType(type)).build();
            builder.addToSecretItems(i, secret);
        }
    }

    public String getDockerJsonConfigString(Settings settings, String serverId) {
        Server server = this.getServer(settings, serverId);
        if (server == null) {
            return "";
        }
        JsonObject auth = new JsonObject();
        auth.add("username", (JsonElement)new JsonPrimitive(server.getUsername()));
        auth.add("password", (JsonElement)new JsonPrimitive(server.getPassword()));
        String mail = this.getConfigurationValue(server, "email");
        if (!StringUtils.isBlank((CharSequence)mail)) {
            auth.add("email", (JsonElement)new JsonPrimitive(mail));
        }
        JsonObject json = new JsonObject();
        json.add(serverId, (JsonElement)auth);
        return json.toString();
    }

    public Server getServer(Settings settings, String serverId) {
        if (settings == null || StringUtils.isBlank((CharSequence)serverId)) {
            return null;
        }
        return settings.getServer(serverId);
    }

    private String getConfigurationValue(Server server, String key) {
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        if (configuration == null) {
            return null;
        }
        Xpp3Dom node = configuration.getChild(key);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    private void addController(KubernetesListBuilder builder, List<ImageConfiguration> images) {
        ReplicationControllerHandler rcHandler = this.handlerHub.getReplicationControllerHandler();
        if (this.resources.getControllerName() != null) {
            builder.addToReplicationControllerItems(new ReplicationController[]{rcHandler.getReplicationController(this.resources, images)});
        }
    }

    private File[] mavenFilterFiles(File[] resourceFiles, File outDir) throws MojoExecutionException {
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new MojoExecutionException("Cannot create working dir " + outDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(outDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new MojoExecutionException(String.format("Cannot filter %s to %s", resource, targetFile), (Exception)((Object)exp));
            }
        }
        return ret;
    }

    private void addServices(KubernetesListBuilder builder, List<ServiceConfig> serviceConfig) {
        if (serviceConfig != null) {
            ServiceHandler serviceHandler = this.handlerHub.getServiceHandler();
            builder.addToServiceItems(this.toArray(serviceHandler.getServices(serviceConfig)));
        }
    }

    private Service[] toArray(List<Service> services) {
        if (services == null) {
            return new Service[0];
        }
        if (services instanceof ArrayList) {
            return ((ArrayList)services).toArray(new Service[services.size()]);
        }
        Service[] ret = new Service[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            ret[i] = services.get(i);
        }
        return ret;
    }

    private boolean hasFabric8Dir() {
        return this.resourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }

    protected void writeResources(KubernetesList resources, ResourceClassifier classifier, Boolean generateRoute) throws MojoExecutionException {
        File resourceFileBase = new File(this.targetDir, classifier.getValue());
        File file = ResourceMojo.writeResourcesIndividualAndComposite(resources, resourceFileBase, this.resourceFileType, this.log, generateRoute);
        this.projectHelper.attachArtifact(this.project, this.resourceFileType.getArtifactType(), classifier.getValue(), file);
        if (this.resourceFileType.equals((Object)ResourceFileType.yaml)) {
            file = ResourceMojo.writeResource(resourceFileBase, resources, ResourceFileType.json);
            this.projectHelper.attachArtifact(this.project, ResourceFileType.json.getArtifactType(), classifier.getValue(), file);
        }
    }

    protected List<MappingConfig> getMappings() {
        return this.mappings;
    }
}

