/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.converter;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.maven.plugin.converter.KubernetesToOpenShiftConverter;
import java.util.Map;

public class ReplicSetOpenShiftConverter
implements KubernetesToOpenShiftConverter {
    @Override
    public HasMetadata convert(HasMetadata item, boolean trimImageInContainerSpec, boolean enableAutomaticTrigger) {
        ReplicaSet resource = (ReplicaSet)item;
        ReplicationControllerBuilder builder = new ReplicationControllerBuilder();
        builder.withMetadata(resource.getMetadata());
        ReplicaSetSpec spec = resource.getSpec();
        if (spec != null) {
            PodTemplateSpec template;
            Map matchLabels;
            LabelSelector selector;
            ReplicationControllerFluent.SpecNested specBuilder = builder.withNewSpec();
            Integer replicas = spec.getReplicas();
            if (replicas != null) {
                specBuilder.withReplicas(replicas);
            }
            if ((selector = spec.getSelector()) != null && (matchLabels = selector.getMatchLabels()) != null && !matchLabels.isEmpty()) {
                specBuilder.withSelector(matchLabels);
            }
            if ((template = spec.getTemplate()) != null) {
                specBuilder.withTemplate(template);
            }
            specBuilder.endSpec();
        }
        return builder.build();
    }
}

