/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.maven.plugin.mojo.ResourceDirCreator;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="push", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PushMojo
extends io.fabric8.maven.docker.PushMojo {
    @Parameter
    private ProcessorConfig generator;
    @Parameter(property="fabric8.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.environment")
    private String environment;
    @Parameter(property="fabric8.mode")
    private RuntimeMode mode = RuntimeMode.auto;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="docker.skip.push", defaultValue="false")
    protected boolean skipPush;

    protected String getLogPrefix() {
        return "F8> ";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipPush) {
            return;
        }
        super.execute();
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        try {
            ProcessorConfig generatorConfig = ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)ResourceDirCreator.getFinalResourceDir(this.resourceDir, this.environment), (ProcessorConfig)this.generator);
            GeneratorContext ctx = new GeneratorContext.Builder().config(generatorConfig).project(this.project).logger(this.log).runtimeMode(this.mode).strategy(this.buildStrategy).useProjectClasspath(false).build();
            return GeneratorManager.generate(configs, ctx, true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + e, e);
        }
    }
}

