/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.access.ClusterConfiguration;
import io.fabric8.maven.core.config.MappingConfig;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.Profile;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.util.FileUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.core.util.ResourceUtil;
import io.fabric8.maven.core.util.ResourceVersioning;
import io.fabric8.maven.core.util.ValidationUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.core.util.validator.ResourceValidator;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.maven.plugin.mojo.ResourceDirCreator;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;

@Mojo(name="resource", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractFabric8Mojo {
    private static final String DOCKER_MAVEN_PLUGIN_KEY = "io.fabric8:docker-maven-plugin";
    private static final String DOCKER_IMAGE_USER = "docker.image.user";
    @Parameter(property="fabric8.targetDir", defaultValue="${project.build.outputDirectory}/META-INF/fabric8")
    protected File targetDir;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.resourceDirOpenShiftOverride", defaultValue="${basedir}/src/main/fabric8-openshift-override")
    private File resourceDirOpenShiftOverride;
    @Parameter(property="fabric8.environment")
    private String environment;
    @Parameter(property="fabric8.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="fabric8.workDir", defaultValue="${project.build.directory}/fabric8")
    private File workDir;
    @Parameter(property="fabric8.workDirOpenShiftOverride", defaultValue="${project.build.directory}/fabric8-openshift-override")
    private File workDirOpenShiftOverride;
    @Parameter
    private ResourceConfig resources;
    @Parameter(property="fabric8.mode")
    private RuntimeMode runtimeMode = RuntimeMode.DEFAULT;
    @Parameter(property="fabric8.skipResourceValidation", defaultValue="false")
    private Boolean skipResourceValidation;
    @Parameter(property="fabric8.failOnValidationError", defaultValue="false")
    private Boolean failOnValidationError;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.build.switchToDeployment", defaultValue="false")
    private Boolean switchToDeployment;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter(property="fabric8.gitRemote")
    private String gitRemote;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ProcessorConfig generator;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    @Parameter
    private List<MappingConfig> mappings;
    private HandlerHub handlerHub;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.skipHealthCheck", defaultValue="false")
    private Boolean skipHealthCheck;
    @Parameter(property="fabric8.openshift.deployTimeoutSeconds", defaultValue="3600")
    private Long openshiftDeployTimeoutSeconds;
    @Parameter(property="fabric8.openshift.trimImageInContainerSpec", defaultValue="false")
    private Boolean trimImageInContainerSpec;
    @Parameter(property="fabric8.openshift.generateRoute", defaultValue="true")
    private Boolean generateRoute;
    @Parameter(property="fabric8.openshift.enableAutomaticTrigger", defaultValue="true")
    private Boolean enableAutomaticTrigger;
    @Parameter(property="fabric8.openshift.imageChangeTrigger", defaultValue="true")
    private Boolean enableImageChangeTrigger;
    @Parameter(property="docker.skip.resource", defaultValue="false")
    protected boolean skipResource;
    @Parameter(property="fabric8.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @Component
    private MavenProjectHelper projectHelper;
    private File realResourceDir;
    private File realResourceDirOpenShiftOverride;

    protected static Template getSingletonTemplate(KubernetesList resources) {
        HasMetadata singleEntity;
        List items;
        if (resources != null && (items = resources.getItems()) != null && items.size() == 1 && (singleEntity = (HasMetadata)items.get(0)) instanceof Template) {
            return (Template)singleEntity;
        }
        return null;
    }

    public static File writeResourcesIndividualAndComposite(KubernetesList resources, File resourceFileBase, ResourceFileType resourceFileType, Logger log, Boolean generateRoute) throws MojoExecutionException {
        ArrayList<HasMetadata> newItemList = new ArrayList<HasMetadata>();
        if (!generateRoute.booleanValue()) {
            for (HasMetadata item : resources.getItems()) {
                if (item.getKind().equalsIgnoreCase("Route")) continue;
                newItemList.add(item);
            }
            resources.setItems(newItemList);
        }
        KubernetesList entity = resources;
        Template template = ResourceMojo.getSingletonTemplate(resources);
        if (template != null) {
            entity = template;
        }
        File file = ResourceMojo.writeResource(resourceFileBase, entity, resourceFileType);
        ResourceMojo.writeIndividualResources(resources, resourceFileBase, resourceFileType, log, generateRoute);
        return file;
    }

    private static void writeIndividualResources(KubernetesList resources, File targetDir, ResourceFileType resourceFileType, Logger log, Boolean generateRoute) throws MojoExecutionException {
        for (HasMetadata item : resources.getItems()) {
            String name = KubernetesHelper.getName((HasMetadata)item);
            if (StringUtils.isBlank((CharSequence)name)) {
                log.error("No name for generated item %s", new Object[]{item});
                continue;
            }
            String itemFile = KubernetesResourceUtil.getNameWithSuffix((String)name, (String)item.getKind());
            if (item.getKind().equalsIgnoreCase("Route") && !generateRoute.booleanValue()) continue;
            File itemTarget = new File(targetDir, itemFile);
            ResourceMojo.writeResource(itemTarget, item, resourceFileType);
        }
    }

    private static File writeResource(File resourceFileBase, Object entity, ResourceFileType resourceFileType) throws MojoExecutionException {
        try {
            return ResourceUtil.save((File)resourceFileBase, (Object)entity, (ResourceFileType)resourceFileType);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write resource to " + resourceFileBase + ". " + e, (Exception)e);
        }
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        if (this.skipResource) {
            return;
        }
        this.realResourceDir = ResourceDirCreator.getFinalResourceDir(this.resourceDir, this.environment);
        this.realResourceDirOpenShiftOverride = ResourceDirCreator.getFinalResourceDir(this.resourceDirOpenShiftOverride, this.environment);
        this.updateKindFilenameMappings();
        try {
            this.lateInit();
            File remoteResources = this.resolveRemoteResources();
            this.resolvedImages = this.getResolvedImages(this.images, this.log);
            if (!(this.skip || this.isPomProject() && !this.hasFabric8Dir())) {
                for (PlatformMode platformMode : new PlatformMode[]{PlatformMode.kubernetes, PlatformMode.openshift}) {
                    ResourceClassifier resourceClassifier = platformMode == PlatformMode.kubernetes ? ResourceClassifier.KUBERNETES : ResourceClassifier.OPENSHIFT;
                    KubernetesList resources = this.generateResources(platformMode, this.resolvedImages, remoteResources);
                    this.writeResources(resources, resourceClassifier, this.generateRoute);
                    File resourceDir = new File(this.targetDir, resourceClassifier.getValue());
                    this.validateIfRequired(resourceDir, resourceClassifier);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate fabric8 descriptor", (Exception)e);
        }
    }

    private File resolveRemoteResources() {
        List remotes;
        if (this.resources != null && (remotes = this.resources.getRemotes()) != null && !remotes.isEmpty()) {
            File tempDirectory = FileUtil.createTempDirectory();
            FileUtil.downloadRemotes((File)tempDirectory, (List)remotes, (Logger)this.log);
            return tempDirectory;
        }
        return null;
    }

    private void updateKindFilenameMappings() {
        if (this.mappings != null) {
            HashMap<String, List<String>> mappingKindFilename = new HashMap<String, List<String>>();
            for (MappingConfig mappingConfig : this.mappings) {
                if (mappingConfig.isValid()) {
                    mappingKindFilename.put(mappingConfig.getKind(), Arrays.asList(mappingConfig.getFilenamesAsArray()));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Invalid mapping for Kind %s and Filename Types %s", mappingConfig.getKind(), mappingConfig.getFilenameTypes()));
            }
            KubernetesResourceUtil.updateKindFilenameMapper(mappingKindFilename);
        }
    }

    private void validateIfRequired(File resourceDir, ResourceClassifier classifier) throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.skipResourceValidation.booleanValue()) {
                new ResourceValidator(resourceDir, classifier, this.log).validate();
            }
        }
        catch (ConstraintViolationException e) {
            if (this.failOnValidationError.booleanValue()) {
                this.log.error("[[R]]" + e.getMessage() + "[[R]]", new Object[0]);
                this.log.error("[[R]]use \"mvn -Dfabric8.skipResourceValidation=true\" option to skip the validation[[R]]", new Object[0]);
                throw new MojoFailureException("Failed to generate fabric8 descriptor");
            }
            this.log.warn("[[Y]]" + e.getMessage() + "[[Y]]", new Object[0]);
        }
        catch (Throwable e) {
            if (this.failOnValidationError.booleanValue()) {
                throw new MojoExecutionException("Failed to validate resources", e);
            }
            this.log.warn("Failed to validate resources: %s", new Object[]{e.getMessage()});
        }
    }

    private void lateInit() {
        ClusterAccess clusterAccess = new ClusterAccess(this.getClusterConfiguration());
        this.runtimeMode = new ClusterAccess(this.getClusterConfiguration()).resolveRuntimeMode(this.runtimeMode, this.log);
        if (this.runtimeMode.equals((Object)RuntimeMode.openshift)) {
            Properties properties = this.project.getProperties();
            if (!properties.contains(DOCKER_IMAGE_USER)) {
                String namespace = this.namespace != null && !this.namespace.isEmpty() ? this.namespace : clusterAccess.getNamespace();
                this.log.info("Using docker image name of namespace: " + namespace, new Object[0]);
                properties.setProperty(DOCKER_IMAGE_USER, namespace);
            }
            if (!properties.contains("fabric8.internal.effective.platform.mode")) {
                properties.setProperty("fabric8.internal.effective.platform.mode", this.runtimeMode.toString());
            }
        }
    }

    private KubernetesList generateResources(PlatformMode platformMode, List<ImageConfiguration> images, File remoteResources) throws IOException, MojoExecutionException {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            this.resources = new ResourceConfig.Builder(this.resources).withNamespace(this.namespace).build();
        }
        MavenEnricherContext.Builder ctxBuilder = new MavenEnricherContext.Builder().project(this.project).session(this.session).config(this.extractEnricherConfig()).settings(this.settings).properties(this.project.getProperties()).resources(this.resources).images(this.resolvedImages).log(this.log);
        EnricherManager enricherManager = new EnricherManager(this.resources, (EnricherContext)ctxBuilder.build(), MavenUtil.getCompileClasspathElementsIfRequested((MavenProject)this.project, (boolean)this.useProjectClasspath));
        KubernetesListBuilder builder = this.generateAppResources(platformMode, images, enricherManager, remoteResources);
        this.addProfiledResourcesFromSubirectories(platformMode, builder, this.realResourceDir, enricherManager);
        return builder.build();
    }

    private void addProfiledResourcesFromSubirectories(PlatformMode platformMode, KubernetesListBuilder builder, File resourceDir, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        File[] profileDirs = resourceDir.listFiles(pathname -> pathname.isDirectory());
        if (profileDirs != null) {
            for (File profileDir : profileDirs) {
                Profile profile = ProfileUtil.findProfile((String)profileDir.getName(), (File)resourceDir);
                if (profile == null) {
                    throw new MojoExecutionException(String.format("Invalid profile '%s' given as directory in %s. Please either define a profile of this name or move this directory away", profileDir.getName(), resourceDir));
                }
                ProcessorConfig enricherConfig = profile.getEnricherConfig();
                File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)profileDir);
                if (resourceFiles.length <= 0) continue;
                KubernetesListBuilder profileBuilder = this.readResourceFragments(platformMode, resourceFiles);
                enricherManager.createDefaultResources(platformMode, enricherConfig, profileBuilder);
                enricherManager.enrich(platformMode, enricherConfig, profileBuilder);
                KubernetesList profileItems = profileBuilder.build();
                for (HasMetadata item : profileItems.getItems()) {
                    builder.addToItems(new HasMetadata[]{item});
                }
            }
        }
    }

    private KubernetesListBuilder generateAppResources(PlatformMode platformMode, List<ImageConfiguration> images, EnricherManager enricherManager, File remoteResources) throws IOException, MojoExecutionException {
        try {
            KubernetesListBuilder builder = this.processResourceFragments(platformMode, remoteResources);
            enricherManager.createDefaultResources(platformMode, builder);
            enricherManager.enrich(platformMode, builder);
            return builder;
        }
        catch (ConstraintViolationException e) {
            String message = ValidationUtil.createValidationMessage((Set)e.getConstraintViolations());
            this.log.error("ConstraintViolationException: %s", new Object[]{message});
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
    }

    private KubernetesListBuilder processResourceFragments(PlatformMode platformMode, File remoteResources) throws IOException, MojoExecutionException {
        KubernetesListBuilder builder;
        Object[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)this.realResourceDir);
        if (remoteResources != null && remoteResources.isDirectory()) {
            Object[] remoteFragments = remoteResources.listFiles();
            resourceFiles = (File[])ArrayUtils.addAll((Object[])resourceFiles, (Object[])remoteFragments);
        }
        if (resourceFiles != null && resourceFiles.length > 0) {
            this.log.info("using resource templates from %s", new Object[]{this.realResourceDir});
            builder = this.readResourceFragments(platformMode, (File[])resourceFiles);
        } else {
            builder = new KubernetesListBuilder();
        }
        return builder;
    }

    private KubernetesListBuilder readResourceFragments(PlatformMode platformMode, File[] resourceFiles) throws IOException, MojoExecutionException {
        String defaultName = MavenUtil.createDefaultResourceName((String)this.project.getArtifactId(), (String[])new String[0]);
        KubernetesListBuilder builder = KubernetesResourceUtil.readResourceFragmentsFrom((PlatformMode)platformMode, (ResourceVersioning)KubernetesResourceUtil.DEFAULT_RESOURCE_VERSIONING, (String)defaultName, (File[])this.mavenFilterFiles(resourceFiles, this.workDir));
        return builder;
    }

    private ProcessorConfig extractEnricherConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.realResourceDir, (ProcessorConfig)this.enricher);
    }

    private ProcessorConfig extractGeneratorConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.realResourceDir, (ProcessorConfig)this.generator);
    }

    private List<ImageConfiguration> getResolvedImages(List<ImageConfiguration> images, Logger log) throws MojoExecutionException {
        List ret = ConfigHelper.resolveImages((Logger)log, images, image -> this.imageConfigResolver.resolve(image, this.project, this.session), null, configs -> {
            try {
                GeneratorContext ctx = new GeneratorContext.Builder().config(this.extractGeneratorConfig()).project(this.project).runtimeMode(this.runtimeMode).logger(log).strategy(this.buildStrategy).useProjectClasspath(this.useProjectClasspath).build();
                return GeneratorManager.generate(configs, ctx, true);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot extract generator: " + e, e);
            }
        });
        Date now = this.getBuildReferenceDate();
        this.storeReferenceDateInPluginContext(now);
        String minimalApiVersion = ConfigHelper.initAndValidate((List)ret, null, (ConfigHelper.NameFormatter)new ImageNameFormatter(this.project, now), (Logger)log);
        return ret;
    }

    private void storeReferenceDateInPluginContext(Date now) {
        Map pluginContext = this.getPluginContext();
        pluginContext.put("CONTEXT_KEY_BUILD_TIMESTAMP", now);
    }

    private Date getBuildReferenceDate() throws MojoExecutionException {
        File tsFile = new File(this.project.getBuild().getDirectory(), "docker/build.timestamp");
        if (!tsFile.exists()) {
            return new Date();
        }
        try {
            return EnvUtil.loadTimestamp((File)tsFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read timestamp from " + tsFile, (Exception)e);
        }
    }

    private File[] mavenFilterFiles(File[] resourceFiles, File outDir) throws MojoExecutionException {
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new MojoExecutionException("Cannot create working dir " + outDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(outDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new MojoExecutionException(String.format("Cannot filter %s to %s", resource, targetFile), (Exception)((Object)exp));
            }
        }
        return ret;
    }

    private boolean hasFabric8Dir() {
        return this.realResourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }

    protected void writeResources(KubernetesList resources, ResourceClassifier classifier, Boolean generateRoute) throws MojoExecutionException {
        File resourceFileBase = new File(this.targetDir, classifier.getValue());
        File file = ResourceMojo.writeResourcesIndividualAndComposite(resources, resourceFileBase, this.resourceFileType, this.log, generateRoute);
        this.projectHelper.attachArtifact(this.project, this.resourceFileType.getArtifactType(), classifier.getValue(), file);
    }

    @Override
    protected ClusterConfiguration getClusterConfiguration() {
        ClusterConfiguration.Builder clusterConfigurationBuilder = new ClusterConfiguration.Builder(this.access);
        return clusterConfigurationBuilder.from(System.getProperties()).from(this.project.getProperties()).build();
    }
}

