/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.access.ClusterConfiguration;
import io.fabric8.maven.core.config.MappingConfig;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.Profile;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.core.util.ResourceVersioning;
import io.fabric8.maven.core.util.ValidationUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.core.util.validator.ResourceValidator;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.maven.plugin.mojo.ResourceDirCreator;
import io.fabric8.maven.plugin.mojo.build.ResourceMojoUtil;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;

@Mojo(name="resource", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractFabric8Mojo {
    private static final String DOCKER_MAVEN_PLUGIN_KEY = "io.fabric8:docker-maven-plugin";
    private static final String DOCKER_IMAGE_USER = "docker.image.user";
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.targetDir", defaultValue="${project.build.outputDirectory}/META-INF/fabric8")
    protected File targetDir;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.resourceDirOpenShiftOverride", defaultValue="${basedir}/src/main/fabric8-openshift-override")
    private File resourceDirOpenShiftOverride;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.environment")
    private String environment;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.workDir", defaultValue="${project.build.directory}/fabric8")
    private File workDir;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.workDirOpenShiftOverride", defaultValue="${project.build.directory}/fabric8-openshift-override")
    private File workDirOpenShiftOverride;
    @org.apache.maven.plugins.annotations.Parameter
    private ResourceConfig resources;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.mode")
    private RuntimeMode runtimeMode = RuntimeMode.DEFAULT;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.skipResourceValidation", defaultValue="false")
    private Boolean skipResourceValidation;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.failOnValidationError", defaultValue="false")
    private Boolean failOnValidationError;
    @org.apache.maven.plugins.annotations.Parameter
    private List<ImageConfiguration> images;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.build.switchToDeployment", defaultValue="false")
    private Boolean switchToDeployment;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.profile")
    private String profile;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.gitRemote")
    private String gitRemote;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.domain")
    private String routeDomain;
    @org.apache.maven.plugins.annotations.Parameter
    private ProcessorConfig enricher;
    @org.apache.maven.plugins.annotations.Parameter
    private ProcessorConfig generator;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    @org.apache.maven.plugins.annotations.Parameter
    private List<MappingConfig> mappings;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.namespace")
    private String namespace;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.sidecar", defaultValue="false")
    private Boolean sidecar;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.skipHealthCheck", defaultValue="false")
    private Boolean skipHealthCheck;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.openshift.deployTimeoutSeconds", defaultValue="3600")
    private Long openshiftDeployTimeoutSeconds;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.openshift.trimImageInContainerSpec", defaultValue="false")
    private Boolean trimImageInContainerSpec;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.openshift.generateRoute", defaultValue="true")
    private Boolean generateRoute;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.openshift.enableAutomaticTrigger", defaultValue="true")
    private Boolean enableAutomaticTrigger;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.openshift.imageChangeTrigger", defaultValue="true")
    private Boolean enableImageChangeTrigger;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.openshift.enrichAllWithImageChangeTrigger", defaultValue="false")
    private Boolean erichAllWithImageChangeTrigger;
    @org.apache.maven.plugins.annotations.Parameter(property="docker.skip.resource", defaultValue="false")
    protected boolean skipResource;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.mergeWithDekorate", defaultValue="false")
    private Boolean mergeWithDekorate;
    @Component
    private MavenProjectHelper projectHelper;
    private File realResourceDir;
    private File realResourceDirOpenShiftOverride;

    public static File writeResourcesIndividualAndComposite(KubernetesList resources, File resourceFileBase, ResourceFileType resourceFileType, Logger log) throws MojoExecutionException {
        ArrayList newItemList = new ArrayList();
        KubernetesList entity = resources;
        Template template = ResourceMojoUtil.getSingletonTemplate(resources);
        if (template != null) {
            entity = template;
        }
        File file = ResourceMojoUtil.writeResource(resourceFileBase, entity, resourceFileType);
        ResourceMojoUtil.writeIndividualResources(resources, resourceFileBase, resourceFileType, log);
        return file;
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        if (this.skipResource) {
            return;
        }
        if (ResourceMojoUtil.useDekorate(this.project) && this.mergeWithDekorate.booleanValue()) {
            this.log.info("Dekorate detected, merging fabric8 and Dekorate resources", new Object[0]);
            System.setProperty("dekorate.input.dir", "META-INF/fabric8");
            System.setProperty("dekorate.output.dir", "META-INF/fabric8");
        } else if (ResourceMojoUtil.useDekorate(this.project)) {
            this.log.info("Dekorate detected, delegating resource build", new Object[0]);
            System.setProperty("dekorate.output.dir", "META-INF/fabric8");
            return;
        }
        this.realResourceDir = ResourceDirCreator.getFinalResourceDir(this.resourceDir, this.environment);
        this.realResourceDirOpenShiftOverride = ResourceDirCreator.getFinalResourceDir(this.resourceDirOpenShiftOverride, this.environment);
        this.updateKindFilenameMappings();
        try {
            this.lateInit();
            this.resolvedImages = this.getResolvedImages(this.images, this.log);
            if (!(this.skip || this.isPomProject() && !this.hasFabric8Dir())) {
                for (PlatformMode platformMode : new PlatformMode[]{PlatformMode.kubernetes, PlatformMode.openshift}) {
                    ResourceClassifier resourceClassifier = platformMode == PlatformMode.kubernetes ? ResourceClassifier.KUBERNETES : ResourceClassifier.OPENSHIFT;
                    KubernetesList resources = this.generateResources(platformMode);
                    this.writeResources(resources, resourceClassifier);
                    File resourceDir = new File(this.targetDir, resourceClassifier.getValue());
                    this.validateIfRequired(resourceDir, resourceClassifier);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate fabric8 descriptor", (Exception)e);
        }
    }

    private void updateKindFilenameMappings() {
        if (this.mappings != null) {
            HashMap<String, List<String>> mappingKindFilename = new HashMap<String, List<String>>();
            for (MappingConfig mappingConfig : this.mappings) {
                if (mappingConfig.isValid()) {
                    mappingKindFilename.put(mappingConfig.getKind(), Arrays.asList(mappingConfig.getFilenamesAsArray()));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Invalid mapping for Kind %s and Filename Types %s", mappingConfig.getKind(), mappingConfig.getFilenameTypes()));
            }
            KubernetesResourceUtil.updateKindFilenameMapper(mappingKindFilename);
        }
    }

    private void validateIfRequired(File resourceDir, ResourceClassifier classifier) throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.skipResourceValidation.booleanValue()) {
                new ResourceValidator(resourceDir, classifier, this.log).validate();
            }
        }
        catch (ConstraintViolationException e) {
            if (this.failOnValidationError.booleanValue()) {
                this.log.error("[[R]]" + e.getMessage() + "[[R]]", new Object[0]);
                this.log.error("[[R]]use \"mvn -Dfabric8.skipResourceValidation=true\" option to skip the validation[[R]]", new Object[0]);
                throw new MojoFailureException("Failed to generate fabric8 descriptor");
            }
            this.log.warn("[[Y]]" + e.getMessage() + "[[Y]]", new Object[0]);
        }
        catch (Throwable e) {
            if (this.failOnValidationError.booleanValue()) {
                throw new MojoExecutionException("Failed to validate resources", e);
            }
            this.log.warn("Failed to validate resources: %s", new Object[]{e.getMessage()});
        }
    }

    private void lateInit() {
        ClusterAccess clusterAccess = new ClusterAccess(this.getClusterConfiguration());
        this.runtimeMode = new ClusterAccess(this.getClusterConfiguration()).resolveRuntimeMode(this.runtimeMode, this.log);
        if (this.runtimeMode.equals((Object)RuntimeMode.openshift)) {
            Properties properties = this.project.getProperties();
            if (!properties.contains(DOCKER_IMAGE_USER)) {
                String namespace = this.namespace != null && !this.namespace.isEmpty() ? this.namespace : clusterAccess.getNamespace();
                this.log.info("Using Container image name of namespace: " + namespace, new Object[0]);
                properties.setProperty(DOCKER_IMAGE_USER, namespace);
            }
            if (!properties.contains("fabric8.internal.effective.platform.mode")) {
                properties.setProperty("fabric8.internal.effective.platform.mode", this.runtimeMode.toString());
            }
        }
    }

    private KubernetesList generateResources(PlatformMode platformMode) throws IOException, MojoExecutionException {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            this.resources = new ResourceConfig.Builder(this.resources).withNamespace(this.namespace).build();
        }
        if (this.routeDomain != null && !this.routeDomain.isEmpty()) {
            this.resources = new ResourceConfig.Builder(this.resources).withRouteDomain(this.routeDomain).build();
        }
        MavenEnricherContext.Builder ctxBuilder = new MavenEnricherContext.Builder().project(this.project).session(this.session).config(this.extractEnricherConfig()).images(this.resolvedImages).settings(this.settings).properties(this.project.getProperties()).resources(this.resources).images(this.resolvedImages).log(this.log);
        EnricherManager enricherManager = new EnricherManager(this.resources, (EnricherContext)ctxBuilder.build(), MavenUtil.getCompileClasspathElementsIfRequested((MavenProject)this.project, (boolean)this.useProjectClasspath));
        KubernetesListBuilder builder = this.generateAppResources(platformMode, enricherManager);
        this.addProfiledResourcesFromSubirectories(platformMode, builder, this.realResourceDir, enricherManager);
        return builder.build();
    }

    private void addProfiledResourcesFromSubirectories(PlatformMode platformMode, KubernetesListBuilder builder, File resourceDir, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        File[] profileDirs = resourceDir.listFiles(pathname -> pathname.isDirectory());
        if (profileDirs != null) {
            for (File profileDir : profileDirs) {
                Profile profile = ProfileUtil.findProfile((String)profileDir.getName(), (File)resourceDir);
                if (profile == null) {
                    throw new MojoExecutionException(String.format("Invalid profile '%s' given as directory in %s. Please either define a profile of this name or move this directory away", profileDir.getName(), resourceDir));
                }
                ProcessorConfig enricherConfig = profile.getEnricherConfig();
                File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)profileDir);
                if (resourceFiles.length <= 0) continue;
                KubernetesListBuilder profileBuilder = this.readResourceFragments(platformMode, resourceFiles);
                enricherManager.createDefaultResources(platformMode, enricherConfig, profileBuilder);
                enricherManager.enrich(platformMode, enricherConfig, profileBuilder);
                KubernetesList profileItems = profileBuilder.build();
                for (HasMetadata item : profileItems.getItems()) {
                    builder.addToItems(new HasMetadata[]{item});
                }
            }
        }
    }

    private KubernetesListBuilder generateAppResources(PlatformMode platformMode, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        try {
            KubernetesListBuilder builder = this.processResourceFragments(platformMode);
            enricherManager.createDefaultResources(platformMode, builder);
            enricherManager.enrich(platformMode, builder);
            return builder;
        }
        catch (ConstraintViolationException e) {
            String message = ValidationUtil.createValidationMessage((Set)e.getConstraintViolations());
            this.log.error("ConstraintViolationException: %s", new Object[]{message});
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
    }

    private KubernetesListBuilder processResourceFragments(PlatformMode platformMode) throws IOException, MojoExecutionException {
        KubernetesListBuilder builder;
        File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)this.realResourceDir, (List)(this.resources != null ? this.resources.getRemotes() : null), (Logger)this.log);
        if (resourceFiles != null && resourceFiles.length > 0) {
            this.log.info("using resource templates from %s", new Object[]{this.realResourceDir});
            builder = this.readResourceFragments(platformMode, resourceFiles);
        } else {
            builder = new KubernetesListBuilder();
        }
        return builder;
    }

    private KubernetesListBuilder readResourceFragments(PlatformMode platformMode, File[] resourceFiles) throws IOException, MojoExecutionException {
        String defaultName = MavenUtil.createDefaultResourceName((String)this.project.getArtifactId(), (String[])new String[0]);
        KubernetesListBuilder builder = KubernetesResourceUtil.readResourceFragmentsFrom((PlatformMode)platformMode, (ResourceVersioning)KubernetesResourceUtil.DEFAULT_RESOURCE_VERSIONING, (String)defaultName, (File[])this.mavenFilterFiles(resourceFiles, this.workDir));
        return builder;
    }

    private ProcessorConfig extractEnricherConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.realResourceDir, (ProcessorConfig)this.enricher);
    }

    private ProcessorConfig extractGeneratorConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.realResourceDir, (ProcessorConfig)this.generator);
    }

    private List<ImageConfiguration> getResolvedImages(List<ImageConfiguration> images, Logger log) throws MojoExecutionException {
        List ret = ConfigHelper.resolveImages((Logger)log, images, image -> this.imageConfigResolver.resolve(image, this.project, this.session), null, configs -> {
            try {
                GeneratorContext ctx = new GeneratorContext.Builder().config(this.extractGeneratorConfig()).project(this.project).runtimeMode(this.runtimeMode).logger(log).strategy(this.buildStrategy).useProjectClasspath(this.useProjectClasspath).build();
                return GeneratorManager.generate(configs, ctx, true);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot extract generator: " + e, e);
            }
        });
        Date now = this.getBuildReferenceDate();
        this.storeReferenceDateInPluginContext(now);
        String minimalApiVersion = ConfigHelper.initAndValidate((List)ret, null, (ConfigHelper.NameFormatter)new ImageNameFormatter(this.project, now), (Logger)log);
        return ret;
    }

    private void storeReferenceDateInPluginContext(Date now) {
        Map pluginContext = this.getPluginContext();
        pluginContext.put("CONTEXT_KEY_BUILD_TIMESTAMP", now);
    }

    private Date getBuildReferenceDate() throws MojoExecutionException {
        File tsFile = new File(this.project.getBuild().getDirectory(), "docker/build.timestamp");
        if (!tsFile.exists()) {
            return new Date();
        }
        try {
            return EnvUtil.loadTimestamp((File)tsFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read timestamp from " + tsFile, (Exception)e);
        }
    }

    private File[] mavenFilterFiles(File[] resourceFiles, File outDir) throws MojoExecutionException {
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new MojoExecutionException("Cannot create working dir " + outDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(outDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new MojoExecutionException(String.format("Cannot filter %s to %s", resource, targetFile), (Exception)((Object)exp));
            }
        }
        return ret;
    }

    private boolean hasFabric8Dir() {
        return this.realResourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }

    protected void writeResources(KubernetesList resources, ResourceClassifier classifier) throws MojoExecutionException {
        File resourceFileBase = new File(this.targetDir, classifier.getValue());
        File file = ResourceMojo.writeResourcesIndividualAndComposite(resources, resourceFileBase, this.resourceFileType, this.log);
        if (classifier == ResourceClassifier.KUBERNETES) {
            this.resolveTemplateVariablesIfAny(resources);
        }
        this.projectHelper.attachArtifact(this.project, this.resourceFileType.getArtifactType(), classifier.getValue(), file);
    }

    private void resolveTemplateVariablesIfAny(KubernetesList resources) throws MojoExecutionException {
        Template template = this.findTemplate(resources);
        if (template != null) {
            List parameters = template.getParameters();
            if (parameters == null || parameters.isEmpty()) {
                return;
            }
            File kubernetesYaml = new File(this.targetDir, "kubernetes.yml");
            this.resolveTemplateVariables(parameters, kubernetesYaml);
        }
    }

    private void resolveTemplateVariables(List<Parameter> parameters, File kubernetesYaml) throws MojoExecutionException {
        String text;
        try {
            text = FileUtils.readFileToString((File)kubernetesYaml, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load " + kubernetesYaml + " so we can replace template expressions " + e, (Exception)e);
        }
        String original = text;
        for (Parameter parameter : parameters) {
            String from = "${" + parameter.getName() + "}";
            String to = parameter.getValue();
            if (to == null) {
                throw new MojoExecutionException("Missing value for HELM template parameter " + from + " in " + kubernetesYaml);
            }
            text = text.replace(from, to);
        }
        if (!original.equals(text)) {
            try {
                FileUtils.writeStringToFile((File)kubernetesYaml, (String)text, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to save " + kubernetesYaml + " after replacing template expressions " + e, (Exception)e);
            }
        }
    }

    private Template findTemplate(KubernetesList resources) {
        return resources.getItems().stream().filter(template -> template instanceof Template).findFirst().orElse(null);
    }

    @Override
    protected ClusterConfiguration getClusterConfiguration() {
        ClusterConfiguration.Builder clusterConfigurationBuilder = new ClusterConfiguration.Builder(this.access);
        return clusterConfigurationBuilder.from(System.getProperties()).from(this.project.getProperties()).build();
    }
}

