/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.service.ApplyService;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.core.util.kubernetes.KubernetesClientUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.maven.plugin.mojo.ResourceDirCreator;
import io.fabric8.openshift.api.model.Project;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="apply", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class ApplyMojo
extends AbstractFabric8Mojo {
    public static final String DEFAULT_KUBERNETES_MANIFEST = "${basedir}/target/classes/META-INF/fabric8/kubernetes.yml";
    public static final String DEFAULT_OPENSHIFT_MANIFEST = "${basedir}/target/classes/META-INF/fabric8/openshift.yml";
    @Parameter(property="fabric8.deploy.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="fabric8.recreate", defaultValue="false")
    protected boolean recreate;
    @Parameter(property="fabric8.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/kubernetes.yml")
    private File kubernetesManifest;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter(property="fabric8.deploy.create", defaultValue="true")
    private boolean createNewResources;
    @Parameter(property="fabric8.rolling", defaultValue="false")
    private boolean rollingUpgrades;
    @Parameter(property="fabric8.deploy.failOnNoKubernetesJson", defaultValue="false")
    private boolean failOnNoKubernetesJson;
    @Parameter(property="fabric8.deploy.servicesOnly", defaultValue="false")
    private boolean servicesOnly;
    @Parameter(property="fabric8.deploy.ignoreServices", defaultValue="false")
    private boolean ignoreServices;
    @Parameter(property="fabric8.deploy.processTemplatesLocally", defaultValue="false")
    private boolean processTemplatesLocally;
    @Parameter(property="fabric8.deploy.deletePods", defaultValue="true")
    private boolean deletePodsOnReplicationControllerUpdate;
    @Parameter(property="fabric8.deploy.ignoreRunningOAuthClients", defaultValue="true")
    private boolean ignoreRunningOAuthClients;
    @Parameter(property="fabric8.deploy.jsonLogDir", defaultValue="${basedir}/target/fabric8/applyJson")
    private File jsonLogDir;
    @Parameter(property="fabric8.serviceUrl.waitSeconds", defaultValue="5")
    protected long serviceUrlWaitTimeSeconds;
    @Parameter(property="fabric8.s2i.buildNameSuffix", defaultValue="-s2i")
    protected String s2iBuildNameSuffix;
    @Parameter
    protected ResourceConfig resources;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.environment")
    private String environment;
    @Parameter(property="fabric8.skip.apply", defaultValue="false")
    protected boolean skipApply;
    private ClusterAccess clusterAccess;
    protected ApplyService applyService;

    @Override
    public void executeInternal() throws MojoExecutionException {
        if (this.skipApply) {
            return;
        }
        this.clusterAccess = new ClusterAccess(this.getClusterConfiguration());
        try {
            KubernetesClient kubernetes = this.clusterAccess.createDefaultClient(this.log);
            this.applyService = new ApplyService(kubernetes, this.log);
            this.initServices(kubernetes, this.log);
            URL masterUrl = kubernetes.getMasterUrl();
            File manifest = OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes) ? this.openshiftManifest : this.kubernetesManifest;
            if (!manifest.exists() || !manifest.isFile()) {
                if (this.failOnNoKubernetesJson) {
                    throw new MojoFailureException("No such generated manifest file: " + manifest);
                }
                this.log.warn("No such generated manifest file %s for this project so ignoring", new Object[]{manifest});
                return;
            }
            String clusterKind = "Kubernetes";
            if (OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes)) {
                clusterKind = "OpenShift";
            }
            KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
            this.log.info("Using %s at %s in namespace %s with manifest %s ", new Object[]{clusterKind, masterUrl, this.clusterAccess.getNamespace(), manifest});
            this.applyService.setAllowCreate(this.createNewResources);
            this.applyService.setServicesOnlyMode(this.servicesOnly);
            this.applyService.setIgnoreServiceMode(this.ignoreServices);
            this.applyService.setLogJsonDir(this.jsonLogDir);
            this.applyService.setBasedir(this.getRootProjectFolder());
            this.applyService.setIgnoreRunningOAuthClients(this.ignoreRunningOAuthClients);
            this.applyService.setProcessTemplatesLocally(this.processTemplatesLocally);
            this.applyService.setDeletePodsOnReplicationControllerUpdate(this.deletePodsOnReplicationControllerUpdate);
            this.applyService.setRollingUpgrade(this.rollingUpgrades);
            this.applyService.setRollingUpgradePreserveScale(this.isRollingUpgradePreserveScale());
            boolean openShift = OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes);
            if (openShift) {
                this.getLog().info((CharSequence)"OpenShift platform detected");
            } else {
                this.disableOpenShiftFeatures(this.applyService);
            }
            Set entities = KubernetesResourceUtil.loadResources((File)manifest);
            String namespace = this.clusterAccess.getNamespace();
            boolean namespaceEntityExist = false;
            for (HasMetadata entity : entities) {
                if (entity instanceof Namespace) {
                    Namespace ns = (Namespace)entity;
                    namespace = ns.getMetadata().getName();
                    this.applyService.applyNamespace(ns);
                    namespaceEntityExist = true;
                    entities.remove(entity);
                    break;
                }
                if (!(entity instanceof Project)) continue;
                Project project = (Project)entity;
                namespace = project.getMetadata().getName();
                this.applyService.applyProject(project);
                namespaceEntityExist = true;
                entities.remove(entity);
                break;
            }
            if (!namespaceEntityExist) {
                this.applyService.applyNamespace(namespace);
            }
            this.applyService.setNamespace(namespace);
            this.applyEntities(kubernetes, namespace, manifest.getName(), entities);
            this.log.info("[[B]]HINT:[[B]] Use the command `%s get pods -w` to watch your pods start up", new Object[]{this.clusterAccess.isOpenShiftImageStream(this.log) ? "oc" : "kubectl"});
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (Logger)this.log);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void initServices(KubernetesClient kubernetes, Logger log) {
    }

    protected void applyEntities(KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        for (HasMetadata entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                this.applyService.applyPod(pod, fileName);
                continue;
            }
            if (entity instanceof Service) {
                Service service = (Service)entity;
                this.applyService.applyService(service, fileName);
                continue;
            }
            if (entity instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)entity;
                this.applyService.applyReplicationController(replicationController, fileName);
                continue;
            }
            if (entity == null) continue;
            this.applyService.apply((Object)entity, fileName);
        }
        Logger serviceLogger = this.createExternalProcessLogger("[[G]][SVC][[G]] ");
        long serviceUrlWaitTimeSeconds = this.serviceUrlWaitTimeSeconds;
        for (HasMetadata entity : entities) {
            if (!(entity instanceof Service)) continue;
            Service service = (Service)entity;
            String name = KubernetesHelper.getName((HasMetadata)service);
            Resource serviceResource = (Resource)((NonNamespaceOperation)kubernetes.services().inNamespace(namespace)).withName(name);
            String url = null;
            int i = 0;
            while ((long)i < serviceUrlWaitTimeSeconds) {
                Service s;
                if (i > 0) {
                    Thread.sleep(1000L);
                }
                if ((s = (Service)serviceResource.get()) != null && StringUtils.isNotBlank((CharSequence)(url = this.getExternalServiceURL(s))) || !this.isExposeService(service)) break;
                ++i;
            }
            serviceUrlWaitTimeSeconds = 1L;
            if (!StringUtils.isNotBlank(url) || !url.startsWith("http")) continue;
            serviceLogger.info("" + name + ": " + url, new Object[0]);
        }
        this.processCustomEntities(kubernetes, namespace, this.resources != null ? this.resources.getCrdContexts() : null, false);
    }

    protected String getExternalServiceURL(Service service) {
        return (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)service).get(Fabric8Annotations.SERVICE_EXPOSE_URL.value());
    }

    protected boolean isExposeService(Service service) {
        String expose = (String)KubernetesHelper.getLabels((HasMetadata)service).get("expose");
        return expose != null && expose.toLowerCase().equals("true");
    }

    public boolean isRollingUpgrades() {
        return this.rollingUpgrades;
    }

    public boolean isRollingUpgradePreserveScale() {
        return false;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected void disableOpenShiftFeatures(ApplyService applyService) {
        this.processTemplatesLocally = true;
        applyService.setSupportOAuthClients(false);
        applyService.setProcessTemplatesLocally(true);
    }

    protected void processCustomEntities(KubernetesClient client, String namespace, List<String> customResourceDefinitions, boolean isDelete) throws Exception {
        if (customResourceDefinitions == null) {
            return;
        }
        List crdContexts = KubernetesClientUtil.getCustomResourceDefinitionContext((KubernetesClient)client, customResourceDefinitions);
        Map<File, String> fileToCrdMap = this.getCustomResourcesFileToNamemap();
        for (CustomResourceDefinitionContext customResourceDefinitionContext : crdContexts) {
            for (Map.Entry<File, String> entry : fileToCrdMap.entrySet()) {
                if (!entry.getValue().equals(customResourceDefinitionContext.getGroup())) continue;
                if (isDelete) {
                    this.applyService.deleteCustomResource(entry.getKey(), namespace, customResourceDefinitionContext);
                    continue;
                }
                this.applyService.applyCustomResource(entry.getKey(), namespace, customResourceDefinitionContext);
            }
        }
    }

    protected Map<File, String> getCustomResourcesFileToNamemap() throws IOException {
        File[] resourceFiles;
        HashMap<File, String> fileToCrdGroupMap = new HashMap<File, String>();
        File resourceDirFinal = ResourceDirCreator.getFinalResourceDir(this.resourceDir, this.environment);
        for (File file : resourceFiles = KubernetesResourceUtil.listResourceFragments((File)resourceDirFinal, (List)(this.resources != null ? this.resources.getRemotes() : null), (Logger)this.log)) {
            Map customResource;
            String apiVersion;
            if (!file.getName().endsWith("cr.yml") && !file.getName().endsWith("cr.yaml") || !(apiVersion = (customResource = KubernetesClientUtil.doReadCustomResourceFile((File)file)).get("apiVersion").toString()).contains("/")) continue;
            fileToCrdGroupMap.put(file, apiVersion.split("/")[0]);
        }
        return fileToCrdGroupMap;
    }

    protected File getRootProjectFolder() {
        File answer = null;
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            File basedir = project.getBasedir();
            if (basedir == null) continue;
            answer = basedir;
        }
        return answer;
    }

    protected MavenProject getRootProject() {
        MavenProject parent;
        MavenProject project = this.getProject();
        while (project != null && (parent = project.getParent()) != null) {
            project = parent;
        }
        return project;
    }
}

