/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.ProjectClassLoaders;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.core.util.ResourceUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

class ResourceMojoUtil {
    static final String DEFAULT_RESOURCE_LOCATION = "META-INF/fabric8";
    private static final String[] DEKORATE_CLASSES = new String[]{"io.dekorate.annotation.Dekorate"};

    private ResourceMojoUtil() {
    }

    static boolean useDekorate(MavenProject project) {
        return new ProjectClassLoaders(MavenUtil.getCompileClassLoader((MavenProject)project)).isClassInCompileClasspath(true, DEKORATE_CLASSES);
    }

    static Template getSingletonTemplate(KubernetesList resources) {
        HasMetadata singleEntity;
        List items;
        if (resources != null && (items = resources.getItems()) != null && items.size() == 1 && (singleEntity = (HasMetadata)items.get(0)) instanceof Template) {
            return (Template)singleEntity;
        }
        return null;
    }

    static void writeIndividualResources(KubernetesList resources, File targetDir, ResourceFileType resourceFileType, Logger log) throws MojoExecutionException {
        for (HasMetadata item : resources.getItems()) {
            String name = KubernetesHelper.getName((HasMetadata)item);
            if (StringUtils.isBlank((CharSequence)name)) {
                log.error("No name for generated item %s", new Object[]{item});
                continue;
            }
            String itemFile = KubernetesResourceUtil.getNameWithSuffix((String)name, (String)item.getKind());
            File itemTarget = new File(targetDir, itemFile);
            ResourceMojoUtil.writeResource(itemTarget, item, resourceFileType);
        }
    }

    static File writeResource(File resourceFileBase, Object entity, ResourceFileType resourceFileType) throws MojoExecutionException {
        try {
            return ResourceUtil.save((File)resourceFileBase, (Object)entity, (ResourceFileType)resourceFileType);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write resource to " + resourceFileBase + ". " + e, (Exception)e);
        }
    }
}

