/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.develop;

import com.google.common.base.Objects;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.core.service.PortForwardService;
import io.fabric8.maven.core.util.kubernetes.KubernetesClientUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.build.ApplyMojo;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="debug", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PACKAGE)
public class DebugMojo
extends ApplyMojo {
    @Parameter(property="fabric8.debug.port", defaultValue="5005")
    private String localDebugPort;
    @Parameter(property="fabric8.debug.suspend", defaultValue="false")
    private boolean debugSuspend;
    private String remoteDebugPort = "5005";
    private Watch podWatcher;
    private CountDownLatch terminateLatch = new CountDownLatch(1);
    private Pod foundPod;
    private Logger podWaitLog;
    private String debugSuspendValue;
    private PortForwardService portForwardService;

    @Override
    protected void initServices(KubernetesClient kubernetes, Logger log) {
        this.portForwardService = new PortForwardService(kubernetes, log);
    }

    @Override
    protected void applyEntities(KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        LabelSelector firstSelector = null;
        for (HasMetadata entity : entities) {
            DeploymentSpec spec;
            Deployment resource;
            String name = KubernetesHelper.getName((HasMetadata)entity);
            LabelSelector selector = null;
            if (entity instanceof Deployment) {
                resource = (Deployment)entity;
                spec = resource.getSpec();
                if (spec != null) {
                    if (this.enableDebugging(entity, spec.getTemplate())) {
                        ((RollableScalableResource)((NonNamespaceOperation)kubernetes.extensions().deployments().inNamespace(namespace)).withName(name)).replace((Object)resource);
                    }
                    selector = KubernetesResourceUtil.getPodLabelSelector((HasMetadata)entity);
                }
            } else if (entity instanceof ReplicaSet) {
                resource = (ReplicaSet)entity;
                spec = resource.getSpec();
                if (spec != null) {
                    if (this.enableDebugging(entity, spec.getTemplate())) {
                        ((RollableScalableResource)((NonNamespaceOperation)kubernetes.extensions().replicaSets().inNamespace(namespace)).withName(name)).replace((Object)resource);
                    }
                    selector = KubernetesResourceUtil.getPodLabelSelector((HasMetadata)entity);
                }
            } else if (entity instanceof ReplicationController) {
                resource = (ReplicationController)entity;
                spec = resource.getSpec();
                if (spec != null) {
                    if (this.enableDebugging(entity, spec.getTemplate())) {
                        ((RollableScalableResource)((NonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name)).replace((Object)resource);
                    }
                    selector = KubernetesResourceUtil.getPodLabelSelector((HasMetadata)entity);
                }
            } else if (entity instanceof DeploymentConfig && (spec = (resource = (DeploymentConfig)entity).getSpec()) != null) {
                if (this.enableDebugging(entity, spec.getTemplate())) {
                    OpenShiftClient openshiftClient = this.applyService.getOpenShiftClient();
                    if (openshiftClient == null) {
                        this.log.warn("Ignoring DeploymentConfig %s as not connected to an OpenShift cluster", new Object[]{name});
                        continue;
                    }
                    ((DeployableScalableResource)((NonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).withName(name)).replace((Object)resource);
                }
                selector = KubernetesResourceUtil.getPodLabelSelector((HasMetadata)entity);
            }
            if (selector != null) {
                firstSelector = selector;
                continue;
            }
            this.applyService.apply((Object)entity, fileName);
        }
        if (firstSelector != null) {
            TreeMap<String, String> envVars = new TreeMap<String, String>();
            envVars.put("JAVA_ENABLE_DEBUG", "true");
            envVars.put("JAVA_DEBUG_SUSPEND", String.valueOf(this.debugSuspend));
            if (this.debugSuspendValue != null) {
                envVars.put("JAVA_DEBUG_SESSION", this.debugSuspendValue);
            }
            String podName = this.waitForRunningPodWithEnvVar(kubernetes, namespace, firstSelector, envVars);
            this.portForward(podName);
        }
    }

    private String waitForRunningPodWithEnvVar(KubernetesClient kubernetes, String namespace, LabelSelector selector, final Map<String, String> envVars) throws MojoExecutionException {
        Pod latestPod;
        FilterWatchListDeletable pods = KubernetesClientUtil.withSelector((NonNamespaceOperation)((NonNamespaceOperation)kubernetes.pods().inNamespace(namespace)), (LabelSelector)selector, (Logger)this.log);
        this.log.info("Waiting for debug pod with selector " + selector + " and environment variables " + envVars, new Object[0]);
        this.podWaitLog = this.createExternalProcessLogger("[[Y]][W][[Y]] ");
        PodList list = (PodList)pods.list();
        if (list != null && (latestPod = KubernetesResourceUtil.getNewestPod((Collection)list.getItems())) != null && this.podHasEnvVars(latestPod, envVars)) {
            return KubernetesHelper.getName((HasMetadata)latestPod);
        }
        this.podWatcher = (Watch)pods.watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                DebugMojo.this.podWaitLog.info(KubernetesHelper.getName((HasMetadata)pod) + " status: " + KubernetesClientUtil.getPodStatusDescription((Pod)pod) + KubernetesClientUtil.getPodStatusMessagePostfix((Watcher.Action)action), new Object[0]);
                if (DebugMojo.this.isAddOrModified(action) && KubernetesHelper.isPodRunning((Pod)pod) && KubernetesHelper.isPodReady((Pod)pod) && DebugMojo.this.podHasEnvVars(pod, envVars)) {
                    DebugMojo.this.foundPod = pod;
                    DebugMojo.this.terminateLatch.countDown();
                }
            }

            public void onClose(KubernetesClientException e) {
            }
        });
        while (this.terminateLatch.getCount() > 0L) {
            try {
                this.terminateLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.foundPod == null) continue;
            return KubernetesHelper.getName((HasMetadata)this.foundPod);
        }
        throw new MojoExecutionException("Could not find a running pod with environment variables " + envVars);
    }

    private boolean isAddOrModified(Watcher.Action action) {
        return action.equals((Object)Watcher.Action.ADDED) || action.equals((Object)Watcher.Action.MODIFIED);
    }

    private boolean podHasEnvVars(Pod pod, Map<String, String> envVars) {
        for (String envVarName : envVars.keySet()) {
            String envVarValue;
            if (this.podHasEnvVarValue(pod, envVarName, envVarValue = envVars.get(envVarName))) continue;
            return false;
        }
        return true;
    }

    private boolean podHasEnvVarValue(Pod pod, String envVarName, String envVarValue) {
        Container container;
        List env;
        List containers;
        PodSpec spec = pod.getSpec();
        if (spec != null && (containers = spec.getContainers()) != null && !containers.isEmpty() && (env = (container = (Container)containers.get(0)).getEnv()) != null) {
            for (EnvVar envVar : env) {
                if (!Objects.equal((Object)envVar.getName(), (Object)envVarName) || !Objects.equal((Object)envVar.getValue(), (Object)envVarValue)) continue;
                return true;
            }
        }
        return false;
    }

    private void portForward(String podName) throws MojoExecutionException {
        try {
            this.portForwardService.forwardPort(this.createExternalProcessLogger("[[B]]port-forward[[B]] "), podName, this.portToInt(this.remoteDebugPort, "remoteDebugPort"), this.portToInt(this.localDebugPort, "localDebugPort"));
            this.log.info("", new Object[0]);
            this.log.info("Now you can start a Remote debug execution in your IDE by using localhost and the debug port " + this.localDebugPort, new Object[0]);
            this.log.info("", new Object[0]);
        }
        catch (Fabric8ServiceException e) {
            throw new MojoExecutionException("Failed to start port forwarding" + (Object)((Object)e), (Exception)((Object)e));
        }
    }

    private boolean enableDebugging(HasMetadata entity, PodTemplateSpec template) {
        PodSpec podSpec;
        if (template != null && (podSpec = template.getSpec()) != null) {
            List containers = podSpec.getContainers();
            boolean enabled = false;
            for (int i = 0; i < containers.size(); ++i) {
                ArrayList ports;
                Container container = (Container)containers.get(i);
                ArrayList env = container.getEnv();
                if (env == null) {
                    env = new ArrayList();
                }
                this.remoteDebugPort = KubernetesResourceUtil.getEnvVar(env, (String)"JAVA_DEBUG_PORT", (String)"5005");
                if (KubernetesResourceUtil.setEnvVar(env, (String)"JAVA_ENABLE_DEBUG", (String)"true")) {
                    container.setEnv(env);
                    enabled = true;
                }
                if (KubernetesResourceUtil.setEnvVar(env, (String)"JAVA_DEBUG_SUSPEND", (String)String.valueOf(this.debugSuspend))) {
                    container.setEnv(env);
                    enabled = true;
                }
                if ((ports = container.getPorts()) == null) {
                    ports = new ArrayList();
                }
                if (KubernetesResourceUtil.addPort(ports, (String)this.remoteDebugPort, (String)"debug", (Logger)this.log)) {
                    container.setPorts(ports);
                    enabled = true;
                }
                if (this.debugSuspend) {
                    this.debugSuspendValue = String.valueOf(new Random().nextLong());
                    KubernetesResourceUtil.setEnvVar(env, (String)"JAVA_DEBUG_SESSION", (String)this.debugSuspendValue);
                    container.setEnv(env);
                    if (container.getReadinessProbe() != null) {
                        this.log.info("Readiness probe will be disabled on " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity) + " to allow attaching a remote debugger during suspension", new Object[0]);
                        container.setReadinessProbe(null);
                    }
                    enabled = true;
                    continue;
                }
                if (!KubernetesResourceUtil.removeEnvVar(env, (String)"JAVA_DEBUG_SESSION")) continue;
                container.setEnv(env);
                enabled = true;
            }
            if (enabled) {
                this.log.info("Enabling debug on " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
                return true;
            }
        }
        return false;
    }

    private int portToInt(String port, String name) throws MojoExecutionException {
        try {
            int portInt = Integer.parseInt(port);
            return portInt;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Invalid port value: " + name + "=" + port);
        }
    }
}

