/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.service.kubernetes.jib.JibServiceUtil;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.Fabric8MavenPluginDeprecationUtil;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.maven.plugin.mojo.ResourceDirCreator;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="push", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PushMojo
extends AbstractDockerMojo {
    @Parameter
    private ProcessorConfig generator;
    @Parameter(property="fabric8.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.environment")
    private String environment;
    @Parameter(property="fabric8.mode")
    private RuntimeMode mode = RuntimeMode.auto;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="docker.source.dir", defaultValue="src/main/docker")
    private String sourceDirectory;
    @Parameter(property="fabric8.build.jib", defaultValue="false")
    private boolean isJib;
    @Parameter(property="docker.push.retries", defaultValue="0")
    private int retries;
    @Parameter(property="docker.skip.push", defaultValue="false")
    private boolean fabric8SkipPush;
    @Parameter(alias="pushRegistry", property="docker.push.registry")
    private String fabric8PushRegistry;
    @Parameter(alias="outputDirectory", property="docker.target.dir", defaultValue="target/docker")
    private String fabric8OutputDirectory;
    @Parameter(property="docker.skip.tag", defaultValue="false")
    private boolean skipTag;
    @Parameter(property="fabric8.logDeprecationWarning", defaultValue="true")
    protected boolean logDeprecationWarning;

    protected String getLogPrefix() {
        return "F8> ";
    }

    protected boolean isJibMode() {
        return this.isJib || Configs.asBoolean((String)this.getProperty("fabric8.build.jib"));
    }

    protected boolean isDockerAccessRequired() {
        return !this.isJibMode();
    }

    private String getProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = this.project.getProperties().getProperty(key);
        }
        return value;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.fabric8SkipPush) {
            return;
        }
        Fabric8MavenPluginDeprecationUtil.logFabric8MavenPluginDeprecation((Logger)this.log, (boolean)this.logDeprecationWarning);
        super.execute();
        Fabric8MavenPluginDeprecationUtil.logFabric8MavenPluginDeprecation((Logger)this.log, (boolean)this.logDeprecationWarning);
    }

    public void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.fabric8SkipPush) {
            return;
        }
        if (this.isJibMode()) {
            for (ImageConfiguration imageConfiguration : this.getResolvedImages()) {
                JibServiceUtil.jibPush((ImageConfiguration)imageConfiguration, (MavenProject)this.project, (RegistryService.RegistryConfig)this.getRegistryConfig(this.fabric8PushRegistry), (String)this.fabric8OutputDirectory, (Logger)this.log);
            }
        } else {
            hub.getRegistryService().pushImages((Collection)this.getResolvedImages(), this.retries, this.getRegistryConfig(this.fabric8PushRegistry), this.skipTag);
        }
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        try {
            ProcessorConfig generatorConfig = ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)ResourceDirCreator.getFinalResourceDir(this.resourceDir, this.environment), (ProcessorConfig)this.generator);
            GeneratorContext ctx = new GeneratorContext.Builder().config(generatorConfig).project(this.project).logger(this.log).runtimeMode(this.mode).strategy(this.buildStrategy).useProjectClasspath(false).build();
            return GeneratorManager.generate(configs, ctx, true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + e, e);
        }
    }
}

