/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.watcher;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.PluginServiceFactory;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.watcher.api.Watcher;
import io.fabric8.maven.watcher.api.WatcherContext;
import java.util.List;
import java.util.Set;

public class WatcherManager {
    public static void watch(List<ImageConfiguration> ret, Set<HasMetadata> resources, WatcherContext watcherCtx) throws Exception {
        PluginServiceFactory pluginFactory = watcherCtx.isUseProjectClasspath() ? new PluginServiceFactory((Object)watcherCtx, new ClassLoader[]{ClassUtil.createProjectClassLoader((List)watcherCtx.getProject().getCompileClasspathElements(), (Logger)watcherCtx.getLogger())}) : new PluginServiceFactory((Object)watcherCtx, new ClassLoader[0]);
        boolean isOpenshift = OpenshiftHelper.isOpenShift((KubernetesClient)watcherCtx.getKubernetesClient());
        PlatformMode mode = isOpenshift ? PlatformMode.openshift : PlatformMode.kubernetes;
        List watchers = pluginFactory.createServiceObjects(new String[]{"META-INF/fabric8/watcher-default", "META-INF/fabric8/fabric8-watcher-default", "META-INF/fabric8/watcher", "META-INF/fabric8-watcher"});
        ProcessorConfig config = watcherCtx.getConfig();
        Logger log = watcherCtx.getLogger();
        List usableWatchers = config.prepareProcessors(watchers, "watcher");
        log.verbose(Logger.LogVerboseCategory.BUILD, "Watchers:", new Object[0]);
        Watcher chosen = null;
        for (Watcher watcher : usableWatchers) {
            if (watcher.isApplicable(ret, resources, mode)) {
                if (chosen == null) {
                    log.verbose(Logger.LogVerboseCategory.BUILD, " - %s [selected]", new Object[]{watcher.getName()});
                    chosen = watcher;
                    continue;
                }
                log.verbose(Logger.LogVerboseCategory.BUILD, " - %s", new Object[]{watcher.getName()});
                continue;
            }
            log.verbose(Logger.LogVerboseCategory.BUILD, " - %s [not applicable]", new Object[]{watcher.getName()});
        }
        if (chosen == null) {
            throw new IllegalStateException("No watchers can be used for the current project");
        }
        log.info("Running watcher %s", new Object[]{chosen.getName()});
        chosen.watch(ret, resources, mode);
    }
}

