/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.xml.ModuleXmlParser;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.modules.NestedJarResourceLoader;
import org.wildfly.swarm.bootstrap.performance.Performance;

public class BootstrapClasspathModuleFinder
implements ModuleFinder {
    private static final char MODULE_SEPARATOR = '/';

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModuleSpec findModule(ModuleIdentifier identifier, ModuleLoader delegateLoader) throws ModuleLoadException {
        try (AutoCloseable handle = Performance.accumulate("module: BootstrapClassPath");){
            String path = "modules/" + identifier.getName().replace('.', '/') + '/' + identifier.getSlot() + "/module.xml";
            ClassLoader cl = BootstrapClasspathModuleFinder.class.getClassLoader();
            URL url = cl.getResource(path);
            if (url == null) {
                ModuleSpec moduleSpec = null;
                return moduleSpec;
            }
            ModuleSpec moduleSpec = null;
            InputStream in = null;
            try {
                URL base = new URL(url, "./");
                in = url.openStream();
                moduleSpec = ModuleXmlParser.parseModuleXml((rootPath, loaderPath, loaderName) -> NestedJarResourceLoader.loaderFor(base, rootPath, loaderPath, loaderName), MavenResolvers.get(), "/", in, path.toString(), delegateLoader, identifier);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ModuleLoadException(e);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new ModuleLoadException(e);
                }
            }
            ModuleSpec moduleSpec2 = moduleSpec;
            return moduleSpec2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

