/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.jboss.modules.maven.MavenResolver;
import org.wildfly.swarm.bootstrap.performance.Performance;

public class MultiMavenResolver
implements MavenResolver {
    private List<MavenResolver> resolvers = new ArrayList<MavenResolver>();

    public void addResolver(MavenResolver resolver) {
        this.resolvers.add(resolver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File resolveArtifact(ArtifactCoordinates coordinates, String packaging) throws IOException {
        try (AutoCloseable handle = Performance.accumulate("artifact-resolver");){
            for (MavenResolver resolver : this.resolvers) {
                File result = resolver.resolveArtifact(coordinates, packaging);
                if (result == null) continue;
                File file = result;
                return file;
            }
            Iterator<MavenResolver> iterator = null;
            return iterator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

