/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.stat;

import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.gitective.core.stat.UserCommitActivity;
import org.gitective.core.stat.YearCommitActivity;

public class CommitCalendar
implements Serializable {
    private static final long serialVersionUID = -3909996432477594787L;
    private final Map<Integer, YearCommitActivity> years = new TreeMap<Integer, YearCommitActivity>();

    public CommitCalendar(UserCommitActivity[] activity) {
        GregorianCalendar calendar = new GregorianCalendar(Locale.US);
        int length = activity.length;
        for (int i = 0; i < length; ++i) {
            for (long time : activity[i].getTimes()) {
                calendar.setTimeInMillis(time);
                int year = calendar.get(1);
                YearCommitActivity yearly = this.years.get(year);
                if (yearly == null) {
                    yearly = new YearCommitActivity(year);
                    this.years.put(year, yearly);
                }
                yearly.add(calendar);
            }
        }
    }

    public YearCommitActivity[] getYears() {
        return this.years.values().toArray(new YearCommitActivity[this.years.size()]);
    }

    public int[] getMonths() {
        int[] months = new int[12];
        for (YearCommitActivity year : this.years.values()) {
            year.getMonths(months);
        }
        return months;
    }

    public int[] getDays() {
        int[] days = new int[31];
        for (YearCommitActivity year : this.years.values()) {
            year.getDays(days);
        }
        return days;
    }

    public int[] getHours() {
        int[] hours = new int[24];
        for (YearCommitActivity year : this.years.values()) {
            year.getHours(hours);
        }
        return hours;
    }

    public int getMonthCount(int month) {
        int total = 0;
        for (YearCommitActivity year : this.years.values()) {
            total += year.getMonthCount(month);
        }
        return total;
    }

    public int getHourCount(int hour) {
        int total = 0;
        for (YearCommitActivity year : this.years.values()) {
            total += year.getHourCount(hour);
        }
        return total;
    }

    public int getDayCount(int dayOfMonth) {
        int total = 0;
        for (YearCommitActivity year : this.years.values()) {
            total += year.getDayCount(dayOfMonth);
        }
        return total;
    }

    public int getCount() {
        int total = 0;
        for (YearCommitActivity year : this.years.values()) {
            total += year.getCount();
        }
        return total;
    }
}

