/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.repo.git;

import io.fabric8.repo.git.CreateRepositoryDTO;
import io.fabric8.repo.git.CreateWebhookDTO;
import io.fabric8.repo.git.GitApi;
import io.fabric8.repo.git.OrganisationDTO;
import io.fabric8.repo.git.RepositoryDTO;
import io.fabric8.repo.git.WebHookDTO;
import io.fabric8.utils.jaxrs.JAXRSClients;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.WebApplicationException;

public abstract class GitRepoClientSupport {
    protected final String address;
    protected final String username;
    protected final String password;
    private GitApi api;

    public GitRepoClientSupport(String address, String username, String password) {
        this.address = address;
        this.password = password;
        this.username = username;
    }

    public GitRepoClientSupport(String address, String username) {
        this.username = username;
        this.address = address;
        this.password = null;
    }

    public List<RepositoryDTO> listRepositories() {
        return this.getApi().listRepositories();
    }

    public List<RepositoryDTO> listOrganisationRepositories(String organisation) {
        return this.getApi().listOrganisationRepositories(organisation);
    }

    public List<OrganisationDTO> listUserOrganisations() {
        return this.getApi().listUserOrganisations();
    }

    public RepositoryDTO getRepository(final String owner, final String repo) {
        return (RepositoryDTO)JAXRSClients.handle404ByReturningNull((Callable)new Callable<RepositoryDTO>(){

            @Override
            public RepositoryDTO call() throws Exception {
                return GitRepoClientSupport.this.getApi().getRepository(owner, repo);
            }
        });
    }

    public RepositoryDTO getOrganisationRepository(final String organisation, final String repo) {
        return (RepositoryDTO)JAXRSClients.handle404ByReturningNull((Callable)new Callable<RepositoryDTO>(){

            @Override
            public RepositoryDTO call() throws Exception {
                return GitRepoClientSupport.this.getApi().getOrganisationRepository(organisation, repo);
            }
        });
    }

    public InputStream getRawFile(String username, String repo, String branch, String path) {
        try {
            return this.getApi().getRawFile(username, repo, branch, path);
        }
        catch (WebApplicationException e) {
            int status = e.getResponse().getStatus();
            if (status == 500 || status == 404) {
                return null;
            }
            throw e;
        }
    }

    public WebHookDTO createWebhook(String owner, String repo, CreateWebhookDTO dto) {
        return this.getApi().createWebhook(owner, repo, dto);
    }

    public List<WebHookDTO> getWebhooks(String owner, String repo) {
        return this.getApi().getWebhooks(owner, repo);
    }

    public RepositoryDTO createRepository(CreateRepositoryDTO createRepository) {
        return this.getApi().createRepository(createRepository);
    }

    protected GitApi getApi() {
        if (this.api == null) {
            this.api = this.createWebClient(GitApi.class);
        }
        return this.api;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    protected abstract <T> T createWebClient(Class<T> var1);
}

