/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettings;
import io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluent;
import io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsTLSmode;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClientTLSSettingsFluentImpl<A extends ClientTLSSettingsFluent<A>>
extends BaseFluent<A>
implements ClientTLSSettingsFluent<A> {
    private String caCertificates;
    private String clientCertificate;
    private String credentialName;
    private Boolean insecureSkipVerify;
    private ClientTLSSettingsTLSmode mode;
    private String privateKey;
    private String sni;
    private List<String> subjectAltNames;

    public ClientTLSSettingsFluentImpl() {
    }

    public ClientTLSSettingsFluentImpl(ClientTLSSettings instance) {
        this.withCaCertificates(instance.getCaCertificates());
        this.withClientCertificate(instance.getClientCertificate());
        this.withCredentialName(instance.getCredentialName());
        this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
        this.withMode(instance.getMode());
        this.withPrivateKey(instance.getPrivateKey());
        this.withSni(instance.getSni());
        this.withSubjectAltNames(instance.getSubjectAltNames());
    }

    @Override
    public String getCaCertificates() {
        return this.caCertificates;
    }

    @Override
    public A withCaCertificates(String caCertificates) {
        this.caCertificates = caCertificates;
        return (A)this;
    }

    @Override
    public Boolean hasCaCertificates() {
        return this.caCertificates != null;
    }

    @Override
    @Deprecated
    public A withNewCaCertificates(String arg0) {
        return this.withCaCertificates(new String(arg0));
    }

    @Override
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @Override
    public A withClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return (A)this;
    }

    @Override
    public Boolean hasClientCertificate() {
        return this.clientCertificate != null;
    }

    @Override
    @Deprecated
    public A withNewClientCertificate(String arg0) {
        return this.withClientCertificate(new String(arg0));
    }

    @Override
    public String getCredentialName() {
        return this.credentialName;
    }

    @Override
    public A withCredentialName(String credentialName) {
        this.credentialName = credentialName;
        return (A)this;
    }

    @Override
    public Boolean hasCredentialName() {
        return this.credentialName != null;
    }

    @Override
    @Deprecated
    public A withNewCredentialName(String arg0) {
        return this.withCredentialName(new String(arg0));
    }

    @Override
    public Boolean getInsecureSkipVerify() {
        return this.insecureSkipVerify;
    }

    @Override
    public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
        this.insecureSkipVerify = insecureSkipVerify;
        return (A)this;
    }

    @Override
    public Boolean hasInsecureSkipVerify() {
        return this.insecureSkipVerify != null;
    }

    @Override
    public ClientTLSSettingsTLSmode getMode() {
        return this.mode;
    }

    @Override
    public A withMode(ClientTLSSettingsTLSmode mode) {
        this.mode = mode;
        return (A)this;
    }

    @Override
    public Boolean hasMode() {
        return this.mode != null;
    }

    @Override
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public A withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return (A)this;
    }

    @Override
    public Boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    @Override
    @Deprecated
    public A withNewPrivateKey(String arg0) {
        return this.withPrivateKey(new String(arg0));
    }

    @Override
    public String getSni() {
        return this.sni;
    }

    @Override
    public A withSni(String sni) {
        this.sni = sni;
        return (A)this;
    }

    @Override
    public Boolean hasSni() {
        return this.sni != null;
    }

    @Override
    @Deprecated
    public A withNewSni(String arg0) {
        return this.withSni(new String(arg0));
    }

    @Override
    public A addToSubjectAltNames(Integer index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSubjectAltNames(Integer index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSubjectAltNames(String ... items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjectAltNames(Collection<String> items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjectAltNames(String ... items) {
        for (String item : items) {
            if (this.subjectAltNames == null) continue;
            this.subjectAltNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjectAltNames(Collection<String> items) {
        for (String item : items) {
            if (this.subjectAltNames == null) continue;
            this.subjectAltNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSubjectAltNames() {
        return this.subjectAltNames;
    }

    @Override
    public String getSubjectAltName(Integer index) {
        return this.subjectAltNames.get(index);
    }

    @Override
    public String getFirstSubjectAltName() {
        return this.subjectAltNames.get(0);
    }

    @Override
    public String getLastSubjectAltName() {
        return this.subjectAltNames.get(this.subjectAltNames.size() - 1);
    }

    @Override
    public String getMatchingSubjectAltName(Predicate<String> predicate) {
        for (String item : this.subjectAltNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubjectAltName(Predicate<String> predicate) {
        for (String item : this.subjectAltNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjectAltNames(List<String> subjectAltNames) {
        if (subjectAltNames != null) {
            this.subjectAltNames = new ArrayList<String>();
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        } else {
            this.subjectAltNames = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjectAltNames(String ... subjectAltNames) {
        if (this.subjectAltNames != null) {
            this.subjectAltNames.clear();
        }
        if (subjectAltNames != null) {
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjectAltNames() {
        return this.subjectAltNames != null && !this.subjectAltNames.isEmpty();
    }

    @Override
    public A addNewSubjectAltName(String arg0) {
        return this.addToSubjectAltNames(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTLSSettingsFluentImpl that = (ClientTLSSettingsFluentImpl)o;
        if (this.caCertificates != null ? !this.caCertificates.equals(that.caCertificates) : that.caCertificates != null) {
            return false;
        }
        if (this.clientCertificate != null ? !this.clientCertificate.equals(that.clientCertificate) : that.clientCertificate != null) {
            return false;
        }
        if (this.credentialName != null ? !this.credentialName.equals(that.credentialName) : that.credentialName != null) {
            return false;
        }
        if (this.insecureSkipVerify != null ? !this.insecureSkipVerify.equals(that.insecureSkipVerify) : that.insecureSkipVerify != null) {
            return false;
        }
        if (this.mode != null ? !this.mode.equals((Object)that.mode) : that.mode != null) {
            return false;
        }
        if (this.privateKey != null ? !this.privateKey.equals(that.privateKey) : that.privateKey != null) {
            return false;
        }
        if (this.sni != null ? !this.sni.equals(that.sni) : that.sni != null) {
            return false;
        }
        return !(this.subjectAltNames != null ? !this.subjectAltNames.equals(that.subjectAltNames) : that.subjectAltNames != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.caCertificates, this.clientCertificate, this.credentialName, this.insecureSkipVerify, this.mode, this.privateKey, this.sni, this.subjectAltNames, super.hashCode()});
    }
}

