package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvoyFilterPatchBuilder extends EnvoyFilterPatchFluentImpl<EnvoyFilterPatchBuilder> implements VisitableBuilder<io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatch,io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatchBuilder>{
  public EnvoyFilterPatchBuilder() {
    this(false);
  }
  public EnvoyFilterPatchBuilder(Boolean validationEnabled) {
    this(new EnvoyFilterPatch(), validationEnabled);
  }
  public EnvoyFilterPatchBuilder(EnvoyFilterPatchFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvoyFilterPatchBuilder(io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatchFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EnvoyFilterPatch(), validationEnabled);
  }
  public EnvoyFilterPatchBuilder(io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatchFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatch instance) {
    this(fluent, instance, false);
  }
  public EnvoyFilterPatchBuilder(io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatchFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatch instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFilterClass(instance.getFilterClass()); 
    fluent.withOperation(instance.getOperation()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public EnvoyFilterPatchBuilder(io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatch instance) {
    this(instance,false);
  }
  public EnvoyFilterPatchBuilder(io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatch instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFilterClass(instance.getFilterClass()); 
    this.withOperation(instance.getOperation()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatchFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1alpha3.EnvoyFilterPatch build() {
    EnvoyFilterPatch buildable = new EnvoyFilterPatch(fluent.getFilterClass(),fluent.getOperation(),fluent.getValue());
    return buildable;
  }
  
}