package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRedirectBuilder extends HTTPRedirectFluentImpl<HTTPRedirectBuilder> implements VisitableBuilder<io.fabric8.istio.api.networking.v1alpha3.HTTPRedirect,io.fabric8.istio.api.networking.v1alpha3.HTTPRedirectBuilder>{
  public HTTPRedirectBuilder() {
    this(false);
  }
  public HTTPRedirectBuilder(Boolean validationEnabled) {
    this(new HTTPRedirect(), validationEnabled);
  }
  public HTTPRedirectBuilder(HTTPRedirectFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRedirectBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRedirectFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HTTPRedirect(), validationEnabled);
  }
  public HTTPRedirectBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRedirectFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.HTTPRedirect instance) {
    this(fluent, instance, false);
  }
  public HTTPRedirectBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRedirectFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.HTTPRedirect instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRedirectPort(instance.getRedirectPort()); 
    fluent.withAuthority(instance.getAuthority()); 
    fluent.withRedirectCode(instance.getRedirectCode()); 
    fluent.withScheme(instance.getScheme()); 
    fluent.withUri(instance.getUri()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRedirectBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRedirect instance) {
    this(instance,false);
  }
  public HTTPRedirectBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRedirect instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRedirectPort(instance.getRedirectPort()); 
    this.withAuthority(instance.getAuthority()); 
    this.withRedirectCode(instance.getRedirectCode()); 
    this.withScheme(instance.getScheme()); 
    this.withUri(instance.getUri()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1alpha3.HTTPRedirectFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1alpha3.HTTPRedirect build() {
    HTTPRedirect buildable = new HTTPRedirect(fluent.getRedirectPort(),fluent.getAuthority(),fluent.getRedirectCode(),fluent.getScheme(),fluent.getUri());
    return buildable;
  }
  
}