package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRetryBuilder extends HTTPRetryFluentImpl<HTTPRetryBuilder> implements VisitableBuilder<HTTPRetry,io.fabric8.istio.api.networking.v1alpha3.HTTPRetryBuilder>{
  public HTTPRetryBuilder() {
    this(false);
  }
  public HTTPRetryBuilder(Boolean validationEnabled) {
    this(new HTTPRetry(), validationEnabled);
  }
  public HTTPRetryBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRetryFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRetryBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRetryFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HTTPRetry(), validationEnabled);
  }
  public HTTPRetryBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRetryFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.HTTPRetry instance) {
    this(fluent, instance, false);
  }
  public HTTPRetryBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRetryFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.HTTPRetry instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAttempts(instance.getAttempts()); 
    fluent.withPerTryTimeout(instance.getPerTryTimeout()); 
    fluent.withRetryOn(instance.getRetryOn()); 
    fluent.withRetryRemoteLocalities(instance.getRetryRemoteLocalities()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRetryBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRetry instance) {
    this(instance,false);
  }
  public HTTPRetryBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRetry instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAttempts(instance.getAttempts()); 
    this.withPerTryTimeout(instance.getPerTryTimeout()); 
    this.withRetryOn(instance.getRetryOn()); 
    this.withRetryRemoteLocalities(instance.getRetryRemoteLocalities()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1alpha3.HTTPRetryFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1alpha3.HTTPRetry build() {
    HTTPRetry buildable = new HTTPRetry(fluent.getAttempts(),fluent.getPerTryTimeout(),fluent.getRetryOn(),fluent.getRetryRemoteLocalities());
    return buildable;
  }
  
}