package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRouteDestinationBuilder extends HTTPRouteDestinationFluentImpl<HTTPRouteDestinationBuilder> implements VisitableBuilder<io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination,io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestinationBuilder>{
  public HTTPRouteDestinationBuilder() {
    this(false);
  }
  public HTTPRouteDestinationBuilder(Boolean validationEnabled) {
    this(new HTTPRouteDestination(), validationEnabled);
  }
  public HTTPRouteDestinationBuilder(HTTPRouteDestinationFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestinationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HTTPRouteDestination(), validationEnabled);
  }
  public HTTPRouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestinationFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination instance) {
    this(fluent, instance, false);
  }
  public HTTPRouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestinationFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDestination(instance.getDestination()); 
    fluent.withHeaders(instance.getHeaders()); 
    fluent.withWeight(instance.getWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination instance) {
    this(instance,false);
  }
  public HTTPRouteDestinationBuilder(io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDestination(instance.getDestination()); 
    this.withHeaders(instance.getHeaders()); 
    this.withWeight(instance.getWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestinationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination build() {
    HTTPRouteDestination buildable = new HTTPRouteDestination(fluent.getDestination(),fluent.getHeaders(),fluent.getWeight());
    return buildable;
  }
  
}